#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
  variant='FSMR4'
  FSMR4_VARIANT_TYPE=`cat /proc/device-tree/board-identity/product-code | awk -F [.] '{print $2}'`
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

mode='file'
server_response
web_page()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<script>
function onLoad()
{

 //Set State of the windows
   var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
   stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
   stateDocument.getElementById("strt").disabled = false;
}
</script>
</HEAD>
<body onload="onLoad()" bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation Completed!";
</script>

</body>
</html>
EOF
}

web_page_started()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing started(running) MODE: $mode!";
</script>

</body>
</html>
EOF
}

web_page_not_started()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing has Not Started / No Data Available!!!";
</script>

</body>
</html>
EOF
}

web_page_stopped()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing Stopped : No Data Available!";
</script>

</body>
</html>
EOF
}

web_page_stopped_streaming()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing Stopped Streaming!";
</script>

</body>
</html>
EOF
}
web_page_stopped_data_available()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing Stopped : Data Available!";
</script>

</body>
</html>
EOF
}

web_page_gen_pcap_file()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation is interrupted. Please Refresh the page / Abort the Generation to proceed!";
</script>

</body>
</html>
EOF
}

web_page_pcap_file_abrt()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing pcap file Generation Aborted...";
</script>

</body>
</html>
EOF
}

web_page_noactivity()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Local and Remote IP Traffic Capturing...Not started!!</h3>

</body>
</html>
EOF
}

web_page_invalid_mac()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3 id="h1">Local and Remote IP Traffic Capturing Stopped due to invalid configuration!!</h3>';
var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
stateDocument.getElementById("strt").disabled = false;
stateDocument.getElementById("stp").disabled = true;
</script>

</body>
</html>
EOF
}

web_page_mem_failed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing feature disabled..No memory Available, eNB reboot needed to bring-back this functionality...";
var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
var limit1 = stateDocument.forms[0].elements.length;
for(i=0;i<limit1;i++) {
  stateDocument.forms[0].elements[i].disabled = true;
}
var limit2 = stateDocument.forms[1].elements.length;
for(i=0;i<limit2;i++) {
  stateDocument.forms[1].elements[i].disabled = true;
}
</script>

</body>
</html>
EOF
}

web_page_mem_timeout()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Port Mirroring Enable failed with Internal Error... Please Refresh the page";
</script>

</body>
</html>
EOF
}

web_page_no_packet_2()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
  document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing has Not Started / No Data Available!!!";
  var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
</script>
</body>
</html>
EOF
}

web_page_no_packet_buff_fail()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
  document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation failed due to insufficient memory!!!";
  var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
</script>
</body>
</html>
EOF
}

web_page_no_packet_file_fail()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
 document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation failed due to insufficient memory!!!!";
 var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
 stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
 stateDocument.getElementById("strt").disabled = false;
</script>
</body>
</html>
EOF
}


GET_STATUS='gen_pcap_file_done'
started='no'
stopped='no'
genpcap='no'
abarted='no'

web_page_noactivity
#sleep 1
usleep 100000

OUTPUT_OPTION=`cat /tmp/portMirrorringConfTmpFile | grep OUTPUT_OPTION`
OUTPUT_OPTION=${OUTPUT_OPTION/OUTPUT_OPTION /}

STRM_OPTION=`cat /tmp/portMirrorringConfTmpFile | grep STRM_OPTION`
STRM_OPTION=${STRM_OPTION/STRM_OPTION /}

port_name='LMP'
streaming_option=$STRM_OPTION
flag='false'


if [ -f "/tmp/portMirrorringMemFailed" ]; then
    web_page_mem_failed
    exit 0
fi


if [ ! -f "/tmp/portMirrorringMemAllocated" ]; then
    memStatus=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_phy_mem_runtime_allocate_test 38 10 1 | grep "PORT MIRRORRING STATUS"` 
    memStatus=${memStatus/"PORT MIRRORRING STATUS "/""}
    if [ $memStatus == "MEM_FAIL" ]; then
        touch /tmp/portMirrorringMemFailed
        web_page_mem_failed
        exit 0
    elif [ $memStatus == "INTERNAL_ERROR" ]; then
        touch /tmp/portMirrorringMemAllocated
        echo $memStatus > /tmp/portMirrorringMemAllocated
        web_page_mem_timeout
        exit 0
    else
        touch /tmp/portMirrorringMemAllocated
        echo $memStatus > /tmp/portMirrorringMemAllocated
    fi
fi
buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}

if [ $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]; then
	web_page_stopped_data_available
fi

if [ $buffer == "TRAFFIC_CAPTURE_INIT" ]; then
  if [ -f "/tmp/noDataAvailable" ]; then
     web_page_stopped
  else
     web_page_not_started
     break
  fi
elif [ $buffer == "TRAFFIC_CAPTURE_START" ]; then
  if [ $OUTPUT_OPTION == 2 ]; then
    if [ $variant == 'FSMR4' ]; then
      if [ $FSMR4_VARIANT_TYPE == 'X31' ]; then      
        if [ $streaming_option == 20 ]; then
          port_name='AIRSCALE-LMP'
        elif [ $streaming_option == 0 ]; then
          port_name='AIRSCALE-EIF1'
        elif [ $streaming_option == 16 ]; then
          port_name='AIRSCALE-EIF2'
        elif [ $streaming_option == 17 ]; then
          port_name='AIRSCALE-EIF3'
        elif [ $streaming_option == 18 ]; then
          port_name='AIRSCALE-EIF4'
        elif [ $streaming_option == 19 ]; then
          port_name='AIRSCALE-EIF5'
        fi
      else  
        if [ $streaming_option == 20 ]; then
          port_name='AIRSCALE-LMP'
        elif [ $streaming_option == 0 ]; then
          port_name='AIRSCALE-EIF1'
        elif [ $streaming_option == 16 ]; then
          port_name='AIRSCALE-EIF2'
        elif [ $streaming_option == 1 ]; then
          port_name='AIRSCALE-EIF3'
        elif [ $streaming_option == 2 ]; then
          port_name='AIRSCALE-EIF4'
        elif [ $streaming_option == 17 ]; then
          port_name='AIRSCALE-EIF5'
        elif [ $streaming_option == 18 ]; then
          port_name='AIRSCALE-EIF6'
        elif [ $streaming_option == 19 ]; then
          port_name='AIRSCALE-EIF7'
        fi
      fi   
    else
      if [ $streaming_option == 0 ]; then
        port_name='LMP'
      elif [ $streaming_option == 1 ]; then
        port_name='FSM-EIF1'
      elif [ $streaming_option == 2 ]; then
        port_name='FSM-EIF2'
      elif [ $streaming_option == 3 ]; then
        port_name='FTIF-EIF1'
      elif [ $streaming_option == 4 ]; then
        port_name='FTIF-EIF2'
      elif [ $streaming_option == 5 ]; then
        port_name='FTIF-EIF3'
      elif [ $streaming_option == 6 ]; then
        port_name='FTIF-EIF4'
      elif [ $streaming_option == 7 ]; then
        port_name='FSI-EIF1'
      elif [ $streaming_option == 8 ]; then
        port_name='FSI-EIF2'
      elif [ $streaming_option == 9 ]; then
        port_name='FSI-EIF3'
      elif [ $streaming_option == 10 ]; then
        port_name='FSI-EIF4'
      elif [ $streaming_option == 11 ]; then
        port_name='FSI-EIF5'
      fi
  fi
  mode='Streaming'
  mode=$mode' PORT: '$port_name
fi
   
   if [ $flag == 'false' ]; then
       web_page_started
       flag='true'
   fi 
elif [ $buffer == "TRAFFIC_CAPTURE_ABORT" ]; then
    web_page_pcap_file_abrt
    break
elif [ $buffer == "TRAFFIC_CAPTURE_INIT" ]; then
    web_page_not_started

    break
elif [ $buffer == "TRAFFIC_CAPTURE_STOP" ]; then
    if [ $OUTPUT_OPTION == 2 ]; then
        if [ -f "/tmp/invalidMac" ]; then
        web_page_invalid_mac
        else
        web_page_stopped_streaming
        fi
    elif [ $OUTPUT_OPTION == 1 ]; then
       web_page_stopped_data_available
    else
       web_page_stopped
    fi
    break
elif [ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_START" ]; then
   web_page_gen_pcap_file

   PID=`ps -ef | grep "/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_gen_pcap_test" | awk '{print $2}'`
   for tmpPid in `echo $PID` ; do
      /opt/trs/bin/llpd kill -9 $tmpPid  > /dev/null
   done
   /opt/trs/bin/llpd rm -rf /lte1460/portMirroringTmp.*
   /opt/trs/bin/llpd rm -rf /tmp/*_UPLANE.pcap
   /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_set_status_test 2 > /dev/null
elif [ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP" ]; then
   if [ $OUTPUT_OPTION == 2 ]; then
     web_page_not_started
   elif [ -f "/lte1460/portMirroringTmp.zip" ]; then
     web_page
   elif [ -f "/lte1460/portMirroringTmp.pcap.gz" ]; then
     web_page
   elif [ -f "/tmp/portMirroringBuffAccessFail" ]; then
     web_page_no_packet_buff_fail
   elif [ -f "/tmp/portMirroringZipFileCreationFail" ]; then
     web_page_no_packet_file_fail
   else
     web_page_stopped_data_available
   fi
   break 
else
  break 
fi 

