#!/bin/sh

export PATH=$PATH:/usr/local/bin:/bin:/usr/bin:/usr/sbin:/sbin:/opt/trs/bin/
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

. `dirname "$0"`/../cgi-bin/functions

header 1

WEB_RND_OP=/tmp/web_gui_rnd
TRS_RND_FLAG_CHK_FILE=/tmp/trs_rnd_flag
TRS_RND_FLAG_VALUE=$(cat $TRS_RND_FLAG_CHK_FILE 2>/dev/null)
ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 127 >/dev/null
unitIsFzm=$(isFzm)

if [ `wasFsmr3` == 1 ] || [ $unitIsFzm -eq 1 ] || [ `isFsmr4` -eq 1 ];  then
    if [ -e "/tmp/iptables_ports_service.conf" ]; then
        status=`cat /tmp/iptables_ports_service.conf | grep RND_PORTS_SERVICE | sed 's/RND_PORTS_SERVICE=\([0-1]\)/\1/'` 2>/dev/null
    else
        status=0
    fi

    if [ -e "/tmp/iptables_addresses.conf" ]; then
        ETH_PORT_SEC=`cat /tmp/iptables_addresses.conf | grep ETHSEC_ENABLE | sed 's/ETHSEC_ENABLE=\([0-1]\)/\1/'` 2>/dev/null
    else
        ETH_PORT_SEC=1
    fi


    if [ -f $TRS_RND_FLAG_CHK_FILE ] && [ "$TRS_RND_FLAG_VALUE" = "0x00000001" ]; then
        if [ $status = 1 ] ; then
            printf "<p>"
            printf "<h3>R&D Ports Service Status is Enabled</h3>\n"
            printf "</p>"
            if [ $ETH_PORT_SEC = 1 ] ; then
                printf "<p>"
                printf "<h3>Ethernet Port Security Still Enabled</h3>\n"
                printf "</p>"
            fi
        else
            printf "<p>"
            printf "<h3>R&D Ports Service Status is Disabled</h3>\n"
            if [ $ETH_PORT_SEC != 1 ] && [ ! -f $WEB_RND_OP ] ; then
		if [ $unitIsFzm -eq 1 ] ; then
                    printf "<h3>TRSW R&D Flag is active, R&D ports are enabled on all interfaces</h3>\n"
		else
                     printf "<h3>TRSW R&D Flag is active, R&D ports are enabled on the LMP</h3>\n"
		fi
            fi
            printf "</p>"
        fi
    else
        if [ $status = 1 ] ; then
            printf "<p>"
            printf "<h3>R&D Ports Service Status is Enabled</h3>\n"
            printf "</p>"
            if [ $ETH_PORT_SEC = 1 ] ; then
                printf "<p>"
                printf "<h3>Ethernet Port Security Still Enabled</h3>\n"
                printf "</p>"
            fi
        else
            printf "<p>"
            printf "<h3>R&D Ports Service Status is Disabled</h3>\n"
            printf "</p>"
        fi
    fi
fi

footer

