#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

. `dirname "$0"`/../cgi-bin/functions

BUFFER=$(echo $QUERY_STRING | tr '&' ' ' | tr '=' ' ')

printf "Content-Type: text/html\r\n\r\n"

if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
  variant='FSMR4'
  FSMR4_VARIANT_TYPE=`cat /proc/device-tree/board-identity/product-code | awk -F [.] '{print $2}'`
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

capture_point='1' #1 for Cap Point B and 2 for Cap Point A
uplane_payload='0' #uplane capturing enable or disable
timeout='2'
output_option='0' #Output option i.e. 1 for Capturing and 2 for Streaming 
file_option='0'
password=''
streaming_option='0' #Set this to 1 when you use streaming
mac_addr='ff%3Aff%3Aff%3Aff%3Aff%3Aff'
mac_source_streaming=''
mode='file'

port_name='LMP'
param_logging=''
queue_id= 7

web_page_invalid_configuration()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#FF0000" vlink="#600000" alink="#A00000">
        

<script type="text/javascript">
document.body.innerHTML = '<h1 id="h1">Only IP_IUB transport mode is Supported for traffic mirroring</h1>';
document.getElementById("h1").style.color = "red";
document.getElementById("h1").style.fontFamily = "Arial";
document.getElementById("h1").style.fontSize = 30;
</script>

</body>
</html>
EOF
}
web_page_invalid_mac()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3 id="h3">Local and Remote IP Traffic Capturing Stopped due to invalid configuration!!!</h3>';
var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
stateDocument.getElementById("strt").disabled = false;
stateDocument.getElementById("stp").disabled = true;
</script>

</body>
</html>
EOF
}

web_page_started()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">
 	

<script type="text/javascript">
document.body.innerHTML = '<h3 id="h3">Local and Remote IP Traffic Capturing started(running) MODE: $mode!</h3>';
</script>

</body>
</html>
EOF
}

web_page_stopped()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3 id="h3">Local and Remote IP Traffic Capturing Stopped : Data Available!"</h3>';
</script>

</body>
</html>
EOF
}

web_page_no_data_available()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3 id="h3">Local and Remote IP Traffic Capturing Stopped with No Data Available </h3>';
</script>

</body>
</html>
EOF
}

web_page_invalid_start()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">
<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3>Invalid Operation: Local and Remote IP Traffic Capturing can not be started in current condition....!!!</h3>';
</script>
</body>
</html>
EOF
}

web_page_mem_failed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Feature Disabled Due to unavailability of memory...";
</script>

</body>
</html>
EOF
}

web_page_mem_not_allocated()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.body.innerHTML = '<h3 id="h3">Memory is not allocated please refresh the page....!!!</h3>';
</script>

</body>
</html>
EOF
}

started='no'


current_option=''


#header 1
#printf "<h3>Port Mirrorring Argument!!!! </h3>"
  for i in `echo $BUFFER` ; do
    let n=$n+1
    let m=$n%2
    if [ $m == 1 ]; then
      current_option=${i}
#    else
#     printf "%s=%s" ${current_option} ${i}
#     printf "<p></p>"
    fi

    case ${current_option} in
      CapturePoint)
        capture_point=${i}
        ;;
      UserPlane)
        uplane_payload=${i}
        ;;
      duration)
        timeout=${i}
        ;;
      CaptureOption)
        output_option=${i}
        ;;
      CaptureFileOption) # not used
        file_option=${i}
        ;;
      Password) # not used
        password=${i}
        ;;
      streamOption)
        streaming_option=${i}
        ;;
      DstMacAddress)
        mac_addr=${i}
        ;;            
    esac    
  done

valid_syntax=1

# CapturePoint)
if [[ "$capture_point" != @(A|B|1|2) ]]; then # pelase verify what are expected valid values
  valid_syntax=0
  capture_point='1'
fi

# UserPlane)
if [[ "$uplane_payload" != @(0|1) ]]; then # pelase verify what are expected valid values
  valid_syntax=0
  uplane_payload='0'
fi

# duration)
if [[ "$timeout" != +([[:digit:]]) ]] || [ ${#timeout} -gt 9 ]; then # pelase verify what are expected valid values
  valid_syntax=0
  timeout='2'
fi

# CaptureOption)
if [[ "$output_option" != @(0|1|2) ]]; then # pelase verify what are expected valid values
  valid_syntax=0
  output_option='0'
fi

# streamOption)
if [[ "$streaming_option" != +([[:digit:]]) ]] || [ ${#streaming_option} -gt 9 ]; then # pelase verify what are expected valid values
  valid_syntax=0
  streaming_option='0'
fi

# DstMacAddress)
if [[ "$mac_addr" != [[:xdigit:]][[:xdigit:]]@(:|%3A|%3a)[[:xdigit:]][[:xdigit:]]@(:|%3A|%3a)[[:xdigit:]][[:xdigit:]]@(:|%3A|%3a)[[:xdigit:]][[:xdigit:]]@(:|%3A|%3a)[[:xdigit:]][[:xdigit:]]@(:|%3A|%3a)[[:xdigit:]][[:xdigit:]] ]]; then
    if [[ "$mac_addr" != [[:xdigit:]][[:xdigit:]]@(-|%2D|%2d)[[:xdigit:]][[:xdigit:]]@(-|%2D|%2d)[[:xdigit:]][[:xdigit:]]@(-|%2D|%2d)[[:xdigit:]][[:xdigit:]]@(-|%2D|%2d)[[:xdigit:]][[:xdigit:]]@(-|%2D|%2d)[[:xdigit:]][[:xdigit:]] ]]; then
      valid_syntax=0
      mac_addr='ff%3Aff%3Aff%3Aff%3Aff%3Aff'
    fi
fi

 
if [ $valid_syntax == 0 ] ; then
  web_page_invalid_mac
  $buffer = "TRAFFIC_CAPTURE_STOP"
fi

#printf "%s %s %s %s %s %s %s %s" $capture_point $uplane_payload $timeout $output_option $file_option $password $streaming_option $mac_addr 
#printf "<p></p>"

#footer

delimit=`echo $mac_addr | cut -b3`
replaceBy=""
replaceChar=""

if [ $delimit == - ]; then
    replaceChar="-"
    replaceBy="-"
elif [ $delimit == % ]; then
    replaceChar="\%3A"
    replaceBy=":"
fi

mac_addr_logs=$(echo $mac_addr | sed "s/$replaceChar/$replaceBy/g")
mac_addr_hex=$(echo $mac_addr | sed "s/$replaceChar/""/g")
mac_addr_colon=$(echo $mac_addr | sed "s/$replaceChar/":"/g")
mac_addr_hex="0x"$mac_addr_hex

if [ $variant == FSMR4 ]; then
  if [ $FSMR4_VARIANT_TYPE == X31 ]; then  
    if [ $streaming_option == 0 ]; then
      touch /tmp/ethlmp0
      port_name='AIRSCALE-LMP'
      streaming_option=20
    elif [ $streaming_option == 1 ]; then
      touch /tmp/ncpeth0
      port_name='AIRSCALE-EIF1'
      streaming_option=0
    elif [ $streaming_option == 2 ]; then
      touch /tmp/ncpeth16
      port_name='AIRSCALE-EIF2'
      streaming_option=16
    elif [ $streaming_option == 3 ]; then
      touch /tmp/ncpeth17
      port_name='AIRSCALE-EIF3'
      streaming_option=17
    elif [ $streaming_option == 4 ]; then
      touch /tmp/ncpeth18
      port_name='AIRSCALE-EIF4'
      streaming_option=18
    elif [ $streaming_option == 5 ]; then
      touch /tmp/ncpeth19
      port_name='AIRSCALE-EIF5'
      streaming_option=19
    fi
  else  
    if [ $streaming_option == 0 ]; then
      touch /tmp/ethlmp0
      port_name='AIRSCALE-LMP'
      streaming_option=20
    elif [ $streaming_option == 1 ]; then
      touch /tmp/ncpeth0
      port_name='AIRSCALE-EIF1'
      streaming_option=0
    elif [ $streaming_option == 2 ]; then
      touch /tmp/ncpeth16
      port_name='AIRSCALE-EIF2'
      streaming_option=16
    elif [ $streaming_option == 3 ]; then
      touch /tmp/ncpeth1
      port_name='AIRSCALE-EIF3'
      streaming_option=1
    elif [ $streaming_option == 4 ]; then
      touch /tmp/ncpeth2
      port_name='AIRSCALE-EIF4'
      streaming_option=2
    elif [ $streaming_option == 5 ]; then
      touch /tmp/ncpeth17
      port_name='AIRSCALE-EIF5'
      streaming_option=17
    elif [ $streaming_option == 6 ]; then
      touch /tmp/ncpeth18
      port_name='AIRSCALE-EIF6'
      streaming_option=18
    elif [ $streaming_option == 7 ]; then
      touch /tmp/ncpeth19
      port_name='AIRSCALE-EIF7'
      streaming_option=19
    fi
  fi  
else
  if [ $streaming_option == 0 ]; then
    port_name='LMP'
  elif [ $streaming_option == 1 ]; then
    port_name='FSM-EIF1'
  elif [ $streaming_option == 2 ]; then
    port_name='FSM-EIF2'
  elif [ $streaming_option == 3 ]; then
    port_name='FTIF-EIF1'
  elif [ $streaming_option == 4 ]; then
    port_name='FTIF-EIF2'
  elif [ $streaming_option == 5 ]; then
    port_name='FTIF-EIF3'
  elif [ $streaming_option == 6 ]; then
    port_name='FTIF-EIF4'
  elif [ $streaming_option == 7 ]; then
    port_name='FSI-EIF1'
  elif [ $streaming_option == 8 ]; then
    port_name='FSI-EIF2'
  elif [ $streaming_option == 9 ]; then
    port_name='FSI-EIF3'
  elif [ $streaming_option == 10 ]; then
    port_name='FSI-EIF4'
  elif [ $streaming_option == 11 ]; then
    port_name='FSI-EIF5'
  fi
fi

capture_point_text='A-Capture IP traffic to/from the BTS and SSE'
if [ $capture_point == 1 ]; then
   capture_point_text='B-Capture IP traffic to/from the BTS and SSE at the transport network interfaces'
fi

uplane_capture_text='Enable'
if [ $uplane_payload == 0 ]; then
   uplane_capture_text='Disable'
fi

output_option_text='File'
if [ $output_option == 2 ]; then
   output_option_text='Streaming'
fi

if [ -f "/tmp/portMirrorringMemFailed" ]; then
    web_page_mem_failed
    exit 0
fi

if [ ! -f "/tmp/portMirrorringMemAllocated" ]; then
    web_page_mem_not_allocated
    exit 0
fi

buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}


PROD_TYPE=`/opt/trs/bin/test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//'`
TRAN_MODE=$(echo `/opt/trs/bin/objcli tls_wcdma_get_transport_mode | awk 'NR==1{print $5;}'`)

if  [ "$PROD_TYPE" != "WCDMA" ]  ||  [ "$TRAN_MODE" == "IP_IUB" ]  ;  then
if [[ $buffer == "TRAFFIC_CAPTURE_INIT" || $buffer == "TRAFFIC_CAPTURE_STOP" || $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP" || $buffer == "TRAFFIC_CAPTURE_ABORT" || $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]]; then
 #Execute the FP command to start the port mirrorring
 if [ $output_option == 2 ]; then
     mode='Streaming'
     mode=$mode' PORT: '$port_name
 else
     port_name=''
     mac_addr_colon=''
     mac_addr_logs=''
 fi
 # dump to standard out
 echo CAPTURE_POINT $capture_point > /tmp/portMirrorringConfTmpFile
 echo USER_PLANE $uplane_payload >> /tmp/portMirrorringConfTmpFile
 echo OUTPUT_OPTION $output_option >> /tmp/portMirrorringConfTmpFile
 echo STRM_OPTION $streaming_option >> /tmp/portMirrorringConfTmpFile
 echo DST_MAC $mac_addr >> /tmp/portMirrorringConfTmpFile
 
 BTS_ID=`/opt/trs/bin/llpd /opt/trs/bin/objcli port_mirroring get_btsid | grep BTS_ID`
 BTS_ID=${BTS_ID/\> BTS_ID /}
 CAP_TIME=`date "+%Y%m%dT%H%M%S"`
 filename=$BTS_ID"_"$CAP_TIME
 echo FILE_NAME $filename >> /tmp/portMirrorringConfTmpFile
 /opt/trs/bin/llpd rm -rf /lte1460/portMirroringTmp.* > /dev/null
 /opt/trs/bin/llpd rm -rf /tmp/invalidMac > /dev/null
 /opt/trs/bin/llpd rm -rf /tmp/noDataAvailable > /dev/null
 /opt/trs/bin/llpd rm -rf /tmp/portMirroringBuffAccessFail > /dev/null
 /opt/trs/bin/llpd rm -rf /tmp/portMirroringZipFileCreationFail > /dev/null
 if [ -f /opt/trs/bin/trafficCapturing ]
 then
   if [ $capture_point == 1 ]; then
     /opt/trs/bin/objcli SwitchToSidebandMode true > /dev/null
     touch /tmp/LTE1460IPSEC
   fi
 fi
if [ $variant == FSMR4 ]; then
/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_start_test $capture_point $uplane_payload $output_option $streaming_option $mac_addr_colon     > /dev/null
    if [ $output_option == 2 ]; then
        /opt/trs/bin/llpd ${CAPTURING_BIN} trafficcapture set_task_prio 7         > /dev/null
    fi 
 buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
 buffer=${buffer/"PORT MIRRORRING STATUS "/""}
 if [ $buffer == "TRAFFIC_CAPTURE_START" ]; then
     if [ $output_option == 2 ]; then
         logger -s "LTE1460 : Traffic streaming started on $port_name with dest MAC $mac_addr_logs"
     else
         logger -s "LTE1460 : Traffic capturing started"
     fi
 fi
 if [ $buffer == "MEM_FAIL" ]; then
     web_page_mem_failed
     exit 0
 fi
 else
/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_start_test $capture_point $uplane_payload $output_option $streaming_option $mac_addr_hex > /dev/null
fi

UNIT_FZM=`/opt/trs/bin/test_envInfo envInfoUnitTypeIsFzm | grep "UNIT_FZM"`
if [ UNIT_FZM == "$UNIT_FZM" ]; then
    #Enable FP PS command trace for UPLANE Capture
    if [ 1 == $uplane_payload ]; then
        echo 1 >> /tmp/fuse/iwf/trace_release
        if [ 1 == $output_option ]; then
            echo 2097152 >> /tmp/fuse/iwf/trace_capacity
            echo 1 >> /tmp/fuse/iwf/tracing_on
        else
            if [ LMP == "$port_name" ]; then
               mac_source_streaming=`/sbin/ifconfig eth1 | sed -e '/HWaddr/ !d;s/.*HWaddr //;s/)$//'`
               echo `/opt/trs/bin/llpd /usr/bin/fpctrl getport eth1` > /tmp/fuse/iwf/trace_port
            else
               mac_source_streaming=`/sbin/ifconfig br0 | sed -e '/HWaddr/ !d;s/.*HWaddr //;s/)$//'`
               echo `/opt/trs/bin/llpd /usr/bin/fpctrl getport eth0` > /tmp/fuse/iwf/trace_port
            fi
            echo $mac_source_streaming > /tmp/fuse/iwf/trace_ether_senb
            echo $mac_addr_colon > /tmp/fuse/iwf/trace_ether_dhost
            echo 2 >> /tmp/fuse/iwf/tracing_on
        fi
    fi
fi
 if [ UNIT_FZM == "$UNIT_FZM" ]; then
 buffer="TRAFFIC_CAPTURE_START"
else
 buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
 buffer=${buffer/"PORT MIRRORRING STATUS "/""}
 fi
 if [ $buffer == "TRAFFIC_CAPTURE_STOP" ]; then
   touch /tmp/invalidMac
   web_page_invalid_mac
   param_logging='(capture point:'$capture_point_text', uplane capture:'$uplane_capture_text', capture option:'$output_option_text', port name:'$port_name', dst mac address:'$mac_addr_logs')'
   /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 147 "$param_logging"> /dev/null
   exit 0
 fi

param_logging='(capture point:'$capture_point_text', uplane capture:'$uplane_capture_text', capture option:'$output_option_text', port name:'$port_name', dst mac address:'$mac_addr_logs')'
 if [ $output_option == 1 ]; then
     /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 140 "$param_logging"> /dev/null
 else
     /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 141 "$param_logging"> /dev/null
 fi
 /opt/trs/bin/objcli port_mirroring raise_alarm start  $REMOTE_USER $REMOTE_ADDR $port_name $mac_addr_logs> /dev/null
 web_page_started
 if [ UNIT_FZM != "$UNIT_FZM" ]; then
 while [ 1 ]
 do
  buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
  buffer=${buffer/"PORT MIRRORRING STATUS "/""}
  if [ $buffer != "TRAFFIC_CAPTURE_START" ]; then
     break
  fi
  sleep 5
 done
 fi
 if [[ $buffer == "TRAFFIC_CAPTURE_INIT" || $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]]; then
    if [ $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]; then
        /opt/trs/bin/objcli port_mirroring raise_alarm stop > /dev/null
        web_page_stopped
    else
        web_page_no_data_available
        if [ $variant == FSMR4 ]; then
            /opt/trs/bin/objcli port_mirroring raise_alarm stop > /dev/null
        fi
    fi
 elif [[ $buffer == "TRAFFIC_CAPTURE_STOP" ]]; then
	/opt/trs/bin/objcli port_mirroring raise_alarm stop > /dev/null
 else
    web_page_stopped
 fi
else
 web_page_invalid_start
fi
else
 web_page_invalid_configuration
fi

