#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

printf "Content-Type: text/html\r\n\r\n"

if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
  variant='FSMR4'
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

function web_page_stopping()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h3">Stopping Local and Remote IP Traffic Capturing!</h3>

</body>
</html>
EOF
}

web_page_stopped()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Stopped : Data Available!";
</script>

</body>
</html>
EOF
}

web_page_stopped_streaming()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Stopped Streaming!";
</script>

</body>
</html>
EOF
}

web_page_no_data_available()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Stopped : No Data Available!";
</script>

</body>
</html>
EOF
}

web_page_invalid_stop()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3>Invalid Operation: Local and Remote IP Traffic Capturing : Not started!</h3>';
</script>

</body>
</html>
EOF
}

web_page_mem_failed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Feature Disabled Due to unavailability of memory...";
</script>

</body>
</html>
EOF
}

web_page_mem_not_allocated()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.body.innerHTML = '<h3 id="h3">Memory is not allocated please refresh the page....!!!</h3>';
</script>

</body>
</html>
EOF
}

if [ -f "/tmp/portMirrorringMemFailed" ]; then
    web_page_mem_failed
    exit 0
fi

if [ ! -f "/tmp/portMirrorringMemAllocated" ]; then
    web_page_mem_not_allocated
    exit 0
fi

if [ -f /tmp/LTE1460IPSEC ]
then
  /opt/trs/bin/objcli SwitchToSidebandMode false > /dev/null
  rm /tmp/LTE1460IPSEC
fi


OUTPUT_OPTION=`cat /tmp/portMirrorringConfTmpFile | grep OUTPUT_OPTION`
OUTPUT_OPTION=${OUTPUT_OPTION/OUTPUT_OPTION /}

USER_PLANE=`cat /tmp/portMirrorringConfTmpFile | grep USER_PLANE`
USER_PLANE=${USER_PLANE/USER_PLANE /}

UNIT_FZM=`/opt/trs/bin/test_envInfo envInfoUnitTypeIsFzm | grep "UNIT_FZM"`
if [ UNIT_FZM == "$UNIT_FZM" ]; then
    if [ 1 == $USER_PLANE ]; then
        echo 0 >> /tmp/fuse/iwf/tracing_on
    fi
fi


buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}
if [ $buffer == "TRAFFIC_CAPTURE_START" ]; then
  web_page_stopping
  /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_stop_test > /dev/null
  if [ $variant == FSMR4 ]; then
      logger -s "LTE1460 : Traffic streaming/capturing stopped"
  fi
  /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 142 > /dev/null
  /opt/trs/bin/objcli port_mirroring raise_alarm stop > /dev/null
else
  web_page_invalid_stop
  exit 0
fi

buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}
if [ $buffer == "TRAFFIC_CAPTURE_INIT" ]; then
  web_page_no_data_available
  touch /tmp/noDataAvailable
else
   if [ $OUTPUT_OPTION == 2 ]; then
      web_page_stopped_streaming
   else
      web_page_stopped
   fi
fi

