#!/bin/sh

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

if [ "x${ROOT_DIR}" = "x/tmp/SIM" ]; then
    simulation=1
else
    simulation=0
fi

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${ROOT_DIR}/opt/trs/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

machine=`uname -m`

if [ "$machine" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi

if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/srv" ]; then 
    ACTIVE_SRV_DIR="${OURPATH}/srv"
else
    ACTIVE_SRV_DIR="${ROOT_DIR}/usr/local/srv"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

. ${FUNCTIONS}

test_envInfo envInfoUnitType >/dev/null
UNIT=$?

if [ $simulation -ne 0 ]; then
    LOGDIR=${ROOT_DIR}/var/log
else
    LOGDIR=${ROOT_DIR}/ffs/run/logs
    STBLOGDIR=${ROOT_DIR}/ffs/stb/logs
fi

if test "$machine" = 'armv5teb'; then
    errorSetFileName="ErrorTrace"
    test_envInfo envInfoOcteonAvailable > /dev/null
    if [ $? ]; then
        OctSys="OCT_System"
    else
        OctSys=""
    fi
else
    errorSetFileName="TraceLog"
    OctSys="LCP_System"
fi

# enable shell variables
set +o nounset

echo 
echo "**********************************************"
echo "*       SW Release Version                   *"
echo "**********************************************"
echo
cat "${ACTIVE_SRV_DIR}/targetBD.xml" | grep "softwareReleaseVersion" | sed 's/softwareReleaseVersion=//'
echo

#New default long format for Traces.log
newFtmLong="%n (%i) %S %C %dz %l \"%c\" PID %p TID %P CT %T"

# Current reset count
x=`test_hlEeprom getResetCnt allResets | /usr/bin/awk '/Function returns/ {print $3}' 2>/dev/null`

# Do we have the startup traces of 3rd last start
if [[ -f ${LOGDIR}/${errorSetFileName}.$(($x-3)) ]]; then # older
    echo "**********************************************"
    echo "*         U N I T  R E S E T                 *"
    echo "**********************************************"
    # Show traces of 3rd last start
    ukpt -fmt "$newFtmLong" -pmd $(($x-3)) $OctSys System 2>/dev/null
else
    if [[ -f ${STBLOGDIR}/${errorSetFileName}.$(($x-3)) ]]; then # older
        echo "**********************************************"
        echo "*         U N I T  R E S E T                 *"
        echo "**********************************************"
        # Show traces of 3rd last start
        ukpt -l -pmd ${STBLOGDIR}/${errorSetFileName}.$(($x-3)) $OctSys System 2>/dev/null
    else
        echo "**********************************************"
        echo "* Traces from reset number $(($x-3)) not available *"
        echo "**********************************************"
    fi
fi

# Do we have the startup traces of 2nd last start
if [[ -f ${LOGDIR}/${errorSetFileName}.$(($x-2)) ]]; then # older
    echo "**********************************************"
    echo "*         U N I T  R E S E T                 *"
    echo "**********************************************"
    # Show traces of 2nd last start
    ukpt -fmt "$newFtmLong" -pmd $(($x-2)) $OctSys System 2>/dev/null
else
    if [[ -f ${STBLOGDIR}/${errorSetFileName}.$(($x-2)) ]]; then # older
      echo "**********************************************"
      echo "*         U N I T  R E S E T                 *"
      echo "**********************************************"
        # Show traces of 2nd last start
        ukpt -l -pmd ${STBLOGDIR}/${errorSetFileName}.$(($x-2)) $OctSys System 2>/dev/null
    else
      echo "**********************************************"
      echo "* Traces from reset number $(($x-2)) not available *"
      echo "**********************************************"
    fi
fi

# Do we have the traces of last startup
if [[ -f ${LOGDIR}/${errorSetFileName}.$(($x-1)) ]] ; then # old
    echo "**********************************************"
    echo "*         U N I T  R E S E T                 *"
    echo "**********************************************"
    # Show traces of last start
    ukpt -fmt "$newFtmLong" -pmd $(($x-1)) $OctSys System 2>/dev/null
else
    if [[ -f ${STBLOGDIR}/${errorSetFileName}.$(($x-1)) ]]; then # older
        echo "**********************************************"
        echo "*         U N I T  R E S E T                 *"
        echo "**********************************************"
        # Show traces of last start
        ukpt -l -pmd ${STBLOGDIR}/${errorSetFileName}.$(($x-1)) $OctSys System 2>/dev/null
    else
        echo "**********************************************"
        echo "* Traces from reset number $(($x-1)) not available *"
        echo "**********************************************"
    fi
fi
# Get reset cause
test_envInfo envInfoResetCause > /dev/null
resetCause=$?

# We do have the trace of current start
echo "**********************************************"
echo "*         U N I T  R E S E T                 *"
case $resetCause in
 1) echo "Last reset cause: Power-on or Push-button reset "
     ;;
 2) echo "Last reset cause: HW Watchdog expired "
     ;;
 3) echo "Last reset cause: No 'Card ready' detection within startup time "
     ;;
 4) echo "Last reset cause: Software failure during 'operational' state"
     ;;
 5) echo "Last reset cause: Element manager or command-line reset"
     ;; 
 6) echo "Last reset cause: Fallback to passive partition"
     ;;
 *) echo "Last reset cause: Restart cause could not be determined"
     ;;
esac
echo "* Reset counter: '$x'                        *"
echo "**********************************************"
# Show trace of current start
ukpt -fmt "$newFtmLong" $OctSys System 2>/dev/null

# revert settings
unset x 
set -o nounset
