#!/bin/bash
# bm.appstart
#
# Created 21.10.2013 / gancarcz
#
# copy to directory: /opt/bm/

# Install BM components
echo "Installing BM components..."

# Copy BM package content to proper directories
cp -r opt/* /opt
cp -r rom/* /rom
cp -r usr/* /usr

# Clean the ./opt/bm content
rm -rf opt
rm -rf rom
rm -rf usr

# Check if there are old configuration files to load:
if [ -d "/rom/tmp/bm_conf/" ];
then
	# Changing file permissions for every file and folder inside:
	chmod -R 644 /rom/tmp/bm_conf/

	# Load AppDef file (if it exists):
	if [ -f "/rom/tmp/bm_conf/AppDef.txt" ];
	then
		echo "BM configuration file found: AppDef.txt. Will use it"
		cp /rom/tmp/bm_conf/AppDef.txt /ram/
	fi

	# Load BM configuration files (if they exist):
	if [ -f "/rom/tmp/bm_conf/bm.conf" ];
	then
		echo "BM configuration file found: bm.conf. Will use it"
		cp /rom/tmp/bm_conf/bm.conf /opt/bm/etc/
	fi
	if [ -f "/rom/tmp/bm_conf/bm_bpf.xml" ];
	then
		echo "BM configuration file found: bm_bpf.xml. Will use it"
		cp /rom/tmp/bm_conf/bm_bpf.xml /opt/bm/etc/
	fi
	if [ -f "/rom/tmp/bm_conf/bm_scf.xml" ];
	then
		echo "BM configuration file found: bm_scf.xml. Will use it"
		cp /rom/tmp/bm_conf/bm_scf.xml /opt/bm/etc/
	fi
	if [ -f "/rom/tmp/bm_conf/syncapp.conf" ];
	then
		echo "BM configuration file found: syncapp.conf. Will use it"
		cp /rom/tmp/bm_conf/syncapp.conf /rom/
	fi
	if [ -f "/rom/tmp/bm_conf/syncapp-cal.dat" ];
	then
		echo "BM configuration file found: syncapp-cal.dat. Will use it"
		cp /rom/tmp/bm_conf/syncapp-cal.dat /rom/etc/
	fi
	if [ -f "/rom/tmp/bm_conf/syncapp-log4cplus.conf" ];
	then
		echo "BM configuration file found: syncapp-log4cplus.conf. Will use it"
		cp /rom/tmp/bm_conf/syncapp-log4cplus.conf /rom/
	fi
	if [ -f "/rom/tmp/bm_conf/swconfig.txt" ];
	then
		echo "BM configuration file found: swconfig.txt. Will use it"
		cp /rom/tmp/bm_conf/swconfig.txt /rom/
	fi
	if [ `ls -1 /rom/tmp/bm_conf/run_*.sh 2>/dev/null | wc -l ` -gt 0 ];
	then
		for scriptToRun in `ls /rom/tmp/bm_conf/run_*.sh`;
		do
			echo "Found $scriptToRun to run before BM start. Will use it"
			chmod +x $scriptToRun
			cp $scriptToRun /opt/bm/
		done
	fi
fi

# Check if there are files to load to ROM directory:
if [ -d "/rom/tmp/bm_conf/rom/" ];
then
	echo "BM configuration folder for /rom/ location found. Will copy files if they exist"
	echo "BM configuration files that will be copied:"
	ls /rom/tmp/bm_conf/rom/
	cp /rom/tmp/bm_conf/rom/* /rom/
fi

# Check if there are files to load to RAM directory:
if [ -d "/rom/tmp/bm_conf/ram/" ];
then
	echo "BM configuration folder for /ram/ location found. Will copy files if they exist"
	echo "BM configuration files that will be copied:"
	ls /rom/tmp/bm_conf/ram/
	cp /rom/tmp/bm_conf/ram/* /ram/
fi

# Check if there are some scripts (with matching name to: run_*.sh) to run before BM start:
if [ `ls -1 /opt/bm/run_*.sh 2>/dev/null | wc -l ` -gt 0 ];
then
	for scriptToRun in `ls /opt/bm/run_*.sh`;
	do
		if [[ -x "$scriptToRun" ]]
		then
			echo "Starting $scriptToRun"
			$scriptToRun
		fi
	done
fi

# Leave sign that the script has executed
touch bm.appstart.executed

echo "BM components installed"