#!/bin/bash
#v26
function pe_chan_sts_register()
{
  num_axc=$1

  printf "PE Channel Status Register\n"
  printf "  %10s %10s %5s %10s\n" "Addr" "Value" "Channel On"

  axc="0"
  while [ $axc -lt $num_axc ]
  do
    address=$((0x01f6C010+(4*($axc/32))))
    value=`devmem $address`
    chan_on=$((($value>>$axc)&0x1))
    printf "  0x%8.8x 0x%8.8x %10d\n" $address $value $chan_on

    axc=$(($axc+1))
  done

  return 0;
}

function pe_dmachan_enable_register()
{
  num_axc=$1

  printf "%-30s\n" "PE DMA Channel Enable Register"
  printf "  %10s %10s %10s\n" "Addr" "Value" "Channel Enable" 

  axc="0"
  while [ $axc -lt $num_axc ]
  do
    address=$((0x01f6c200+(4*$axc)))
    value=`devmem $address`
    ch_en=$(($value & 0x1))
    printf "  0x%8.8x 0x%8.8x 0x%x\n" $address $value $ch_en

    axc=$(($axc+1))
  done

  return 0
}

function ee_at_raw_status_register_with_clear()
{
  devmem 0x01f40300
  devmem 0x01f40308 32 0xFFFFFFFF
  sleep 1
  
  ee_at_raw_status_register

  return 0
}

function at_rp1_type_capture_register()
{
  address=0x01f48020
  value=`devmem $address`

  rp1_type_capt=$(($value&0xff))

  printf "%-30s 0x%8.8x 0x%8.8x rp1_type_capt=0x%x\n" "AT RP1 type capture register" $address $value $rp1_type_capt

  return 0
}

function at_pi_registers()
{
  link=$1

  if((link==0)); then address=0x01f48100; fi
  if((link==1)); then address=0x01f4810c; fi
  if((link==2)); then address=0x01f48118; fi
  if((link==3)); then address=0x01f48124; fi
  if((link==4)); then address=0x01f48130; fi
  if((link==5)); then address=0x01f4813c; fi
  value=`devmem $address`
  printf "%-30s 0x%8.8x 0x%8.8x pi_max=0x%8.8x\n" "AT Pi Max Register" $address $value $value

  if((link==0)); then address=0x01f48104; fi
  if((link==1)); then address=0x01f48110; fi
  if((link==2)); then address=0x01f4811c; fi
  if((link==3)); then address=0x01f48128; fi
  if((link==4)); then address=0x01f48134; fi
  if((link==5)); then address=0x01f48140; fi
  value=`devmem $address`
  printf "%-30s 0x%8.8x 0x%8.8x pi_min=0x%8.8x\n" "AT Pi Min Register" $address $value $value

  if((link==0)); then address=0x01f48108; fi
  if((link==1)); then address=0x01f48114; fi
  if((link==2)); then address=0x01f48120; fi
  if((link==3)); then address=0x01f4812c; fi
  if((link==4)); then address=0x01f48138; fi
  if((link==5)); then address=0x01f48144; fi
  value=`devmem $address`

  printf "%-30s 0x%8.8x 0x%8.8x pi_captured=0x%8.8x\n" "AT Pi Captured Value Register" $address $value $value

  return 0
}

function rm_link_status_0_register()
{
  link=$1

  if ((link == 0)); then address=0x01f50014; fi
  if ((link == 1)); then address=0x01f50814; fi
  if ((link == 2)); then address=0x01f51014; fi
  if ((link == 3)); then address=0x01f51814; fi
  if ((link == 4)); then address=0x01f52014; fi
  if ((link == 5)); then address=0x01f52814; fi

  value=`devmem $address`

  sync_status=$(($value & 0x3f))

  if ((sync_status == 0x1)); then sync_state="FRAME_SYNC"; fi
  if ((sync_status == 0x2)); then sync_state="WAIT_FOR_FRAME_SYNC"; fi
  if ((sync_status == 0x4)); then sync_state="WAIT_FOR_K28P7_IDLES"; fi
  if ((sync_status == 0x8)); then sync_state="UNSYNC"; fi
  if ((sync_status == 0x10)); then sync_state="WAIT_FOR_SEED"; fi
  if ((sync_status == 0x20)); then sync_state="WAIT_FOR_ACK"; fi

  printf "%-30s 0x%8.8x 0x%8.8x state=%-12s\n" "RM Link Status 0 Register" $address $value $sync_state

  if ((value & 0x100)); then echo "  Loss of Signal, RX FSM is in ST0 State"; fi
  if ((value & 0x200)); then echo "  num_los counter has reached los_det_thold within a master frame"; fi
  if ((value & 0x400)); then echo "  RX clock watchdog detected a missing clock"; fi
  if ((value & 0x800)); then echo "  FIFO Overflow occurred"; fi

  return 0
}

function tm_status_register()
{
  link=$1

  if ((link == 0)); then address=0x01f4c038; fi
  if ((link == 1)); then address=0x01f4c838; fi
  if ((link == 2)); then address=0x01f4d038; fi
  if ((link == 3)); then address=0x01f4d838; fi
  if ((link == 4)); then address=0x01f4e038; fi
  if ((link == 5)); then address=0x01f4e838; fi

  value=`devmem $address`

  frm_state=$((($value>>3)&0xf))
  if ((frm_state == 0x1)); then state="OFF"; fi
  if ((frm_state == 0x2)); then state="IDLE"; fi
  if ((frm_state == 0x4)); then state="RE_SYNC"; fi
  if ((frm_state == 0x8)); then state="FRAME_SYNC"; fi

  printf "%-30s 0x%8.8x 0x%8.8x state=%-12s\n" "TM Status Register" $address $value $state

  if ((value & 0x1)); then echo "  TM fail condition met"; fi
  if ((value & 0x2)); then echo "  Tx FIFO underflow"; fi
  if ((value & 0x4)); then echo "  CO Frame alignment mismatch from transmit FSM"; fi

  return 0
}

function ee_link_raw_status_a_register()
{
  link=$1  

  if ((link == 0)); then address=0x01f40000; fi
  if ((link == 1)); then address=0x01f40080; fi
  if ((link == 2)); then address=0x01f40100; fi
  if ((link == 3)); then address=0x01f40180; fi
  if ((link == 4)); then address=0x01f40200; fi
  if ((link == 5)); then address=0x01f40280; fi

  value=`devmem $address`
  printf "%-30s 0x%8.8x 0x%8.8x\n" "EE Link Raw Status A Register" $address $value
  # only the error bits are printed
  if ((value & 0x2)); then echo "  (Error) los detection"; fi
  if ((value & 0x4)); then echo "  (Error) lcv detection"; fi
  if ((value & 0x20)); then echo "  (Error) k28.5 character was not received when expected"; fi
  if ((value & 0x40)); then echo "  (Error) k28.7 character was not received when expected"; fi
  if ((value & 0x80)); then echo "  (Error) k30.7 error character was received"; fi
  if ((value & 0x100)); then echo "  (Error) loss of clock watchdog timeout"; fi
  if ((value & 0x200)); then echo "  (Error) RX FIFO overflowed"; fi
  if ((value & 0x400)); then echo "  (Error) L1 inband Loss of Signal Event"; fi
  if ((value & 0x800)); then echo "  (Error) "; fi
  if ((value & 0x1000)); then echo "  (Error) "; fi
  if ((value & 0x2000)); then echo "  (Error) "; fi
  if ((value & 0x4000)); then echo "  (Error) "; fi
  if ((value & 0x8000)); then echo "  (Error) "; fi
  if ((value & 0x10000)); then echo "  (Error) "; fi
  if ((value & 0x20000)); then echo "  (Error) "; fi
  if ((value & 0x40000)); then echo "  (Error) "; fi
  if ((value & 0x80000)); then echo "  (Error) "; fi
  if ((value & 0x100000)); then echo "  (Error) "; fi
  if ((value & 0x200000)); then echo "  (Error) "; fi
  if ((value & 0x400000)); then echo "  (Error) "; fi
  if ((value & 0x800000)); then echo "  (Error) "; fi
  if ((value & 0x100000)); then echo "  (Error) "; fi
  if ((value & 0x200000)); then echo "  (Error) "; fi

  return 0
}

function ee_link_raw_status_a_register_with_clear()
{
  ee_link_raw_status_a_register 0
  ee_link_raw_status_a_register 1
  ee_link_raw_status_a_register 2
  ee_link_raw_status_a_register 3
  ee_link_raw_status_a_register 4
  ee_link_raw_status_a_register 5
  
  devmem 0x01F40008 32 0xFFFFFFFF
  devmem 0x01F40088 32 0xFFFFFFFF
  devmem 0x01F40108 32 0xFFFFFFFF
  devmem 0x01F40188 32 0xFFFFFFFF
  devmem 0x01F40208 32 0xFFFFFFFF
  devmem 0x01F40288 32 0xFFFFFFFF
  sleep 1
  
  ee_link_raw_status_a_register 0
  ee_link_raw_status_a_register 1
  ee_link_raw_status_a_register 2
  ee_link_raw_status_a_register 3
  ee_link_raw_status_a_register 4
  ee_link_raw_status_a_register 5
}

function ee_link_raw_status_b_register()
{

  link=$1  

  if ((link == 0)); then address=0x01f4002c; fi
  if ((link == 1)); then address=0x01f400ac; fi
  if ((link == 2)); then address=0x01f4012c; fi
  if ((link == 3)); then address=0x01f401ac; fi
  if ((link == 4)); then address=0x01f4022c; fi
  if ((link == 5)); then address=0x01f402ac; fi

  value=`devmem $address`

  printf "%-30s 0x%8.8x 0x%8.8x\n" "EE Link Raw Status B Register" $address $value

  # only the error bits are printed
  if ((value & 0x1)); then echo "  (Error) Received a second EOP without an SOP in between"; fi
  if ((value & 0x2)); then echo "  (Error) CRC failure for any packet"; fi
  if ((value & 0x4)); then echo "  (Error) Arriving traffic is non-multiple of 4"; fi
  if ((value & 0x8)); then echo "  (Error) Unrecoverable OBSAI Timestamp error for at least 1 AxC of a given link"; fi
  if ((value & 0x20)); then echo "  (Error) Received a second SOP without an EOF in between"; fi
  if ((value & 0x40)); then echo "  (Error) Wrap of the PD_Frame Counters did not predict a Radio Frame Boundary consistent with TS=0 falling within the reception timing window"; fi
  if ((value & 0x80)); then echo "  (Information) PD is processing traffic for a given link"; fi
  if ((value & 0x10000)); then echo "  (Error) More than one modulo rule fired in a single clock cycle"; fi
  if ((value & 0x20000)); then echo "  (Error) Symbol index in Multicore Navigator protocol specific header did not match for one or more symbol"; fi
  if ((value & 0x40000)); then echo "  (Error) MF FIFO was full when a write occurred"; fi
  if ((value & 0x80000)); then echo "  (Error) MF FIFO was empty when a read occurred"; fi
  if ((value & 0x100000)); then echo "  (Error) DB did not have antenna data for a AxC channel"; fi
  if ((value & 0x200000)); then echo "  (Error) RT interface Error"; fi
  if ((value & 0x400000)); then echo "  (Error) DB did not have packet data for a pkt channel"; fi
  if ((value & 0x1000000)); then echo "  (Error) The retransmit frame no longer matches the transmit frame in aggregate mode for link"; fi
  if ((value & 0x2000000)); then echo "  (Error) RT FIFO has overflowed in retransmit or aggregate mode for link"; fi
  if ((value & 0x4000000)); then echo "  (Error) RT FIFO has underflowed in retransmit or aggregate mode for link"; fi
  if ((value & 0x8000000)); then echo "  (Information) RT block created an empty message in OBSAI aggregate mode for link"; fi
  if ((value & 0x10000000)); then echo "  (Error) The retransmit header does not match the transmit header in OBSAI aggregate mode for link"; fi

  return 0
}

function ee_link_raw_status_b_register_with_clear()
{
  ee_link_raw_status_b_register 0
  ee_link_raw_status_b_register 1
  ee_link_raw_status_b_register 2
  ee_link_raw_status_b_register 3
  ee_link_raw_status_b_register 4
  ee_link_raw_status_b_register 5
  
  devmem 0x01f40034 32 0xffffffff
  devmem 0x01f400b4 32 0xffffffff
  devmem 0x01f40134 32 0xffffffff
  devmem 0x01f401b4 32 0xffffffff
  devmem 0x01f40234 32 0xffffffff
  devmem 0x01f402b4 32 0xffffffff
  sleep 1
  
  ee_link_raw_status_b_register 0
  ee_link_raw_status_b_register 1
  ee_link_raw_status_b_register 2
  ee_link_raw_status_b_register 3
  ee_link_raw_status_b_register 4
  ee_link_raw_status_b_register 5
}

function rm_link_status_1_register()
{
  link=$1  

  if ((link == 0)); then address=0x01f50018; fi
  if ((link == 1)); then address=0x01f50818; fi
  if ((link == 2)); then address=0x01f51018; fi
  if ((link == 3)); then address=0x01f51818; fi
  if ((link == 4)); then address=0x01f52018; fi
  if ((link == 5)); then address=0x01f52818; fi
  
  value=`devmem $address`

  lcv_cntr_value=$((($value>>16)&0xffff))
  num_los=$(($value&0xffff))

  printf "%-30s 0x%8.8x 0x%8.8x lcv_cntr_value=0x%x, num_los=0x%x\n" "RM Link Status 1 Register" $address $value $lcv_cntr_value $num_los 
  
  return 0
}

function at_control_register_1()
{
  address=0x01f48000
  value=`devmem $address`

  printf "%-30s 0x%8.8x 0x%8.8x\n" "AT Control Register 1" $address $value

  return 0
}

function at_phyt_cmp_radsync_register()
{
  address=0x01f4800C
  value=`devmem $address`

  phyt_cmp=$(($value&0x3fffff))
    
  printf "%-30s 0x%8.8x 0x%8.8x phyt_cmp=0x%x\n" "AT PHYT Compare RADT Sync Register" $address $value $phyt_cmp

  return 0
}

function at_rp1_type_select_register()
{
  address=0x01f48010
  value=`devmem $address`

  rp1_radt_type_sel=$(($value&0xff))

  printf "%-30s 0x%8.8x 0x%8.8x rp1_radt_type_sel=0x%x\n" "AT RP1 type select register" $address $value $rp1_radt_type_sel

  return 0
}

function at_rp1_type_capture_register()
{
  address=0x01f48020
  value=`devmem $address`

  rp1_type_capt=$(($value&0xff))

  printf "%-30s 0x%8.8x 0x%8.8x rp1_type_capt=0x%x\n" "AT RP1 type capture register" $address $value $rp1_type_capt

  return 0
}

function at_radt_capture_register()
{
  address=0x01f48014
  value=`devmem $address`

  radt_fr_capt=$(($value&0xf8000000))
  radt_sym_capt=$(($value&0x07f80000))
  radt_clk_capt=$(($value&0x0007ffff))
    
  printf "%-30s 0x%8.8x 0x%8.8x radt_fr_capt=0x%x radt_sym_capt=0x%x radt_clk_capt=0x%x\n" "AT RADT capture register" $address $value $radt_fr_capt $radt_sym_capt $radt_clk_capt

  return 0
}

function at_phyt_frame_capture_register()
{
  address=0x01f48044
  value=`devmem $address`

  phyt_fr_capt=$(($value&0xfff))
    
  printf "%-30s 0x%8.8x 0x%8.8x phyt_fr_capt=0x%x\n" "AT PHYT Frame Value capture register" $address $value $phyt_fr_capt

  return 0
}

function at_negative_delta_register()
{
  address=0x01f48148
  value=`devmem $address`

  printf "%-30s 0x%8.8x 0x%8.8x\n" "AT Negative Delta Register" $address $value

  return 0
}

function at_tm_delta_event_offset_register()
{
  link=$1  

  if ((link == 0)); then address=0x01f48540; fi
  if ((link == 1)); then address=0x01f48548; fi
  if ((link == 2)); then address=0x01f48550; fi
  if ((link == 3)); then address=0x01f48558; fi
  if ((link == 4)); then address=0x01f48560; fi
  if ((link == 5)); then address=0x01f48568; fi  

  value=`devmem $address`

  evt_index=$(($value&0x3fffff))

  printf "%-30s 0x%8.8x 0x%8.8x delta_offset=0x%x\n" "AT TM Delta Event Offset Register" $address $value $evt_index

  return 0
}

function pd_chan_sts_register()
{
  num_axc=$1

  printf "PD Channel Status Register\n"
  printf "  %10s %10s %5s %10s\n" "Addr" "Value" "Channel On"

  axc="0"
  while [ $axc -lt $num_axc ]
  do
    address=$((0x01f63020+(4*($axc/32))))
    value=`devmem $address`
    chan_on=$((($value>>$axc)&0x1))
    printf "  0x%8.8x 0x%8.8x %10d\n" $address $value $chan_on

    axc=$(($axc+1))
  done

  return 0;
}

function pd_dmachan_a_register()
{
  num_axc=$1

  printf "%-30s\n" "PD Channel Control Fields Register 0 Register"
  printf "  %10s %10s %10s\n" "Addr" "Value" "AxC offset" 

  axc="0"
  while [ $axc -lt $num_axc ]
  do
    address=$((0x01f64000+(4*$axc)))
    value=`devmem $address`
    axc_offset=$(($value & 0x1ffffff))
    printf "  0x%8.8x 0x%8.8x 0x%x\n" $address $value $axc_offset

    axc=$(($axc+1))
  done

  return 0;
}  

function pe_antenna_carrier_offset_register()
{
  num_axc=$1

  printf "%-30s\n" "PE Antenna Carrier Offset Register"
  printf "  %10s %10s %10s\n" "Addr" "Value" "Downlink AxC offset" 

  axc="0"
  while [ $axc -lt $num_axc ]
  do
    address=$((0x01f6c800+(4*$axc)))
    value=`devmem $address`
    axc_offset=$(($value & 0x1ffffff))
    printf "  0x%8.8x 0x%8.8x 0x%x\n" $address $value $axc_offset

    axc=$(($axc+1))
  done

  return 0
}

i="0"
echo "v26.pjd.01sep16"
echo " "
date;
syncappmmi status
echo " "
echo "***** FZM-FZP K2 AIF - FPGA DCP (Data Collection Procedure) *******************************************"
pe_chan_sts_register 4 # or 128 if you really want to check all 128 AxCs
ee_at_raw_status_register_with_clear
at_rp1_type_capture_register
at_pi_registers 0
at_pi_registers 1
at_pi_registers 2
at_pi_registers 3
at_pi_registers 4
at_pi_registers 5
rm_link_status_0_register 0
rm_link_status_0_register 1
rm_link_status_0_register 2
rm_link_status_0_register 3
rm_link_status_0_register 4
rm_link_status_0_register 5
tm_status_register 0
tm_status_register 1
tm_status_register 2
tm_status_register 3
tm_status_register 4
tm_status_register 5
ee_link_raw_status_a_register_with_clear
ee_link_raw_status_b_register_with_clear
rm_link_status_1_register 0
rm_link_status_1_register 1
rm_link_status_1_register 2
rm_link_status_1_register 3
rm_link_status_1_register 4
rm_link_status_1_register 5
at_control_register_1
at_phyt_cmp_radsync_register
at_rp1_type_select_register
at_rp1_type_capture_register
at_radt_capture_register
at_radt_capture_register
at_radt_capture_register
at_phyt_frame_capture_register
at_phyt_frame_capture_register
at_phyt_frame_capture_register
at_negative_delta_register
at_tm_delta_event_offset_register 0
at_tm_delta_event_offset_register 1
at_tm_delta_event_offset_register 2
at_tm_delta_event_offset_register 3
at_tm_delta_event_offset_register 4
at_tm_delta_event_offset_register 5
pd_chan_sts_register 4 # or 128 if you really want to check all 128 AxCs
pd_dmachan_a_register 4 # or 128 if you really want to check all 128 AxCs
pe_antenna_carrier_offset_register 4 # or 128 if you really want to check all 128 AxCs
pe_dmachan_enable_register 4 # or 128 if you really want to check all 128 AxCs
echo "K2 other regs "
echo "Link 4 SerDes Lane_000 (0x02326200)"
devmem 0x02326200
echo "Link 4 SerDes Lane_004 (0x02326204)"
devmem 0x02326204
echo "Link 4 SerDes Lane_008 (0x02326208)"
devmem 0x02326208
echo "Link 4 SerDes Lane_048 (0x02326248)"
devmem 0x02326248
echo "Link 4 SerDes Lane 1 Control and Status (0x02327fe0)"
devmem 0x02327FE0
echo "Link 5 SerDes Lane 2 Control and Status (0x02327ff4)"
devmem 0x02327FF4
echo " "
echo "***** EID ******************************************************************************************************"
eidutil
echo "FPGA_TYPE: 0x00=Alt Cycl4, 0x01=Alt Cycl5-GX, 0x02=Alt Cycl5-GT, 0x03=Xil Art7, 0x04=Xil Zynq35"
echo "RFIC_TYPE: 0x00-0x02=Catalina variants, 0x03=Mykonos, 0x05=Clemente"
echo " "
echo "***** FPGA version, clocks, reset, TD-FD mode ******************************************************************"
fpga-rw -r 0x0
fpga-rw -r 0x8
echo "FPGA TDD vs FDD mode: bit[12] and bit[8] set indicate TDD operation"
fpga-rw -r 0x1C008C
echo "FPGA PLL locks (bits [31:28] = PLL4, PLL3, PLL2, PLL1, bit[23] = TI CDCM6208)"
fpga-rw -r 0x80000
echo "FPGA PLL locks (bits [12],[8],[4],[0] = PLL4, PLL3, PLL2, PLL1)"
fpga-rw -r 0x80060
echo "DFS PLL lock, CPLD reset:"
fpga-rw -r 0x00388
echo "master-slave select (bits[6:5] should be set for master unless on FWHD slave)"
fpga-rw -r 0x00014
echo "FPGA clock checks - #clocks per 1pps: 122MHz SYS_CLK (2 versions), DFS_OUT_CLK, 30.72MHz 6208 clock"
fpga-rw -r 0x00380
fpga-rw -r 0x00384
fpga-rw -r 0x0038C
fpga-rw -r 0x00390
echo "FPGA clock checks - #clocks per 1pps: RF, RP3A, RP3B"
fpga-rw -r 0x00394
fpga-rw -r 0x00398
fpga-rw -r 0x0039C
echo "FPGA 1PPS, Frame checks - nonzero, incrementing?"
fpga-rw -r 0x8001C
fpga-rw -r 0x80020
sleep 1
fpga-rw -r 0x8001C
fpga-rw -r 0x80020
echo " "
echo "***** FPGA alarms, power checks *********************************************************************************"
echo "FPGA IRQ checks - enables & status"
fpga-rw -r 0x00100
fpga-rw -r 0x00104
fpga-rw -r 0x00110
fpga-rw -r 0x00114
echo "FPGA alarm checks - TX,RX overdrive (rd -> clr -> wr)"
fpga-rw -r 0x000C0020
fpga-rw -r 0x00180010
fpga-rw -r 0x00080040
fpga-rw -w 0x000C0020 0xb63d
fpga-rw -w 0x00180010 0x0
fpga-rw -w 0x00080040 0xffffffff
sleep 1
fpga-rw -r 0x000C0020
fpga-rw -r 0x00180010
fpga-rw -r 0x00080040

echo "DL power meter output:"
echo "     FZM range, when data is     being pushed: 0xA400 - 0xaD00"
echo "     FZM range, when data is NOT being pushed: 0x7400 - 0x7D00"
echo "TXmain 5x consecutive reads..."
fpga-rw -r 0x000C0000
sleep 1
fpga-rw -r 0x000C0000
sleep 1
fpga-rw -r 0x000C0000
sleep 1
fpga-rw -r 0x000C0000
sleep 1
fpga-rw -r 0x000C0000
echo "TXdiv 5x consecutive reads..."
fpga-rw -r 0x000C0100
sleep 1
fpga-rw -r 0x000C0100
sleep 1
fpga-rw -r 0x000C0100
sleep 1
fpga-rw -r 0x000C0100
sleep 1
fpga-rw -r 0x000C0100
echo " "
echo "***** FPGA GPS1&2, UARTS **********************************************************************************************"
fpga-rw -r 0x200
fpga-rw -r 0x204
fpga-rw -r 0x208
fpga-rw -r 0x20C
fpga-rw -r 0x214
fpga-rw -r 0x218
fpga-rw -r 0x21C
fpga-rw -r 0x220
fpga-rw -r 0x224
fpga-rw -r 0x228
fpga-rw -r 0x22C
fpga-rw -r 0x234
fpga-rw -r 0x238
fpga-rw -r 0x23C
echo "GPS LNA select (bit[26]),antenna power(bit[1]), reset(bit[0])"
fpga-rw -r 0x00014
echo "Front panel MMI UART MUX"
fpga-rw -r 0x0001C
echo " "
echo "***** FPGA REF PORTS A,B,C ***********************************************************************************"
echo "CT1R selects REFA & REFB, CRO_MODE selects REFC"
fpga-rw -r 0x00010
fpga-rw -r 0x80000
echo "SYN_FSR_FREF, SYN_FSR_TREF for configurable frequency:"
fpga-rw -r 0x10800
fpga-rw -r 0x10804
echo "SYN_FOR_FREF, SYN_FOR_TREF for configurable phase offset wrt 1pps:"
fpga-rw -r 0x10900
fpga-rw -r 0x10904
echo "SYN_PW_FREF, SYN_PW_TREF for configurable pulsewidth:"
fpga-rw -r 0x10C00
fpga-rw -r 0x10C04
echo " "
echo "***** FPGA RP1, SFN *****************************************************************************************"
echo "Sync module advanced & on-time FrmClk configuration for use by RP1 module:"
echo "(registers SYN_FSR_FRM, SYN_FSR_ADVFRM, SYN_FOR_FRM, SYN_FOR_ADVFRM, SYN_PW_FRM, SYN_PW_ADVFRM)"
fpga-rw -r 0x10808
fpga-rw -r 0x1080C
fpga-rw -r 0x10908
fpga-rw -r 0x1090C
fpga-rw -r 0x10C08
fpga-rw -r 0x10C0C
echo "RP1_ENABLE_CONTROL (expect 0x1)"
fpga-rw -r 0x140030
echo "RP1 status {RP1_SET when SyncApp inits 0x140700-8 , RP1_CLK enabled by FPGA, RP1_FB enabled by HWAPI setting 0x140030 bit[1]} expect 0x7"
fpga-rw -r 0x140900
echo "rp1 SFN init value"
fpga-rw -r 0x140884
echo "rp1 fb type & info (SFN init)"
fpga-rw -r 0x140700
fpga-rw -r 0x140704
fpga-rw -r 0x140708
echo "SFN latched at each 1pps"
fpga-rw -r 0x140880
fpga-rw -r 0x140884
sleep 1
fpga-rw -r 0x140880
fpga-rw -r 0x140884
echo "AIF AT PHYT ERROR FLAG"
fpga-rw -r 0x14088c
echo "SFN values capturing at the beginning and end of the first and second 1PPS period after SFN initialization"
fpga-rw -r 0x140A00
fpga-rw -r 0x140A04
fpga-rw -r 0x140A10
fpga-rw -r 0x140A14
fpga-rw -r 0x140A20
fpga-rw -r 0x140A24
fpga-rw -r 0x140A30
fpga-rw -r 0x140A34
echo " "
echo "***** FPGA LMTS1&2 **********************************************************************************************"
fpga-rw -r 0x140800
fpga-rw -r 0x140B00
fpga-rw -r 0x140B04
fpga-rw -w 0x140B00 0xFFFFFFFF
fpga-rw -w 0x140B04 0xFFFFFFFF
sleep 1
fpga-rw -r 0x140B00
fpga-rw -r 0x140B04
fpga-rw -r 0x240800
fpga-rw -r 0x240B00
fpga-rw -r 0x240B04
echo " "
echo "***** FPGA datapath (see also ALARMS section above) **************************************************************"
echo "TX_CTRL - PA voltage: 0x00=26v, 0x20=28v, 0x40=22v, 0x60=24v (default)"
fpga-rw -r 0x0C0200
echo "RF_POWER - [12] AGC, [8] LNA DIV, [4] LNA MAIN, [0] RF: 0x1111 is all powered up"
fpga-rw -r 0x180008
echo "TX_FIFO_ENABLE (applies to TX & RX)"
fpga-rw -r 0x0C001C
echo "TX_CARRIER_ENABLE (TX & RX): 0x1111=C0&C1 main&div enabled, 0x0101=C0 main&div enabled, 0x0001=C0 main enabled."
fpga-rw -r 0x0C0204
echo "TX_MULTI_CARRIER_ENABLE (applies to TX & RX, establishes multicarrier mode vs legacy mode)"
fpga-rw -r 0x0C0208
echo "TX CLGC power control - capture & trigger points, main & div"
fpga-rw -r 0x0C0000
fpga-rw -r 0x0C0004
fpga-rw -r 0x0C0100
fpga-rw -r 0x0C0104
echo "TX CLGC power control - control & coefficients"
fpga-rw -r 0x0C0024
fpga-rw -r 0x0C0028
fpga-rw -r 0x0C002C
fpga-rw -r 0x0C0030
echo "TX_GAIN 1 & 2 - pre & post-CLGC, main & div (multiple reads)"
fpga-rw -r 0x0C000C
fpga-rw -r 0x0C0010
fpga-rw -r 0x0C010C
fpga-rw -r 0x0C0110
fpga-rw -r 0x0C000C
fpga-rw -r 0x0C0010
fpga-rw -r 0x0C010C
fpga-rw -r 0x0C0110
echo "TX_CARRIER1-2 GAIN, main & div"
fpga-rw -r 0x0C0210
fpga-rw -r 0x0C0214
fpga-rw -r 0x0C0218
fpga-rw -r 0x0C021C
echo "TX_CARRIER1-2 NCO Phase Increment"
fpga-rw -r 0x0C1000
fpga-rw -r 0x0C1004
echo "TX_KEY - main & div"
fpga-rw -r 0x0C0014
fpga-rw -r 0x0C0114
echo "TX_CFR - [28] full DL & UL bypass, [24] disable, clipping level [2:0]: FDD=0x0=6.8dB PAR, TDD=0x3 = 7.4dB PAR"
fpga-rw -r 0x0C0008
echo "TX_RAM_SHIFT expected values: (based on https://sharenet-ims.int.net.nokia.com/livelink/livelink?func=ll&objId=523640501&objAction=browse)"
echo "  FDD SC(C5C1-only): 5MHz=0x0,10MHz=0xe5, 15MHz=0x1ca, 20MHz=0x2b4" 
echo "  TDD non-FWHD   SC: 5MHz=NA, 10MHz=0xe5, 15MHz=0x1c8, 20MHz=0x2b1" 
echo "  TDD non-FWHD   MC: 5MHz=NA, 10MHz=0x112,15MHz=0x1dc, 20MHz=0x2b3" 
echo "  TDD     FWHD-S SC: 5MHz=NA, 10MHz=0xe4, 15MHz=0x1c8, 20MHz=0x2b1" 
echo "  TDD     FWHD-S MC: 5MHz=NA, 10MHz=0x111,15MHz=0x1da, 20MHz=0x2b0" 
echo "  TDD     FWHD-M SC: 5MHz=NA, 10MHz=0xe4, 15MHz=0x1c8, 20MHz=0x2b3" 
fpga-rw -r 0x0C020C
echo " "
echo "RX_RAM_SHIFT expected values: (based on https://sharenet-ims.int.net.nokia.com/livelink/livelink?func=ll&objId=523640501&objAction=browse)"
echo "  FDD SC(C5C1-only): 5MHz=0x2,10MHz=0xc7, 15MHz=0x13a, 20MHz=0x260"
echo "  TDD non-FWHD   SC: 5MHz=NA, 10MHz=0x88, 15MHz=0xdc,  20MHz=0x1e4" 
echo "  TDD non-FWHD   MC: 5MHz=NA, 10MHz=0x94, 15MHz=0xe4,  20MHz=0x1e3" 
echo "  TDD     FWHD-S SC: 5MHz=NA, 10MHz=0x89, 15MHz=0xdd,  20MHz=0x1e4" 
echo "  TDD     FWHD-S MC: 5MHz=NA, 10MHz=0x95, 15MHz=0xe5,  20MHz=0x1e5" 
echo "  TDD     FWHD-M SC: 5MHz=NA, 10MHz=0x88, 15MHz=0xdd,  20MHz=0x1e4" 
fpga-rw -r 0x180014
echo "RX_CARRIER1-2 NCO Phase Increment"
fpga-rw -r 0x181000
fpga-rw -r 0x181004
echo "RX_GAIN - main & div, AGC (multiple reads)"
fpga-rw -r 0x180000
fpga-rw -r 0x180004
fpga-rw -r 0x18000C
fpga-rw -r 0x180000
fpga-rw -r 0x180004
fpga-rw -r 0x18000C
echo "RX_GAIN (multiple reads): SET, STEP_MORE, STEP_LESS, STEP_MUCH_LESS, WINDOW_LOW, WINDOW_HIGH:"
fpga-rw -r 0x180700
fpga-rw -r 0x180704
fpga-rw -r 0x180708
fpga-rw -r 0x18070C
fpga-rw -r 0x180700
fpga-rw -r 0x180704
fpga-rw -r 0x180708
fpga-rw -r 0x18070C
fpga-rw -r 0x180710
fpga-rw -r 0x180714
echo " "
echo "***** FPGA DFS **********************************************************************************************"
echo "SYNC_PAIR_SYS:  System Time Frequency Increment Register (steer like a VCO)"
fpga-rw -r 0x1070C
echo "SYNC_PAIR_IEEE:  IEEE 1588 Frequency Increment Register (steer like a VCO)"
fpga-rw -r 0x10710
echo "SYNC_SPLVR_GPS:  GPS Phase Latch Register"
fpga-rw -r 0x10500
echo "SYNC_SPLVR_SYNCE1:  SYNCE1 Phase Latch Register"
fpga-rw -r 0x10504
echo "SYNC_SPLVR_SYNCE2:  SYNCE2 Phase Latch Register"
fpga-rw -r 0x10508
echo "SYNC_SPLVR_IEEE:  IEEE 1588 Phase Latch Register"
fpga-rw -r 0x1050C
echo "SYNC_MPCRR:  Master Phase Counter Rollover Register:  used to snap phase offset in alignment to reference"
fpga-rw -r 0x10700
echo " "
echo "***** FPGA SFN **********************************************************************************************"
fpga-rw -r 0x10120
echo "DFS_LITE_STATUS:  25MHz PHY_CLKs detected[15:14], PLL locks[13:12], DFSLite selected[11], auto-switched[10], manual-switched[9], switch count[7:0]:"
fpga-rw -r 0x10124
echo " "
echo "***** FPGA RP3 CARRIER0 **********************************************************************************************"
echo "Carrier0 RP3_LANE0_MAIN_CFG, RP3_LANE0_DIV_CFG:"
fpga-rw -r 0x14011C
fpga-rw -r 0x140120
echo "Carrier0 RP3_DEBUG_CTL, clear to ensure no debug modes enabled"
fpga-rw -r 0x14057C
echo "Carrier0 UL_TRANSMITTER_ENABLE, expect 0x1"
fpga-rw -r 0x140204
echo "Carrier0 RP3_RESET, expect 0x0"
fpga-rw -r 0x14000C
echo "Carrier0 DL state machine status:"
echo "     DL:  0x01=unsync, 0x2=wait_for_seed, 0x04=wait_for_ack, 0x08=wait_for_K287_idles, 0x10=wait_for_frame_sync, 0x20=frame_sync"
fpga-rw -r 0x140114
echo "     UL:  0x01=off, 0x2=idle, 0x04=idle_req, 0x08=idle_ack, 0x10=frame_ul (dependant on DL reaching frame_sync unless 0x14_0220 is set)"
fpga-rw -r 0x14020C
fpga-rw -r 0x140220
echo "Carrier0 BW Modulo: 5MHz=0x8, 10MHz=0x4, 15MHz=0x3, 20MHz=0x2"
fpga-rw -r 0x140200
echo "Carrier0 10ms FP delay: RP3_UL_ADVANCE_TICK (based on https://sharenet-ims.int.net.nokia.com/livelink/livelink?func=ll&objId=523640501&objAction=browse)"
echo "  FDD FZM: 0x17628A, FDD FZP: 0x176150, FDD FZM: 0x176FF0, FDD FZP: 0x176FF0:"
fpga-rw -r 0x1402A8
echo " "
echo "Carrier0 Reconfig Controller: logical channel, pre-post CDR PMA offset, loopback enable, write enable:"
fpga-rw -r 0x142020
fpga-rw -r 0x14202C
fpga-rw -r 0x142030
fpga-rw -r 0x142028
echo " "
echo "***** VARIOUS RP3 DEBUG COUNTERS ***********************************************************************************"
echo "Carrier0 RP3 status:  read-> clear-> pause -> re-read, expect 0x1F_0044 but could be different"
fpga-rw -r 0x14001C
fpga-rw -w 0x14001C 0xFFFFFFFF
sleep 1
fpga-rw -r 0x14001C
echo "Carrier0 number of RP3 TXmain-TXdiv messages, TXmain-TXdiv message errors: read-> clear-> pause -> re-read"
fpga-rw -r 0x140864
fpga-rw -r 0x140868
fpga-rw -r 0x14086C
fpga-rw -r 0x140870
fpga-rw -w 0x140860 0x3
sleep 1
fpga-rw -r 0x140864
fpga-rw -r 0x140868
fpga-rw -r 0x14086C
fpga-rw -r 0x140870
echo "Carrier0 number of 10 ms frame with number of external frame events: =140, >140, <140, latched frame count: read-> clear-> pause -> re-read"
fpga-rw -r 0x140890
fpga-rw -r 0x140894
fpga-rw -r 0x140898
fpga-rw -r 0x14089C
fpga-rw -w 0x1408A0 0x1
fpga-rw -w 0x1408A4 0x1
fpga-rw -w 0x1408A8 0x1
sleep 1
fpga-rw -r 0x140890
fpga-rw -r 0x140894
fpga-rw -r 0x140898
fpga-rw -r 0x14089C
echo "Carrier0 UL RP3 FIFO WR & RD pointer watermarks:  div [19:12], main [11:4]"
fpga-rw -r 0x1402AC
fpga-rw -r 0x1402B0
echo "Carrier0 DL RP3 FIFO WR & RD pointer watermarks:  div [19:12], main [11:4]"
fpga-rw -r 0x140500
fpga-rw -r 0x140504


echo "DDR3A ECC"
echo "ECC Control Register"
devmem 0x21010110
echo "IRQSTATUS_RAW_SYS"
devmem 0x210100a4
echo "2-bit error address log"
devmem 0x21010140
echo "1-bit error address log"
devmem 0x2101013c
echo "1-bit error distribution"
devmem 0x21010144
devmem 0x21010138
echo "DDR3B ECC"
echo "ECC Control Register"
devmem 0x21020110
echo "IRQSTATUS_RAW_SYS"
devmem 0x210200a4
echo "2-bit error address log"
devmem 0x21020140
echo "1-bit error address log"
devmem 0x2102013c
echo "1-bit error distribution"
devmem 0x21020144
devmem 0x21020138
echo "jtag id"
devmem 0x02620018
