#!/bin/sh
export BTSOMROOT=/opt/nsn/BTS_SC_OAM_FZM/

export LD_LIBRARY_PATH=lib:/lib64:$BTSOMROOT/lib:$LD_LIBRARY_PATH

# Create the BTSOM config directories in /rom
mkdir -p /rom/btsom/config/active
mkdir -p /rom/btsom/config/backup
mkdir -p /rom/btsom/config/inactive/xoh
mkdir -p /rom/btsom/config/inactive/asn

# Create the BTSOM config directories in /ram
mkdir -p /ram/LTE
mkdir -p /rom/Raml

mkdir -p /ram/stats

# Copy files
cp $BTSOMROOT/config/vendor_fdd.xml /ram
cp $BTSOMROOT/config/vendor_tdd.xml /ram
cp $BTSOMROOT/config/SiteEM-FZC_*.xml /rom/FlexiSiteEM_100000000007000000.xml
cp $BTSOMROOT/AdaptationVersions/* /rom

# Temporary until FxP implementation is done.
cp $BTSOMROOT/config/deltaFxpTrs.xml /rom/btsom/config/active/deltaFxpTrs.xml

mkdir -p /opt/BTSOM/config
mkdir -p /opt/BTSOM/scripts

cp $BTSOMROOT/config/* /opt/BTSOM/config
cp $BTSOMROOT/script/* /opt/BTSOM/scripts

#prepare files for data migration
cp $BTSOMROOT/config/SUTool /rom/btsom/config/active
chmod 755 /rom/btsom/config/active/SUTool
rm -rf /rom/SCFDFB*.txt
rm -rf /rom/SCFD-VERSION*.txt
cp /mnt/sysimg/opt/nsn/SCFD/SCFDFB*.txt /rom
cp /mnt/sysimg/opt/nsn/SCFD/SCFD-VERSION*.txt /rom

if [ ! -e "/rom/btsom/config/active/autoconf.xml" ]
then
	cp $BTSOMROOT/usr/autoconf.xml /rom/btsom/config/active
fi
