#!/bin/bash
#/opt/BTSOM/scripts/generate_snapshot.sh
HOME="/ram/LTE/SNAPSHOT_HOME"
DATE=`date +'%Y%m%d'`
LOG_FILE="/tmp/BTS$2_$3_generateSnapshot.log"

function printLog
{
    echo "STATUS: `date '+%H:%M:%S:%N'`: $1" >> $LOG_FILE
}

echo "Start snapshot generation `date`" > $LOG_FILE

usageDescriptionPrint="Usage: /opt/BTSOM/scripts/generate_snapshot.sh <full/minor/crash> <btsid> <nodeid> <allVarLog/syslogOnly> [optional]<symptomReportPath> [optional]<symptomReportAfterInitPath>";
if [[ $# -lt 4 ]]; then
echo "$usageDescriptionPrint"
printLog "Invalid arguments"
exit
fi

if [[ $1 == "full" ]]; then
echo "Received FULL"
elif [[ $1 == "minor" ]]; then
echo "Received MINOR"
elif [[ $1 == "crash" ]]; then
echo "Received CRASH"
else
echo "Improper input ---- $usageDescriptionPrint"
fi

printLog "coverage argument $1"
printLog "btsId $2"
printLog "nodeId  $3"

if [[ $4 == "allVarLog" ]]; then
echo "All necessary data from /var/log will be copied"
elif [[ $4 == "syslogOnly" ]]; then
echo "Not whole /var/log would be copied"
else
echo "Improper input ---- $usageDescriptionPrint"
exit
fi

printLog "var log content argument $4"

if [[ ($# -eq 5 || $# -eq 6) && ! -z $5 ]]; then
    printLog "symptom report argument $5"
else
    printLog "Symptomreport file in unavailable"
fi

if [[ $# -eq 6 && ! -z $6 ]]; then
    printLog "symptom report after init argument $6"
else
    printLog "Symptomreport after init file is unavailable"
fi

#Removing old Files if any from /ram/LTE/
rm -rf $HOME/*BTS_Config*
rm -rf $HOME/*BTS_Log*
rm -rf $HOME/*TRS_Config*
rm -rf $HOME/*TRS_Log*
rm -rf $HOME/*_metadata*

printLog "clean old files"

########################################################################################################################
mkdir -p $HOME/BTS_Config/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/ is not created"
exit
fi

printLog "created BTS_Config directory"

cp -p /ffs/run/SiteEM.xml $HOME/BTS_Config/BTS$2_$3_SiteEM.xml
cp -p /ram/vendor.xml $HOME/BTS_Config/BTS$2_$3_vendor.xml
cp -p /ram/LTE_CurrentBD.xml $HOME/BTS_Config/BTS$2_$3_LTE_CurrentBD.xml
cp -p /opt/hwr/CCSEarlyConfig.xml $HOME/BTS_Config/BTS$2_$3_CCSEarlyConfig.xml
cp -p /opt/BTSOM/config/btsom_asn_config.txt $HOME/BTS_Config/BTS$2_$3_btsom_asn_config.txt
cp -p /ram/AppDef.txt $HOME/BTS_Config/BTS$2_$3_AppDef.txt
cp -p /opt/hwr/service.xml $HOME/BTS_Config/BTS$2_$3_hwr_service.xml
cp -p /opt/hwr/hwr.xml $HOME/BTS_Config/BTS$2_$3_hwr.xml
cp -p /opt/BTSOM/config/alarmRulesData.xml $HOME/BTS_Config/BTS$2_$3_alarmRulesData.xml

printLog "collected files to BTS_Config directory, content:"
ls -al ${HOME}/BTS_Config >> $LOG_FILE

mkdir -p $HOME/BTS_Config/active/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/active/ is not created"
else
cp -p /rom/btsom/config/active/* $HOME/BTS_Config/active/
fi

printLog "collected files to BTS_Config active directory, content:"
ls -al ${HOME}/BTS_Config/active >> $LOG_FILE

mkdir -p $HOME/BTS_Config/backup/

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Config/backup/ is not created"
else
cp -p /rom/btsom/config/backup/* $HOME/BTS_Config/backup/
fi

printLog "collected files to BTS_Config backup directory, content:"
ls -al ${HOME}/BTS_Config/backup >> $LOG_FILE

if [[ -d /rom/LTEU-stats/ ]] ; then
tar --directory=/rom/ -cf LTEU-stats.tar LTEU-stats/
cp -p /rom/LTEU-stats.tar $HOME/BTS_Config
rm -rf /rom/LTEU-stats.tar
printLog "collected LTEU-stats to BTS_Config"
fi

cd $HOME
printLog "pack all files from BTS_Config content:"
tar -zvcf BTS$2_$3_BTS_Config.tar.gz BTS_Config  >> $LOG_FILE
rm -rf $HOME/BTS_Config




########################################################################################################################
mkdir -p $HOME/BTS_Log/
mkdir -p $HOME/BTS_Log/SupervisionOut/
PREVIOUS_UPGRADE_LOGS=$HOME/BTS_Log/previousUpgrade/
mkdir -p $PREVIOUS_UPGRADE_LOGS

if [[ $? != 0 ]] ; then
echo "Directory: $HOME/BTS_Log/ is not created"
exit
fi


#ExtendedSystemInfo.log
/opt/BTSOM/scripts/ExtendedSystemInfo_log.sh > $HOME/BTS_Log/ExtendedSystemInfo.log 2>&1


cp -p /ram/stats/RD.BTS-* $HOME/BTS_Log/
cp -p /ram/stats/PM.BTS-* $HOME/BTS_Log/
cp -p /ram/ActiveRawAlarmList.txt $HOME/BTS_Log/BTS$2_$3_ActiveRawAlarmList.txt
cp -p /ram/RawFaults.xml $HOME/BTS_Log/BTS$2_$3_RawFaults.xml
cp -p /ram/RawFaultsDropped.xml $HOME/BTS_Log/BTS$2_$3_RawFaultsDropped.xml
cp -p /ram/BtsOmAlarms.xml $HOME/BTS_Log/BTS$2_$3_BtsOmAlarms.xml
cp -p /ram/AlarmsSuppressed.xml $HOME/BTS_Log/BTS$2_$3_AlarmsSuppressed.xml
cp -p /rom/dcp/dcp_* $HOME/BTS_Log/BTS$2_$3_dcp_log.tar.z

if [[ ($# -eq 5 || $# -eq 6) && ! -z $5 ]]; then
    cp -p $5 $HOME/BTS_Log/
    sudo symptomreport delete --filename $(basename "$5") --force
    printLog "Copied and deleted symptom report data"
else
    printLog "Start collecting journal"
    journalctl -b > $HOME/BTS_Config/BTS$2_$3_journal.log
fi

if [[ $# -eq 6 && ! -z $6 ]]; then
    cp -p $6 $HOME/BTS_Log/
    printLog "Copied symptom report after init data"
fi

printLog "collected files to BTS_Log  directory, content:" >> $LOG_FILE
ls -al ${HOME}/BTS_Log >> $LOG_FILE

# copy the debug and syslogs for additional debugging if needed
if [[ $4 == "allVarLog" ]]; then
cp -pRL /var/user-data/ $HOME/BTS_Log/ && printLog "Copied /var/user-data/"
cp -pRL /var/log/swm_upgrade.log $HOME/BTS_Log/ && printLog "Copied /var/log/swm_upgrade.log"
cp -pRL /var/log/swm_rollback_controller_log_* $HOME/BTS_Log/ && printLog "Copied /var/log/swm_rollback_controller_log_*"
cp -pRL /var/log/swm_upgrade_controller_log_* $HOME/BTS_Log/ && printLog "Copied /var/log/swm_upgrade_controller_log_*"
cp -pRL /var/log/heatdata_upgrade.log $HOME/BTS_Log/ && printLog "Copied /var/log/heatdata_upgrade.log"
cp -pRL /var/log/checkWlcCohosting.log $HOME/BTS_Log/ && printLog "Copied /var/log/checkWlcCohosting.log"
cp -pRL /var/log/checkWlcCohosting.log.bkp $HOME/BTS_Log/ && printLog "Copied /var/log/checkWlcCohosting.log.bkp"

tar --ignore-command-error -C /mnt/log -cf /ram/cfzc_snapshot_supplement.tar cfzc_snapshot_supplement/
mv /ram/cfzc_snapshot_supplement.tar $HOME/BTS_Log/
printLog "Copied supplement dir"
else
cp -p /var/log/local/debug* $HOME/BTS_Log/
cp -p /var/log/local/syslog* $HOME/BTS_Log/
printLog "Copied only /var/log/local/debug/syslog"
fi

cp -p /rom/supervision/* $HOME/BTS_Log/SupervisionOut/
printLog "Copied supervision data"

cp -p /ffs/run/logs/swm_upgrade.log $PREVIOUS_UPGRADE_LOGS
cp -p /ffs/run/logs/heatdata_upgrade.log $PREVIOUS_UPGRADE_LOGS
printLog "Copied old upgrade logs"
ls -al $PREVIOUS_UPGRADE_LOGS >> $LOG_FILE

UVMLOGDIR=/mnt/log/UVMLOG
if [ -e "$UVMLOGDIR" ]; then
   printLog "Collecting files from $UVMLOGDIR"
   find "$UVMLOGDIR"/journal* 2>/dev/null | while read -r file;
   do
      if file "$file" | grep -q "Journal file"; then
        journalctl --file="$file" > "$file".txt 2>/dev/null
      fi
   done
   tar -zvcf "$HOME"/BTS_Log/UVMLOG.tar.gz "$UVMLOGDIR" >> "$LOG_FILE"
   printLog "Finished collecting files from $UVMLOGDIR"
fi

cd $HOME
printLog "package files from BTS_Log directory:"
find BTS_Log >> $LOG_FILE
printLog "copy log file itself"
cp $LOG_FILE $HOME/BTS_Log/
tar -zvcf BTS$2_$3_BTS_Log.tar.gz BTS_Log >> $LOG_FILE
rm -rf $HOME/BTS_Log

########################################################################################################################
