#/usr/app/bin/generate_snapshot.sh
DATE=`date +'%Y%m%d'`

if [[ $# -ne 3 ]]; then
echo "Usage: /usr/app/bin/generate_snapshot.sh <full/minor/crash> <btsid> <nodeid>"
exit
fi

if [[ $1 == "full" ]]; then
echo "Received FULL"
elif [[ $1 == "minor" ]]; then
echo "Received MINOR"
elif [[ $1 == "crash" ]]; then
echo "Received CRASH"
else
echo "Improper input ---- Usage: /usr/app/bin/generate_snapshot.sh <full/minor/crash> <btsid> <nodeid>"
fi

#Removing old Files if any from /ram/LTE/
rm -rf /ram/LTE/*BTS_Config*
rm -rf /ram/LTE/*BTS_Log*
rm -rf /ram/LTE/*TRS_Config*
rm -rf /ram/LTE/*TRS_Log*
rm -rf /ram/LTE/*_metadata*

########################################################################################################################
mkdir -p /ram/LTE/BTS_Config/

if [[ $? != 0 ]] ; then
echo "Directory: /ram/LTE/BTS_Log/ is not created"
exit
fi


cp -p /.persist/btsom/config/active/SiteConf.xml /ram/LTE/BTS_Config/BTS$2_$3_SiteConf.xml
cp -p /.persist/btsom/config/active/bts.xml /ram/LTE/BTS_Config/BTS$2_$3_bts.xml
cp -p /.persist/btsom/config/active/trs.xml /ram/LTE/BTS_Config/BTS$2_$3_trs.xml
cp -p /.persist/btsom/config/active/SCFC_rcvd.xml /ram/LTE/BTS_Config/BTS$2_$3_SCFC_rcvd.xml
cp -p /usr/app/cfg/SiteEM.xml /ram/LTE/BTS_Config/BTS$2_$3_SiteEM.xml
cp -p /usr/app/cfg/vendor.xml /ram/LTE/BTS_Config/BTS$2_$3_vendor.xml
cp -p /usr/app/cfg/LTE_CurrentBD.xml /ram/LTE/BTS_Config/BTS$2_$3_LTE_CurrentBD.xml
cp -p /usr/app/cfg/CUPL_BTSA_1_3221225472_LN30_FDLTE.xml /ram/LTE/BTS_Config/BTS$2_$3_CUPL_BTSA_1_3221225472_LN30_FDLTE.xml
cp -p /usr/app/config/CCSEarlyConfig.xml /ram/LTE/BTS_Config/BTS$2_$3_CCSEarlyConfig.xml
cp -p /usr/app/config/btsom_asn_config.txt /ram/LTE/BTS_Config/BTS$2_$3_btsom_asn_config.txt
cp -p /usr/app/config/AppDef.txt /ram/LTE/BTS_Config/BTS$2_$3_AppDef.txt
cp -p /usr/app/config/hwr_service.xml /ram/LTE/BTS_Config/BTS$2_$3_hwr_service.xml
cp -p /usr/app/config/hwr.xml /ram/LTE/BTS_Config/BTS$2_$3_hwr.xml
cp -p /usr/app/config/iwf.xml /ram/LTE/BTS_Config/BTS$2_$3_iwf.xml
cp -p /rom/swconfig.txt /ram/LTE/BTS_Config/BTS$2_$3_swconfig.txt
cp -p /usr/app/cfg/alarmRulesData.xml /ram/LTE/BTS_Config/BTS$2_$3_alarmRulesData.xml
cp -p /.persist/btsom/config/active/HWF.xml /ram/LTE/BTS_Config/BTS$2_$3_HWF.xml
cp -rp /.persist/btsom/config/inactive/* /ram/LTE/BTS_Config/

cd /ram/LTE/
tar -cf BTS$2_$3_BTS_Config.tar BTS_Config
gzip /ram/LTE/BTS$2_$3_BTS_Config.tar
rm -rf /ram/LTE/BTS_Config



########################################################################################################################
mkdir -p /ram/LTE/BTS_Log/

if [[ $? != 0 ]] ; then
echo "Directory: /ram/LTE/BTS_Log/ is not created"
exit
fi


#ExtendedSystemInfo.log
/usr/app/cfg/ExtendedSystemInfo_log.sh > /ram/LTE/BTS_Log/ExtendedSystemInfo.log 2>&1

cp -p /ram/aastartup_log.txt /ram/LTE/BTS_Log/BTS$2_$3_aastartup_log.txt
cp -p /ram/stats/RD.BTS-* /ram/LTE/BTS_Log/
cp -p /ram/stats/PM.BTS-* /ram/LTE/BTS_Log/
cp -p /ram/temp_AlarmHistory.txt /ram/LTE/BTS_Log/BTS$2_$3_AlarmHistory.txt
cp -p /ram/temp_RawAlarmHistory.txt /ram/LTE/BTS_Log/BTS$2_$3_RawAlarmHistory.txt
cp -p /ram/ActiveRawAlarmList.txt /ram/LTE/BTS_Log/BTS$2_$3_ActiveRawAlarmList.txt
cp -p /.persist/var/log/dan.log* /ram/LTE/BTS_Log/
cp -p /.persist/var/log/ltekm.log /ram/LTE/BTS_Log/BTS$2_$3_ltekm.log
cp -p /.persist/var/log/lteiwf.log /ram/LTE/BTS_Log/BTS$2_$3_lteiwf.log
cp -p /.persist/var/log/messages* /ram/LTE/BTS_Log/
cp -p /.persist/var/log/SOAPMsgTrace.xml /ram/LTE/BTS_Log/BTS$2_$3_SOAPMsgTrace.xml
 
cd /ram/LTE/
tar -cf BTS$2_$3_BTS_Log.tar BTS_Log
gzip /ram/LTE/BTS$2_$3_BTS_Log.tar
rm -rf /ram/LTE/BTS_Log

########################################################################################################################
mkdir -p /ram/LTE/TRS_Config/

if [[ $? != 0 ]] ; then
echo "Directory: /ram/LTE/TRS_Config/ is not created"
exit
fi



cp -p /trs/usr/local/etc/config.xml /ram/LTE/TRS_Config/BTS$2_$3_config.xml
cp -p /trs/usr/local/etc/OBSAI-View-MIB.xml /ram/LTE/TRS_Config/BTS$2_$3_OBSAI-View-MIB.xml
cp -p /trs/usr/local/etc/OBSAI-View-LTEW-MIB.xml /ram/LTE/TRS_Config/BTS$2_$3_OBSAI-View-LTEW-MIB.xml
cp -p /trs/usr/local/etc/pm_meas_config_ltew.xml /ram/LTE/TRS_Config/BTS$2_$3_pm_meas_config_ltew.xml
cp -p /trs/usr/local/etc/NMA_LTEW_mib.xml /ram/LTE/TRS_Config/BTS$2_$3_NMA_LTEW_mib.xml
cp -p /trs/usr/local/etc/NMA_mib.xml /ram/LTE/TRS_Config/BTS$2_$3_NMA_mib.xml
cp -p /trs/usr/local/etc/RAML_online_cfg_mib_ltew.xml /ram/LTE/TRS_Config/BTS$2_$3_RAML_online_cfg_mib_ltew.xml
cp -p /trs/usr/local/etc/RAML_mib_ltew.xml /ram/LTE/TRS_Config/BTS$2_$3_RAML_mib_ltew.xml

cd /ram/LTE/
tar -cf BTS$2_$3_TRS_Config.tar TRS_Config
gzip /ram/LTE/BTS$2_$3_TRS_Config.tar
rm -rf /ram/LTE/TRS_Config

########################################################################################################################

mkdir -p /ram/LTE/TRS_Log/

if [[ $? != 0 ]] ; then
echo "Directory: /ram/LTE/TRS_Log/ is not created"
exit
fi

#<TODO>

cd /ram/LTE/
tar -cf BTS$2_$3_TRS_Log.tar TRS_Log
gzip /ram/LTE/BTS$2_$3_TRS_Log.tar
rm -rf /ram/LTE/TRS_Log

########################################################################################################################
