#!/bin/sh
export BTSOMROOT=/opt/nokia/BTS_SC_OAM_FZM/

function logInfo()
{
    logger -p daemon.info -t BTSOM_PREPARE_FILESYSTEM "$@"
}

# Create the BTSOM config directories in /rom
mkdir -p /rom/btsom/config/active
mkdir -p /rom/btsom/config/backup
mkdir -p /rom/btsom/config/inactive/xoh
mkdir -p /rom/btsom/config/inactive/asn
logInfo "/rom/btsom/config directories created"

# Create the BTSOM config directories in /ram
mkdir -p /ram/LTE
mkdir -p /ram/stats
logInfo "/ram/LTE and /ram/stats directories created"

# Copy files
cp $BTSOMROOT/config/vendor_fdd.xml /ram
cp $BTSOMROOT/config/vendor_tdd.xml /ram
cp $BTSOMROOT/config/SiteEM-FZC_*.xml /rom/FlexiSiteEM_100000000007000000.xml
cp $BTSOMROOT/AdaptationVersions/* /rom
logInfo "Copied vendor, SiteEM and AdaptationVersions"

mkdir -p /opt/BTSOM/config
mkdir -p /opt/BTSOM/scripts
logInfo "Created /opt/BTSOM/config and /opt/BTSOM/scripts"

cp $BTSOMROOT/config/* /opt/BTSOM/config
cp $BTSOMROOT/script/* /opt/BTSOM/scripts
logInfo "Copied content to /opt/BTSOM/config and /opt/BTSOM/scripts from $BTSOMROOT"

#prepare files for data migration
cp $BTSOMROOT/config/SUTool /rom/btsom/config/active
chmod 755 /rom/btsom/config/active/SUTool
logInfo "Copied SUTool"

rm -rf /rom/SCFDFB*.txt
rm -rf /rom/SCFD-VERSION*.txt
cp /opt/nokia/SCFD/SCFDFB*.txt /rom
cp /opt/nokia/SCFD/SCFD-VERSION*.txt /rom
logInfo "Copied SCFD files"

if [ ! -e "/rom/btsom/config/active/autoconf.xml" ]
then
	cp $BTSOMROOT/usr/autoconf.xml /rom/btsom/config/active
	logInfo "Copied autoconf.xml"
fi

logInfo "Marking btsom files job done"
$BTSOMROOT/script/mark_prepare_filesystem_done.sh
