#!/bin/bash
#
# start_bstat.sh
#
#
# Function for error logging
#
function error()
{
    logger -p daemon.err -t BStat "$@"
}

#
# Function for info logging
#
function info()
{
    logger -p daemon.info -t BStat "$@"
}

Node=`echo $(hostname) | cut -d '-' -f1`

info "This is $Node node starting BStat."


export BTSOMROOT=/opt/nsn/BTS_SC_OAM_FZM
export LD_LIBRARY_PATH=lib:/lib64:/opt/nsn/BTS_SC_CCS/:$BTSOMROOT/lib:$LD_LIBRARY_PATH


#-----------------------------------------------------------------------------------
# Create the BTSOM config directores and copy files.
#-----------------------------------------------------------------------------------
/opt/nsn/BTS_SC_OAM_FZM/script/create_links.sh

#-----------------------------------------------------------------------------------
# wait for FZCTOAd
#-----------------------------------------------------------------------------------

TIMEOUT=120
i=0
while [ ! ` pgrep  ukTmgr ` ] ; do
    info "Waiting for FZCTOAd"
    sleep 5
    if [ $i -lt $TIMEOUT ]
    then
        ((i=i+5))
        info "Waiting for FZCTOAd $i sec, Timeout after $TIMEOUT"
    else
        error "Waiting for FZCTOAd timeout reached, exiting"
        exit 1
    fi
done
sleep 2

#-----------------------------------------------------------------------------------
# BTSOM startup
#-----------------------------------------------------------------------------------
info "launching BStat Apps"
exec $BTSOMROOT/bin/BStatexe 2>&1
