<?php
// *****************************************************************************
// -----------------------------------------------------------------------------
//			Copyright 2017, Nokia Networks
//			All Rights Reserved
// -----------------------------------------------------------------------------
//
// Title:	CbsdUpdateHandler.php
//
// Description:	This file handles a request from the client to update Cbsd SAS information.
//		The request is XML encoded and sent to the WebUI Agent for processing.
//		Any response from the agent is JSON encoded and sent as-is to the client.
//		                                                               
//
// ******************************************************************************

include_once "../../phplib/MessageHandler.php";
include_once "../../phplib/XmlMessageParser.php";
include_once "../../phplib/FailureResponse.php";
include_once "../../phplib/messages/CbsdUpdateRequest.php";
include_once "../../phplib/messages/CbsdUpdateResponse.php";


openlog("WebUI CGI: SAS", LOG_ODELAY, LOG_USER);


header("Content-type: application/json; charset=utf-8");
header("Cache-control: no-store");
header("Pragma: no-cache");

$SASInfoArray = array
(
    "latitude"   =>  array ("float", -90.0, 90.0),
    "longitude"  => array("float", -180.0, 180.0),
    "heightType" => array("int", 0, 1),//EHeightType_AGL = 0; EHeightType_AMSL = 1
    "height"     => array("int", -1000, 18000),
    "horizontalAccuracy" => array( "int", 1, 50),
    "verticalAccuracy" => array("int", 1, 3),
    "antennaAzimuth"   => array("int", 0, 359),
    "antennaDowntilt"  => array("int", -90,90),
    "antennaGain"      => array("int", -127, 128),
    "antennaBeamwidth" => array("int", 0, 360),
    "antennaModel"     => array( "string", 1, 128),
    "_cbsdId"           => array("int",0,4294967295)
);	

function rangeTest($value, $min, $max)
{
	if(!is_numeric($value))
		return false; 
	if(($value < $min) || ($value > $max))
		return false;
	else 
		return true;
}

function processform()
{
    global $SASInfoArray;
    $status = "Success";
    $validationStatus = array();
    $cbsdParamData = array();
    foreach($SASInfoArray as $cbsdParam => $cbsdParamInfo)
    {

        if(!(isset($_POST[$cbsdParam])) ||  ($_POST[$cbsdParam] == ""))
        {
          if($cbsdParam == "antennaGain")
          {
            $validationStatus[$cbsdParam] = "Missing Mandatory Param - ". $_POST[$cbsdParam];
            continue;
          }
          else
          {
            $validationStatus[$cbsdParam] = "valid";
            continue;
          }
        }
	if ($cbsdParamInfo[0] == "int" || $cbsdParamInfo[0] == "float") 
        {
            if (rangeTest($_POST[$cbsdParam], $cbsdParamInfo[1], $cbsdParamInfo[2])) 
            {
	            $validationStatus[$cbsdParam] = "valid";
                $cbsdParamData[$cbsdParam] = $_POST[$cbsdParam];
            }
            else
            {
                $status = "OutofRange Parameter";
                $validationStatus[$cbsdParam] = "Out of Range - ". $_POST[$cbsdParam];
            }
        }
	else if ($cbsdParamInfo[0] == "string")
        {
            $varLen = strlen($_POST[$cbsdParam]);
	    if( $varLen >=  $cbsdParamInfo[1] && $varLen <= $cbsdParamInfo[2])
	    {
                $cbsdParamData[$cbsdParam] = $_POST[$cbsdParam];
		        $validationStatus[$cbsdParam] = "valid";
            }
            else
            {
                $status = "OutOfRange String";
                $validationStatus[$cbsdParam] = "Out of range string Len:". $varLen . " - ". $_POST[$cbsdParam];

            }
            
        }
	else
        {
            $validationStatus[$cbsdParam] = "valid";
        }

    }
    return array($status,$validationStatus,$cbsdParamData);
}

// Read session cookie sent by client. Should always be available unless user
// has disabled cookies (would cause unavailability of WebUI service).
if( !isset( $_COOKIE[ "FZAPWebUISession" ] ) )
{
	// Unexpected. User should not have been able to access WebUI page with
	// cookies disabled. Log error and send failure indication.
	syslog( LOG_ERR, "No session cookie" );

	FailureResponse::SendFailureResponse( "CGI - Client cookie not received" );

	closelog();
	exit();
}

// Session cookie received from client. Retrieve user session ID. Needs to be
// sent to the WebUIAgent for validation (with every request).
$sessionId = $_COOKIE[ "FZAPWebUISession" ];

if( !(isset( $_POST["csrfToken"] )) || ($_POST["csrfToken"] == "") )
{
	// No post'ed data, or missing IP address. Return failure indication.
	syslog( LOG_ERR, "Missing CSRF Token" );

	FailureResponse::SendFailureResponse( "CGI - Missing CSRF Token" );

	closelog();
	exit();
}

$csrfToken = $_POST["csrfToken"];

$formStatus = processform();

if($formStatus[0] != "Success")
{
	syslog( LOG_ERR, "Cbsd update validation failure " . $formStatus[0]);

	FailureResponse::SendFailureResponse( $formStatus[0],$formStatus[1]);

	closelog();
	exit();
}

//create and validate message
$cbsdInputParams = $formStatus[2];
$cbsdUpdateRequest = new CbsdUpdateRequest($sessionId,$csrfToken);

if( is_null( $cbsdUpdateRequest ) )
{
	syslog( LOG_ERR, "Failed to allocate memory for CbsdUpdateRequest message" );

	FailureResponse::SendFailureResponse( "CGI - Memory allocation failure" );

	closelog();
	exit();
}

//Set the fields in the update request
if(array_key_exists("latitude",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetLatitude($cbsdInputParams["latitude"]);
    }
if(array_key_exists("longitude",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetLongitude($cbsdInputParams["longitude"]);
    }
if(array_key_exists("heightType",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetHeightType($cbsdInputParams["heightType"]);
    }
if(array_key_exists("height",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetHeight($cbsdInputParams["height"]);
    }
if(array_key_exists("horizontalAccuracy",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetHorizontalAccuracy($cbsdInputParams["horizontalAccuracy"]);
    }
if(array_key_exists("verticalAccuracy",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetVerticalAccuracy($cbsdInputParams["verticalAccuracy"]);
    }
if(array_key_exists("antennaAzimuth",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetAntennaAzimuth($cbsdInputParams["antennaAzimuth"]);
    }
if(array_key_exists("antennaDowntilt",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetAntennaDowntilt($cbsdInputParams["antennaDowntilt"]);
    }
if(array_key_exists("antennaGain",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetAntennaGain($cbsdInputParams["antennaGain"]);
    }
if(array_key_exists("antennaBeamwidth",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetAntennaBeamwidth($cbsdInputParams["antennaBeamwidth"]);
    }
if(array_key_exists("antennaModel",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetAntennaModel($cbsdInputParams["antennaModel"]);
    }
if(array_key_exists("_cbsdId",$cbsdInputParams))
    {
        $cbsdUpdateRequest->SetCbsdId($cbsdInputParams["_cbsdId"]);
    }
else
    {
    	syslog( LOG_ERR, "CbsdUpdateRequest message missing cbsdid" );

	    FailureResponse::SendFailureResponse( "CGI - Message sending missing cbsdid" );

		closelog();
		exit();
	    
    }
// Send the message. The MessageHandler will wait for and return the response,
// if any.
$response = MessageHandler::SendAndReceive( $cbsdUpdateRequest->XmlMsg() );
if( is_null( $response ) )
{
	syslog( LOG_ERR, "Failed to send ChsdUpdateRequest message and/or receive response" );

	FailureResponse::SendFailureResponse( "CGI - Message send or receive failure" );

	closelog();
	exit();
}

//parse and validate
// Parse the received XML message response.
$msg = XmlMessageParser::ParseMsg( $response );

// Validate response.
if( (is_null( $msg )) || ($msg->OK() != true) || ($msg->GetMessageType() != "CbsdUpdateResponse") )
{
	// Remove line breaks from response string and print to syslog.
	$msgString = str_replace( "\n", null, $response );
	syslog( LOG_ERR, "Invalid or null CbsdUpdateResponse message: " . $msgString );

	// Internal error (e.g., protocol error between agent and HTTP server).
	FailureResponse::SendFailureResponse( "CGI - Invalid or null CbsdUpdateResponse" );

	closelog();
	exit();
}


//json encode and echo
// No need to check success or failure; will be handled by client. Encode response message
// as JSON and send to client.
$jsonString = json_encode( $msg );

// Check encoding result
if( $jsonString == false )
{
	// JSON encoding failed. Received message must have been invalid.
	syslog( LOG_ERR, "JSON encoding failed" );
	FailureResponse::SendFailureResponse( "CGI - JSON encoding failure" );

	closelog();
	exit();
}


// Output encoded JSON string to client.
echo $jsonString;

closelog();


?>
