<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ModifyBandClass.php
//
// Description:	This file handles an asyncronous request from the client for
//		an update to the band class. The request is XML encoded and
//		sent to the WebUI Agent for processing. Any response from the
//		agent is JSON encoded and sent as-is to the client (pass-thru).
//
// ****************************************************************************

include_once "../../phplib/MessageHandler.php";
include_once "../../phplib/XmlMessageParser.php";
include_once "../../phplib/FailureResponse.php";

include_once "../../phplib/messages/ModifyBandClassRequest.php";
include_once "../../phplib/messages/ModifyBandClassResponse.php";

openlog("WebUI CGI: LOG_ODELAY", LOG_USER);

header("Content-type: application/json;charset=utf-8");
header("Cache-control: no-store");
header("Pragma: no-cache");

// Read session cookie sent by client. Should always be available unless user
// has disabled cookies (would cause unavailability of WebUI service).
if( !isset( $_COOKIE[ "FZAPWebUISession" ] ) )
{
	// Unexpected. User should not have been able to access WebUI page with
	// cookies disabled. Log error and send failure indication.
	syslog( LOG_ERR, "No session cookie" );

	FailureResponse::SendFailureResponse( "CGI - Client cookie not received" );

	closelog();
	exit();
}

// Session cookie received from client. Retrieve user session ID. Needs to be
// sent to the WebUIAgent for validation (with every request).
$sessionId = $_COOKIE[ "FZAPWebUISession" ];

if( !(isset( $_POST["bc"])) || ($_POST["bc"] === ""))
{
  // No post'ed data, or missing token. Return failure indication.
  syslog( LOG_ERR, "Missing Band Class" );
  
  FailureResponse::SendFailureResponse( "CGI - Missing Band Class" );
  
  closelog();
  exit();
}    
if( !(isset( $_POST["ctkn"] )) || ($_POST["ctkn"] === "") )
{
        // No post'ed data, or missing token. Return failure indication.
        syslog( LOG_ERR, "Missing CSRF Token" );

        FailureResponse::SendFailureResponse( "CGI - Missing CSRF Token" );

        closelog();
        exit();
}
$csrfToken = $_POST["ctkn"];    
$bandClass = $_POST["bc"];

$modifyBandClassRequest = new ModifyBandClassRequest($sessionId, $csrfToken);
if(is_null($modifyBandClassRequest))
{
 	syslog( LOG_ERR, "Failed to allocate memory for ConfigResetRequest message" );
	FailureResponse::SendFailureResponse( "CGI - Memory allocation failure" );

	closelog();
	exit(); 
}

$modifyBandClassRequest->SetBandClass($bandClass);

$response = MessageHandler::SendAndReceive($modifyBandClassRequest->XmlMsg());
if(is_null($response))
{
  syslog(LOG_ERR, "Failed to send ModifyBandClassRequest message and/or receive response");
  FaiiureResponse::SendFailureResponse("CGI - Message send or receive failure");
  closelog();
  exit();
}

$msg = XmlMessageParser::ParseMsg($response);

if((is_null($msg)) || ($msg->OK() !== true) || ($msg->GetMessageType() !== "ModifyBandClassResponse"))
{
  // Remove line breaks from response string and print to syslog.
  $msgString = str_replace( "\n", null, $response );
  syslog( LOG_ERR, "Invalid or null ModifyBandClassResponse message: " . $msgString );
  if(is_null( $msg ))
    {
      FailureResponse::SendFailureResponse( "CGI - Null ModifyBandClassResponse" );
    }
  else if($msg->OK() !== true)
    {
      FailureResponse::SendFailureResponse( "CGI - Invalid ModifyBandClassResponse" );
    }
  else if($msg->GetMessageType() !== "ModifyBandClassResponse"){
    // Internal error (e.g., protocol error between agent and HTTP server).
    FailureResponse::SendFailureResponse( "CGI - expected ModifyBandClassResponse but received " . $msg->GetMessageType() );
  }
  closelog();
  exit();
}

$jsonString = json_encode($msg);
if($jsonString === false)
{
  syslog(LOG_ERR, "JSON encoding failed");
  FailureResponse::SendFailureResponse("CGI - JSON encoding failure");

  closelog();
  exit();
}

echo $jsonString;


