<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2018, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	SnapshotDownloadHandler.php
//
// Description:	This file triggers a download on the browser for the snapshot 
//		         file after verifying a valid session.
//
// ****************************************************************************
include_once "../../phplib/SessionHelper.php";
openlog( "WebUI CGI: Snapshot", LOG_ODELAY, LOG_USER );
header("Cache-control: no-store");
header("Pragma: no-cache");

function outputFailureResponse($error_message)
{
        header( "HTTP/1.1 503 Service Unavailable" );

        echo "<html><head><meta charset=\"utf-8\"/></head></html>";
        echo "<h2>HTTP/1.1 503 Service Unavailable</h2>";
        echo "<h4>" . $error_message . "</h4>";
}

if( isset( $_COOKIE["FZAPWebUISession"] ) )
{
    // Session cookie received from client. Retrieve user session ID.
    $sessionId = $_COOKIE["FZAPWebUISession"];

    $retval = SessionHelper::ValidateSession( $sessionId);
    if( $retval !== SessionHelper::SESSION_VALID )
    {
        outputFailureResponse("Invalid session - bad session token");
        closelog();
        exit();
    }
}
else
{
        outputFailureResponse("Invalid session - no session token");
	closelog();
	exit();
}

if(isset( $_SERVER["QUERY_STRING"]))
{
    $snapshotFileName = $_SERVER["QUERY_STRING"];
    $snapshotBase = basename($snapshotFileName);
    $snapshotFilePath = "/opt/BTSOM/www/snapshot/" . $snapshotBase;
    if(!is_file($snapshotFilePath))
    {
        outputFailureResponse("Internal error");
        closelog();
        exit();
    }
    header_remove("Content-type");
    header("Content-type: application/x-tar-gz");
    header("Pragma: public");
    header("Expires: -1");
    header("Cache-Control: public, must-revalidate, post-check=0, pre-check=0");
    header("Content-Disposition: attachment; filename=\"$snapshotBase\"");
    readfile($snapshotFilePath);
}
else
{
    outputFailureResponse("Internal file error");
    closelog();
    exit();
}
closelog();
exit();
?>