// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		About.js
//
// ****************************************************************************

( function( $ )
{

	NSNReady( function()
	{

		$( "#browsersLink" ).click( function()
		{
			var $browsersDialog = $( "#browsersDialog" );
			if( $browsersDialog.is( ":visible" ) )
			{
				// Dialog window already open.
				return;
			}

			// Open the dialog
			$browsersDialog.trigger( "open" );

			// Set focus to close button once dialog has opened.
			setTimeout( function()
			{
				$( "#browsersCloseButton" ).focus();
			}, 100 );

			$( "#browsersCloseButton" ).click( function()
			{
				if( $( this ).is( ".disabled" ) )
				{
					return;
				}

				// Close the dialog window.
				$browsersDialog.trigger( "close" );
			});
		});
	});

})( jQuery )
