// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2016, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		BandFilter.js
//
// ****************************************************************************

( function( $ )
{
    var xmlHttpModifyBandClassRequest;
    NSNReady(function()
    {
        $("#changeBandClassLink").click(function() {
            
                if( $( this ).parent().is( ".disabled" ) )
                {
                    return;
                }

                if($("#bandClassDialog").is(":visible"))
                {
                    //Dialog window already open
                    return;
                }
                var $closeButton = $("#bandClassCloseButton");
                var $startButton = $("#bandClassStartButton");
                var $radioButtons = $('input[type=radio][name=filterType]');

                //Init settings for bandclass dialog
                //Display current HW Variant
		        $("#bandClassCurrent").text($("#unitName").text());
                //Hide Progress Indicator and additional reset warning
                $("#bandClassProgressIndicator").hide();
                //set classes for buttons
                //setting Close to call-to-action to avoid accidental resets
                //setting Start to disabled until the radio value changes
                $startButton.addClass("disabled")
                    .removeClass("call-to-action")
                    .show();
                
                $closeButton.removeClass("disabled")
                    .addClass("call-to-action")
                    .show()
                    .find(".button-content").text("Cancel");

                var accessRight = $( "#menuPanel" ).find( "input[name='accessRight']" ).val();
                var accountRole = $( "#menuPanel" ).find( "input[name='accountRole']" ).val();
                if((accessRight !== "read-write") || (accountRole !== "sysAdmin"))
                {
                    $("[name='filterType']").parent().next().add("disabled");
                    $("#fwhr").parent().next().click().addClass("disabled");
                    $("#fwhrlb").parent().next().click().addClass("disabled");
                    $("#fwhrhb").parent().next().click().addClass("disabled");
                    
                    $( "#bandClassProgressIndicator" )
                    .removeClass()
                    .addClass( "step warning" )
                    .find( ".text" ).text("Invalid AccessRight or AccountRole" ).end()
                    .show();
                }
                else
                {
                    //enable all radio buttons
		            $("[name='filterType']").parent().next().removeClass("disabled");
                    
                    
                    //set radio button to current value and disable current value
                    if($("#unitName").text() === "FWHR")
                    {
                        $("#fwhr").parent().next().click().addClass("disabled");
                    }
                    else if($("#unitName").text() === "FWHRLB")
                    {
                        $("#fwhrlb").parent().next().click().addClass("disabled");
                    }
                    else if($("#unitName").text() === "FWHRHB")
                    {
                       $("#fwhrhb").parent().next().click().addClass("disabled");
                    }

                }

                
                $("#bandClassResetWarning").hide();
               
                //Set focus to close button when dialog is open
                setTimeout(function()
                 {
                     $closeButton.focus();
                 }, 100);
                
                //handle a radio button change
                $radioButtons.change(function()
                {
	                $("#bandClassResetWarning").show();
                	$startButton.removeClass("disabled");
                    if($("#unitName").text() == $("#bandClassDialog input[name=filterType]:checked").val())
                    {
                        $startButton.addClass("disabled");
                    }
                    else
                    {
                                    $startButton.removeClass("disabled");
                    }
                });
                
                //click handler for close button
                $closeButton.click( function() {
                        if( $( this ).is( ".disabled" ) )
                            {
                                return;
                            }
                        $( this ).addClass( "disabled" );
                        
                        // Close the dialog window.
                        $( "#bandClassDialog" ).trigger( "close" );
                    });
                
                //handle the start button click
                $startButton.click(function()
                {
                      //do nothing if start button is disabled
                      if($(this).is(".disabled"))
                      {
                          return;
                      }
                      
                      //disable the button
                      $(this).addClass("disabled");
		              $closeButton.addClass("disabled");        
                      updateAndShowProgressIndicator("current", "Changing HW Variant");
                      sendModifyBandClassRequest();
                });

		        $( "#bandClassDialog" ).bind( "close", function() {
                        // Stop any ongoing request.
                        // Note, the dialog window itself is closed by handler in webuiDialogs.js
                        if( typeof xmlHttpModifyBandClassRequest !== "undefined" ){
                            xmlHttpModifyBandClassRequest.removeEventListener( "readystatechange", processModifyBandClassResponse, false );
                            xmlHttpModifyBandClassRequest.abort();
                        }
 
                  });
                //Open the dialog
                $("#bandClassDialog").trigger("open");

            });
    });

    var sendModifyBandClassRequest = function(){
        //Create and send XMLHttpRequest to server.
        try{
            xmlHttpModifyBandClassRequest = new XMLHttpRequest();
            //Register event listener for response
            xmlHttpModifyBandClassRequest.addEventListener("readystatechange",processModifyBandClassResponse, false);
            var url = "cgi-bin/ModifyBandClass.php";

            //Get security token
            var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();
            var csrfTokenEncoded = encodeURIComponent( csrfToken );

            //Read band class value from radio
            var $bandClassFromRadio = $("#bandClassDialog input[name=filterType]:checked").val();
            var postData = "bc=" + $bandClassFromRadio + "&ctkn=" + csrfTokenEncoded;
            
            xmlHttpModifyBandClassRequest.open("POST",url,true);

            // Set encoding used for the request body (HTML form) and length of contents.
            xmlHttpModifyBandClassRequest.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
            xmlHttpModifyBandClassRequest.setRequestHeader( "Content-length", postData.length );

            xmlHttpModifyBandClassRequest.send(postData);
        }
        catch( exception ){
            console.log("Asynchronous modify band class request failed");

            updateAndShowProgressIndicator("error");
            updateButtonsOnFailure();
            return;
        }
    }
                
    var processModifyBandClassResponse = function(){
        if( (xmlHttpModifyBandClassRequest.readyState == 4) && (xmlHttpModifyBandClassRequest.status == 200) ){
            var modifyBandClassResponse;

            try{
                modifyBandClassResponse = JSON.parse(xmlHttpModifyBandClassRequest.responseText);
            }
            catch (exception){
                // Parsing failure
                console.log( "JSON parsing error in processModifyBandClassResponse():\n" + exception );
                console.log( xmlModifyBandClassRequest.responseText );
                updateAndShowProgressIndicator("error");
                updateButtonsOnFailure();
                return;
            }

            if(!("statusInd" in modifyBandClassResponse)){
                console.log("Invalid modify band class response; missing status indicator");
                updateAndShowProgressIndicator("error");
                updateButtonsOnFailure();
                return;
            }
            
            if(modifyBandClassResponse.statusInd === "Success"){
                //Update progress indication
                updateAndShowProgressIndicator("success");
                updateButtonsOnSuccess();

                // Let link management know that a reset is expected
                $(document).trigger("resetInitiated");
            }
            //Handle failure responses
            else{
                if( !("_failReason" in modifyBandClassResponse)){
                    console.log("Invalid modify band class response; missing failure response");
                    updateAndShowProgressIndicator("error");
                    updateButtonsOnFailure();
                    return;
                }
                if(modifyBandClassResponse._failReason === "invalidSession"){
                    updateAndShowProgressIndicator("warning", "Session expired");

                    // User session has expired
                    window.alert("Session has expired - Please login again");

                    // Open login page with session expired indication
                    location.assign("login.php?expired");
                    return;
                }
                if(modifyBandClassResponse._failReason === "invalidSecurityToken"){
                    updateAndShowProgressIndicator("warning", "Security Token expired");

                    // User session has expired
                    window.alert("Security Token has expired - Please login again");

                    // Open login page with session expired indication
                    location.assign("login.php?expired");
                    return;
                }

                console.log("Modify Band Class response failure reason: " + modifyBandClassResponse._failReason);
                updateButtonsOnFailure();
                updateAndShowProgressIndicator("error");
            }
        }
        else if (xmlHttpModifyBandClassRequest.readyState == 4)
        {
            // HTTP level failure has occured
            console.log("Failed to receive modifyBandClass response from server");
            updateAndShowProgressIndicator("error");
            updateButtonsOnFailure();
        }
    }

    var updateAndShowProgressIndicator = function( stepName, displayText )
    {
        // displayText argument is "optional". Expected to be explicitly passed
        // by calling function for info and warning step indicators.
        if( typeof displayText === "undefined" ){
            switch( stepName ){case "current":
                               displayText = "Performing operation";
                               break;
                               
            case "error":
                               displayText = "Operation failed";
                               break;
                               
            case "success":
                               displayText = "Update successful; reset initiated";
                               break;
                               
            default:
                               // Explicit display text should have been provided.
                               console.log( "Unrecognized step: " + stepName );
                               return;
            }
        }
        
        var classList = "step " + stepName;

        $( "#bandClassProgressIndicator" )
        .removeClass()
        .addClass( classList )
        .find( ".text" ).text( displayText ).end()
        .show();
    }

    var updateButtonsOnSuccess = function()
    {
        var $closeButton = $("#bandClassCloseButton");
        $closeButton.removeClass( "disabled" );
        $closeButton.addClass( "call-to-action" ).find(".button-content").text("Close");
        $("#bandClassStartButton").removeClass("call-to-action" ).addClass("disabled").hide();
    }
    var updateButtonsOnFailure = function(){
        var $closeButton = $("#bandClassCloseButton");
	var $startButton = $("#bandClassStartButton");
	$startButton.removeClass("disabled");
	$closeButton.removeClass( "disabled" ).find(".button-content").text("Close");
        $closeButton.addClass( "call-to-action" );
    }
}) ( jQuery )

    

                
