// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		ConfigReset.js
//
// ****************************************************************************

( function( $ ){

  var xmlHttpConfigRequest;
  NSNReady(function (){
      if( $( this ).parent().is( ".disabled" ) )
      {
            return;
      }

     // Add event listener for config reset link.
     $( "#configResetLink" ).click( function() {
        var $configResetDialog = $("#configResetDialog");
        if( $configResetDialog.is(":visible")){
           // Dialog window already open
           return;
        }
         
        if( $( this ).parent().is( ".disabled" ) )
        {
            return;
        }

        // Initial settings. Progress indication is shown once reset operation
        // is initiated. The close button is initially labeled Cancel to indicate the
        // user can close the dialog window without starting the procedure. The label
        // is changed to Close once the operation is complete.
         
         
        enableCheckbox();
         //hide progress indicator
        $("#configResetProgressIndicator").hide();
         
        var accountRole = $( "#menuPanel" ).find( "input[name='accountRole']" ).val();
        if(accountRole === "appAdmin")
        {
            $("#removeSecCredCheckbox").prop("disabled",true);
        }
         
        
        
         
        // initialize confirm button
        var $confirmButton = $("#configResetConfirmButton")
        $confirmButton.find(".button-content" ).text( "Confirm" );
		$confirmButton.removeClass( "disabled" ).show();
		$confirmButton.removeClass("call-to-action");
        //initialize cancel button
		var $cancelButton = $( "#configResetCancelButton" );
		$cancelButton.removeClass( "disabled" );
		$cancelButton.addClass( "call-to-action" );
		$cancelButton.find( ".button-content" ).text( "Cancel" );
        $( "#configResetErrorDescription" ).hide().prev().removeClass( "ruled" );
         
        var accessRight = $( "#menuPanel" ).find( "input[name='accessRight']" ).val();
        var accountRole = $( "#menuPanel" ).find( "input[name='accountRole']" ).val();
        if((accessRight !== "read-write") || (accountRole !== "sysAdmin" &&  accountRole !== "appAdmin"))
        {
	    $confirmButton.addClass("disabled");
            $("#removeSecCredCheckbox").prop("disabled",true);
            $("#removeSiteIdCheckbox" ).prop('disabled', true);
            $("#configResetProgressIndicator" )
            .removeClass()
            .addClass( "step warning" )
            .find( ".text" ).text("Invalid AccessRight or AccountRole" ).end()
            .show();
        }

		// Set focus to cancel button once dialog has opened.
		setTimeout( function()
		{
            $cancelButton.focus();
        }, 100 );

		$confirmButton.focus(function()
		{
		    if($(this).is(".disabled"))
			{
				return;
			}
                        
			$(this).addClass("call-to-action");
			$cancelButton.removeClass("call-to-action");
        });
                        
		$confirmButton.blur(function()
		{
		    $(this).removeClass("call-to-action");
            $cancelButton.addClass("call-to-action");
        });
         
        //open config reset dialog
        $configResetDialog.trigger( "open" ); 

        // Event listener for confirm button 
        $confirmButton.click( function(){
           if( $( this ).is( ".disabled" ) ){
              return;
           }

           $cancelButton.addClass("disabled");
           $( this ).addClass( "disabled" );
           updateAndShowProgressIndicator( "current" );
           $( "#configResetErrorDescription" ).hide().prev().removeClass( "ruled" );
           sendConfigResetRequest();        
        });

        $cancelButton.click(function(){
           if( $( this ).is(".disabled") ){
              return;
           }
           // Close the dialog window.
           $configResetDialog.trigger("close");
        });

        $("#configResetDialog").bind( "close", function(){
           // Stop any ongoing request.
           // Note, the dialog window itself is closed by handler in webuiDialogs.js
           if( typeof xmlHttpConfigRequest !== "undefined" ){
              xmlHttpConfigRequest.removeEventListener( "readystatechange", processConfigResetRequestResponse, false );
              xmlHttpConfigRequest.abort();
           }
        });




     });
  });

  var sendConfigResetRequest = function(){
     // Create and send XMLHttpRequest to server.
     try{
        xmlHttpConfigRequest = new XMLHttpRequest();     
        // Register event listener for response
        xmlHttpConfigRequest.addEventListener( "readystatechange", processConfigResetRequestResponse, false );
        var url = "cgi-bin/ConfigReset.php";
		var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();
		var csrfTokenEncoded = encodeURIComponent( csrfToken );

        //get values of checkbox
        var removeSiteIdParm = "false";
        var removeSecCredParm = "false";

        if($("#removeSiteIdCheckbox").is(":checked"))
        {
           removeSiteIdParm = "true";
        }

        if($("#removeSecCredCheckbox").is(":checked"))        {
           removeSecCredParm = "true";
        }

        var postData = "rsi=" + removeSiteIdParm + "&rsc=" + removeSecCredParm + "&ctkn=" + csrfTokenEncoded;

        // POST information asynchronously
        xmlHttpConfigRequest.open( "POST", url, true );

        // Set encoding used for the request body (HTML form) and length of contents.
        xmlHttpConfigRequest.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
        xmlHttpConfigRequest.setRequestHeader( "Content-length", postData.length );

        xmlHttpConfigRequest.send(postData);
     }
     catch( exception ){
        console.log( "Asynchronous config reset request failed" );

        updateAndShowProgressIndicator( "error" );
        updateButtonsOnFailure();
        return;
     }
  }

  var processConfigResetRequestResponse = function(){
     if( (xmlHttpConfigRequest.readyState == 4) && (xmlHttpConfigRequest.status == 200) ){
        var configResetRequestResponse;

        try{
           configResetRequestResponse = JSON.parse(xmlHttpConfigRequest.responseText);                 
        }
        catch (exception){
        // Parsing failure
           console.log( "JSON parsing error in processConfigResetRequestResponse():\n" + exception );
           console.log( xmlHttpConfigRequest.responseText );
           updateAndShowProgressIndicator( "error" );
           updateButtonsOnFailure();
           return;
        }

        if(!("statusInd" in configResetRequestResponse)){
           console.log( "Invalid config reset response; missing status indicator" );
           updateAndShowProgressIndicator( "error" );
           updateButtonsOnFailure();
           return;
        }
        if(configResetRequestResponse.statusInd === "Success"){
         // Update progress indication.
           updateAndShowProgressIndicator( "success" );
           updateButtonsOnSuccess();

           // Also let link management functionality know that a reset has been
           // initiated (loss of link expected).
           $( document ).trigger( "resetInitiated" );
        }
        else{
           if( !("_failReason"  in configResetRequestResponse)){
              console.log( "Invalid config reset response; missing failure reason" );
              updateAndShowProgressIndicator( "error" );
              updateButtonsOnFailure();
              return;
           }
		   if(configResetRequestResponse._failReason === "invalidSession"){

			   updateAndShowProgressIndicator( "warning", "Session expired" );

			   // User session has expired.
			   window.alert( "Session has expired - Please login again" );

			   // Open login page with session expired indication.
			   location.assign( "login.php?expired" );
			   return;
		   }

		   if(configResetRequestResponse._failReason === "invalidSecurityToken"){
			   updateAndShowProgressIndicator( "warning", "Security Token expired" );

			   // User session has expired.
			   window.alert( "Security token has expired - Please login again" );

			   // Open login page with session expired indication.
			   location.assign( "login.php?expired" );
			   return;
		   }

       console.log("Reset req failure reason: " + configResetRequestResponse._failReason);
       if(configResetRequestResponse._failReason === "busy"){
           updateAndShowProgressIndicator( "error", "Site busy");
           $( "#configResetErrorDescription" ).show().prev().addClass( "ruled" );
           updateButtonsOnBusy();
       }
           // Procedure failed.
           else{
              updateButtonsOnFailure();
              updateAndShowProgressIndicator( "error" );
           }
       }
     }
     else if( xmlHttpConfigRequest.readyState == 4 )
     {
        // HTTP level failure has occurred.
        console.log( "Failed to receive config reset change response from server" );

        // Update progress indication.
        updateAndShowProgressIndicator( "error" );
        updateButtonsOnFailure();
     }

  }
  var updateAndShowProgressIndicator = function( stepName, displayText ){
     // displayText argument is "optional". Expected to be explicitly passed
     // by calling function for info and warning step indicators.
     if( typeof displayText === "undefined" ){
        switch( stepName ){case "current":
           displayText = "Performing operation";
           break;

        case "error":
           displayText = "Operation failed";
           break;

        case "success":
           displayText = "Reset initiated";
           break;

        default:
         // Explicit display text should have been provided.
           console.log( "Unrecognized step: " + stepName );
           return;
        }
     }

     var classList = "step " + stepName;

     $( "#configResetProgressIndicator" )
     .removeClass()
     .addClass( classList )
     .find( ".text" ).text( displayText ).end()
     .show();
  }


  var updateButtonsOnSuccess = function(){

     var $cancelButton = $("#configResetCancelButton");
     $cancelButton.removeClass( "disabled" );
     $cancelButton.addClass( "call-to-action" );
     $cancelButton.find( ".button-content" ).text( "Close" );
     $("#configResetConfirmButton").removeClass("call-to-action" ).addClass("disabled").hide();
     disableCheckbox();
  }
  var updateButtonsOnBusy = function(){
     var $cancelButton = $("#configResetCancelButton");
     $cancelButton.removeClass( "disabled" );
     $cancelButton.removeClass( "call-to-action" );
     $cancelButton.find( ".button-content" ).text( "Close" );
     $("#configResetConfirmButton").addClass("call-to-action" )
     .removeClass("disabled")
     .find(".button-content" )
     .text( "Retry" );
  }
  var updateButtonsOnFailure = function(){
     var $cancelButton = $("#configResetCancelButton");
     $cancelButton.removeClass( "disabled" );
     $cancelButton.find( ".button-content" ).text( "Close" );
     $("#configResetConfirmButton").addClass("disabled").hide();
     $cancelButton.addClass( "call-to-action" );
  }
  var disableCheckbox = function(){
    $("#removeSiteIdCheckbox").prop("disabled",true);
    $("#removeSecCredCheckbox").prop("disabled",true);
  }
  var enableCheckbox = function(){
    $("#removeSiteIdCheckbox").prop("disabled",false);
    $("#removeSecCredCheckbox").prop("disabled",false);
  }
}) ( jQuery )
