// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		ConfigureSiteId.js
//
// ****************************************************************************

var xmlHttpSiteId;

NSNReady(function ()
{

	// Add event listener for configure site ID link.
	$( "#configureSiteIdLink" ).click( function()
	{
        if( $( this ).parent().is( ".disabled" ) )
        {
            return;
        }
        
		var $dialog = $( "#siteIdDialog" );

		if( $dialog.is( ":visible" ) )
		{
			// Dialog window already open.
			return;
		}

       
		// May not be the first time the dialog is opened, so hide the status field.
		$( "#siteIdStatus" ).hide();

		var $sendButton = $dialog.find("#sendButton");
		var $closeButton = $dialog.find("#closeButton");
		$sendButton.removeClass( "disabled" ).show();
                $sendButton.removeClass("call-to-action");
        
		$closeButton.removeClass( "disabled" )
			.find( ".button-content" ).text( "Cancel" ).end()
			.blur();
		$closeButton.addClass("call-to-action");

		$( "#siteIdField" ).parent().removeClass( "error" );
		$( "#siteIdErrorDescription" ).hide().prev().removeClass( "ruled" );

                var accessRight = $( "#menuPanel" ).find( "input[name='accessRight']" ).val();
                if(accessRight !== "read-write")
                {
	            $sendButton.addClass("disabled");
                    $( "#siteIdField" ).prop('disabled', true);
                    $( "#siteIdStatus" )
                    .removeClass()
                    .addClass( "step warning" )
                    .find( ".text" ).text("Read-Only User" ).end()
                    .show();
                }
        
                var accountRole = $( "#menuPanel" ).find( "input[name='accountRole']" ).val();
                if(accountRole !== "sysAdmin")
                {
                    $sendButton.addClass("disabled");
                    $( "#siteIdField" ).prop('disabled', true);
                    $( "#siteIdStatus" )
                    .removeClass()
                    .addClass( "step warning" )
                    .find( ".text" ).text("Invalid Account Role" ).end()
                    .show();
                
                }
		$dialog.trigger( "open" );

		// Set focus to site ID input field once dialog has opened.
		setTimeout( function()
		{
			$( "#siteIdField" ).select();
            $( "#closeButton" ).focus();
		}, 200 );

		$( "#siteIdField" ).keypress( function()
		{
			$( this ).parent().removeClass( "error" );
			$( "#siteIdStatus" ).hide();
		});

       
        
		$closeButton.focus(function()
		{
			if($(this).is(".disabled"))
			{
				return;
			}
                
			$(this).addClass("call-to-action");
			$sendButton.removeClass("call-to-action");
		});
  

		$dialog.find( "#sendButton" ).click(function() {

			if( $( this ).hasClass( "disabled" ) )
			{
				return false;
			}

			$("#siteIdField").attr("disabled");

			$( "#siteIdField" ).parent().removeClass( "error" );

			// Read user data from site ID dialog
			var siteId = document.getElementById( "siteIdField" ).value;
			var csrfToken = $( "#siteIdDialog" ).find( "input[name='csrfToken']" ).val();

			// Make sure input is not empty
			if( siteId.length == 0 )
			{
				return false;
			}

			// Escape special characters
			var siteIdEncoded = encodeURIComponent( siteId );
			var csrfTokenEncoded = encodeURIComponent( csrfToken );
	
			// Create post data
			var postData = "siteId=" + siteIdEncoded + "&ctkn=" + csrfTokenEncoded;

			// Create and send XMLHttpRequest with site ID using POST method.
			try
			{
				xmlHttpSiteId = new XMLHttpRequest();

				// Register event listener for response
				xmlHttpSiteId.addEventListener( "readystatechange", processSiteIdResponse, false );

				// POST information to server
				xmlHttpSiteId.open( "POST", "cgi-bin/SiteIdHandler.php", true );

				// Set encoding used for the request body (HTML form) and length of contents.
				xmlHttpSiteId.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
				xmlHttpSiteId.setRequestHeader( "Content-length", postData.length );
				xmlHttpSiteId.send( postData );
			}
			catch( exception )
			{
				console.log( "Configure Site Id: Asynchronous XMLHttpRequest failed" );

				updateAndShowProgressIndicator( "error" );
				$( this ).hide();
				$dialog.find( "#closeButton" )
					.find( ".button-content" ).text( "Close" ).end()
					.focus();

				return false;
			}

			updateAndShowProgressIndicator( "current" );

			$( this ).addClass( "disabled" );
			$dialog.find( "#closeButton" ).addClass( "disabled" );

			return false;
		});

		$dialog.find( "#closeButton" ).click(function()
		{
			if( $( this ).is( ".disabled" ) )
			{
				return;
			}

			$dialog.trigger( "close" );
			return false;
		});
	});

	$( "#siteIdDialog" ).bind( "close", function()
	{
		$("#siteIdField").removeAttr("disabled");
		
		// Stop ongoing request, if any.
		if( typeof xmlHttpSiteId !== "undefined" )
		{
			// Remove registered event listener so it doesn't fire on abort().
			xmlHttpSiteId.removeEventListener( "readystatechange", processSiteIdResponse, false );
			xmlHttpSiteId.abort();
		}

		// Note, the dialog window itself is closed by handler in webuiDialogs.js
	});
});


function processSiteIdResponse()
{
	var $dialog = $( "#siteIdDialog" );

	if( (xmlHttpSiteId.readyState == 4) && (xmlHttpSiteId.status == 200) )
	{
		$dialog.find( "#closeButton" ).removeClass( "disabled" );

		// Received response from server. Check the result.
		var siteIdResponse = parseInt( xmlHttpSiteId.responseText );


		//Successful handler
		if( (siteIdResponse !== NaN) && (siteIdResponse > 0) )
		{
			// Configuration succeeded. Display success status.
			updateAndShowProgressIndicator( "success" );
			$dialog.find( "#sendButton" ).hide();
			$dialog.find( "#closeButton" )
				.find( ".button-content" ).text( "Close" ).end()
				.focus();
		}

		//handler of invalid input
		else if( (siteIdResponse !== NaN) && (siteIdResponse === -5) )
		{
			// Invalid user input.
			updateAndShowProgressIndicator( "error", "Invalid input" );
			$( "#siteIdField" ).parent().addClass( "error" );

			$dialog.find( "#sendButton" ).removeClass( "disabled" );

			// Select contents of site ID field
			$( "#siteIdField" ).select();

			// Return focus to site ID field
			$( "#siteIdField" ).focus();
		}

		//handler of everything else
		else
		{
			console.log( "Site Id configuration failed: " + xmlHttpSiteId.responseText );
			updateAndShowProgressIndicator( "error" );

			$dialog.find( "#sendButton" ).hide();
			$dialog.find( "#closeButton" )
				.find( ".button-content" ).text( "Close" ).end()
				.focus();

			//handler of session expiry
			if( (siteIdResponse !== NaN) && (siteIdResponse === -1) )
			{
				// Configuration failed because the user session has expired.
				window.alert( "Session has expired - Please login again" );

				// Open login page with session expired indication.
				location.assign( "login.php?expired" );
				return;
			}
			
			//handler of token expiry
			if( (siteIdResponse !== NaN) && (siteIdResponse === -6) )
			{
				// User session has expired.
				window.alert( "Security token has expired - Please login again" );

				// Open login page with session expired indication.
				location.assign( "login.php?expired" );
				return;
			}
			
			//handler of invalid state
			else if( (siteIdResponse !== NaN) && (siteIdResponse === -4) )
			{
				// Configuration failed because the site has already been commissioned.
				$( "#siteIdErrorDescription" ).show().prev().addClass( "ruled" );
			}
		}
	}

	else if( xmlHttpSiteId.readyState == 4 )
	{
		// Status not OK. An HTTP level failure has occurred.
		console.log( "Site Id configuration failed; HTTP code: " + xmlHttpSiteId.status );

		$dialog.find( "#sendButton" ).hide()
		$dialog.find( "#closeButton" ).removeClass( "disabled" )
			.find( ".button-content" ).text( "Close" ).end()
			.focus();

		updateAndShowProgressIndicator( "error" );
	}
}


function updateAndShowProgressIndicator( stepName, displayText )
{
	// displayText argument is "optional". Expected to be explicitly passed
	// by calling function for info and warning step indicators.
	if( typeof displayText === "undefined" )
	{
		switch( stepName )
		{
			case "current":
				displayText = "Configuring";
				break;

			case "error":
				displayText = "Configuration failed";
				break;

			case "success":
				displayText = "Configuration complete";
				break;

			default:
				// Explicit display text should have been provided.
				console.log( "Unrecognized step: " + stepName );
				return;
		}
	}

	var classList = "step " + stepName;

	$( "#siteIdStatus" )
		.removeClass()
		.addClass( classList )
		.find( ".text" ).text( displayText ).end()
		.show();
}

