// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		DisplayRadioInformation.js
//
// ****************************************************************************

( function( $ )
{

	var REQUEST_TIMER_INTERVAL = 10000;
	var xmlHttp;
	var timerId;

	var createAntlInfo = function(antlInfo)
	{
		var antlInfoWrap;
		if (Array.isArray(antlInfo)) {
			for (antlId in antlInfo)
			{
				if (null === antlInfo[antlId]["AntlId"] || "undefined" === typeof antlInfo[antlId]["AntlId"]) {
					console.log("Malformed antlInfo");
					break;
				}
				if ("undefined" === typeof antlInfoWrap) {
					antlInfoWrap = (E('div', 'span-18').addClass('lead-tab').addClass('grid'));
				}
				else {
					antlInfoWrap.append(E('div', 'span-18').addClass('lead-tab').addClass('grid'));
				}
				antlInfoWrap.append(E('div', 'span-8').html("  Antenna Line Id"));
				antlInfoWrap.append(E('div', 'span-10').html(antlInfo[antlId]["AntlId"]));
				antlInfoWrap.append(E('div', 'span-18').addClass('lead-tab').addClass('grid'));
				antlInfoWrap.append(E('div', 'span-8').html("  Antenna Label"));
				antlInfoWrap.append(E('div', 'span-10').html(antlInfo[antlId]["AntennaLabel"]));
			}
		}
		else {
			antlInfoWrap = E('div', 'span-18').addClass('lead-tab').addClass('grid');  
			antlInfoWrap.append(E('div', 'span-8').attr("float","right").html("Antenna Line Id"));
			antlInfoWrap.append(E('div', 'span-10').html(antlInfo["AntlId"]));
			antlInfoWrap.append(E('div', 'span-18').addClass('lead-tab').addClass('grid'));
			antlInfoWrap.append(E('div', 'span-8').attr("float","right").html("  Antenna Label"));
			antlInfoWrap.append(E('div', 'span-10').html(antlInfo["AntennaLabel"]));
		}
		return antlInfoWrap;
	}

	var createCellInfo = function (cellInfo)
	{
		var cellInfoWrap;
		if (Array.isArray(cellInfo)) {
			for (cellId in cellInfo)
			{
				if (null === cellInfo[cellId]["LncelId"] || "undefined" === typeof cellInfo[cellId]["LncelId"]) {
					console.log("Malformed CellInfo");
					break;
				}
				if ("undefined" === typeof cellInfoWrap) {
					cellInfoWrap = (E('div', 'span-18').addClass('lead-tab').addClass('grid'));
				}
				else {
					cellInfoWrap.append(E('div', 'span-18').addClass('lead-tab').addClass('grid'));
				}
				cellInfoWrap.append(E('div', 'span-8').html("LncelId"));
				cellInfoWrap.append(E('div', 'span-10').html(cellInfo[cellId]["LncelId"]));
			}
		}
		else {
			cellInfoWrap = (E('div', 'span-18').addClass('lead-tab').addClass('grid'));
			cellInfoWrap.append(E('div', 'span-8').html("  LncelId"));
			cellInfoWrap.append(E('div', 'span-10').html(cellInfo["LncelId"]));
		}
		return cellInfoWrap;
	}	

	var createRmodId = function(rmodIdInfo)
	{
		var rmodIdWrap = E('div', 'span-18').addClass('lead-tab').addClass('grid').addClass('vpush-1').addClass('ruled');

		var rmodIdElem = E('h2', 'span-5').html("Rmod Id " + rmodIdInfo).css("font-weight", "bold");
		var rmodIdVal = E('h2', 'span-13').html("").addClass('bold');
		rmodIdWrap.append(rmodIdElem);
		rmodIdWrap.append(rmodIdVal);
		return rmodIdWrap;
	}

	var createRmodGroupName = function(rmodIdGroupNameInfo)
	{
		var rmodGroupNameWrap = E('div', 'span-18').addClass('lead-tab').addClass('grid');
		var rmodGroupNameElem = E('div', 'span-8').html("Group Name");
		var rmodGroupNameVal = E('div', 'span-10').html(rmodIdGroupNameInfo);
		rmodGroupNameWrap.append(rmodGroupNameElem);
		rmodGroupNameWrap.append(rmodGroupNameVal);
		return rmodGroupNameWrap;
	}

	var processRadioInfoObject = function (radioInfoObject)
	{
		var radioInfo = radioInfoObject;
		var radioPanelWrapper = $("#radioWrapper");
		radioPanelWrapper.empty();
		if (typeof radioInfoObject["RmodId"] === "undefined" || radioInfoObject["RmodId"] === null) {
			console.log("Incomplete RadioInfo: missing RmodId");
			return null;
		}
		else {
			radioPanelWrapper = radioPanelWrapper.append(createRmodId(radioInfoObject["RmodId"]));
		}
		if (typeof radioInfoObject["RmodGroupName"] === "undefined" || radioInfoObject["RmodGroupName"] === null) {
			console.log("Incomplete RadioInfo: missing RmodGroupName");
			return null;
		}
		else {
			radioPanelWrapper = radioPanelWrapper.append(createRmodGroupName(radioInfoObject["RmodGroupName"]));
		}
		var antInfoArray;
		var radioObject;
		for (radioObject in radioInfoObject) {
			var generatedHtmlElem;
			switch (radioObject) {
				case "AntlInfo":
					generatedHtmlElem = createAntlInfo(radioInfoObject[radioObject]);
					if (null !== generatedHtmlElem) {
//						radioPanelWrapper.append(E('div', 'span-18').addClass('lead-tab').addClass('grid').append(E('div', 'span-18').html("Antenna Line Information")));
						radioPanelWrapper.append(E('div', 'span-18').addClass('lead-tab').addClass('grid').append(E('div', 'span-18').css("font-weight", "bold").html("Antenna Line Information")));
						radioPanelWrapper.append(generatedHtmlElem);
					}
					else {
						console.log("Null antenna line obj");
					}
					break;
				case "CellInfo":
					generatedHtmlElem = createCellInfo(radioInfoObject[radioObject]);
					if (null !== generatedHtmlElem) {
//						radioPanelWrapper.append(E('div', 'span-18').addClass('lead-tab').addClass('grid')
//						.append(E('h3', 'span-18').html("Associated Cells"))); E('h2', 'span-5').html("Rmod Id " + rmodIdInfo).addClass('bold');
						radioPanelWrapper.append(E('div', 'span-18').addClass('lead-tab').addClass('grid')
						.append(E('div', 'span-18').html("Associated Cells").css("font-weight", "bold"))); 
						radioPanelWrapper.append(generatedHtmlElem);
					}
					else {
						console.log("Null Cell Info obj");
					}
					break;
			}
		}
	}

	var processRadioInfoArray = function (radioInfoArray)
	{
		var radioInfoObj;
		var radioPanelWrapper = $("#radioWrapper");
		radioPanelWrapper.empty();
			for (radioInfoObj in radioInfoArray) {
				var radioInfo = radioInfoArray[radioInfoObj];
				var rmodId = radioInfo["RmodId"];
				var groupName = radioInfo.RmodGroupName;
				var antInfoArray;
				var radioObject;
				if (typeof radioInfo["RmodId"] === "undefined" || radioInfo["RmodId"] === null) {
					console.log("Incomplete RadioInfo: missing RmodId");
					continue;
				}
				else {
					radioPanelWrapper = radioPanelWrapper.append(createRmodId(radioInfo["RmodId"]));
				}
				if (typeof radioInfo["RmodGroupName"] === "undefined" || radioInfo["RmodGroupName"] === null) {
					console.log("Incomplete RadioInfo: missing RmodGroupName");
				}
				else {
					radioPanelWrapper = radioPanelWrapper.append(createRmodGroupName(radioInfo["RmodGroupName"]));
				}


				for (radioObject in radioInfo) {
					var generatedHtmlElem;
					switch (radioObject) {
						case "AntlInfo":
							generatedHtmlElem = createAntlInfo(radioInfo[radioObject]);
							if (null !== generatedHtmlElem) {
								radioPanelWrapper.append(generatedHtmlElem);
							}
							else {
								console.log("Null antenna line obj");
							}
							break;
						case "CellInfo":
							generatedHtmlElem = createCellInfo(radioInfo[radioObject]);
							if (null !== generatedHtmlElem) {
								radioPanelWrapper.append(generatedHtmlElem);
							}
							else {
								console.log("Null Cell Info obj");
							}
							break;
					}
				}
			}	
		
	}	
	
	var createRadioInfo = function (REIRadioInfo)
	{
		var radioInfoObj;
		var radioPanelWrapper = $("#radioWrapper");
		radioPanelWrapper.empty();
		if($.isArray(REIRadioInfo))
		{
			processRadioInfoArray(REIRadioInfo);
		}
		else //non Array
		{
			processRadioInfoObject(REIRadioInfo);
		}
	}	

	var startRequestTimer = function()
	{
		if( $( "#radioInfoPanel" ).is( ":visible" ) )
		{
			timerId = setTimeout( function() {

				// Reset timer ID to undefined
				timerId = void( 0 );

				// Invoke call back function
				sendRadioInfoRequest();

			}, REQUEST_TIMER_INTERVAL );
		}

		// Else, panel has been closed while waiting for response from server; don't
		// start timer.
	}

	var stopRequestTimer = function()
	{
		if( typeof timerId !== "undefined" )
		{
			clearTimeout( timerId );

			// Reset to undefined
			timerId = void( 0 );
		}
	}



	var sendRadioInfoRequest = function()
	{
		// Create and send XMLHttpRequest to server
		try
		{
			xmlHttp = new XMLHttpRequest();
		
			// Register event listener for response
			xmlHttp.addEventListener( "readystatechange", processRadioInfoResponse, false );
		
			// GET information asynchronously from server
			xmlHttp.open( "GET", "cgi-bin/RadioEquipmentInfoHandler.php", true );
			xmlHttp.send();
		}
		catch( exception )
		{
			console.log( "Asynchronous radio information request failed" );

			// Set timer and try again later.
			startRequestTimer();
			return;
		}
	}


	var processRadioInfoResponse = function()
	{
		if( (xmlHttp.readyState == 4) && (xmlHttp.status == 200) )
		{
			// Regardless of success or failure, set timer to send next request
			// after a wait interval.
			startRequestTimer();

			var radioInfoResponse;

			try
			{
				// A valid response should contain a JSON object.
				radioInfoResponse = JSON.parse( xmlHttp.responseText );
			}
			catch( exception )
			{
				// Parsing failure
				console.log( "JSON parsing error in processRadioInfoResponse():\n" + exception );
				console.log( xmlHttp.responseText );
				return;
			}


			if( !("statusInd" in radioInfoResponse) ||
			     (typeof radioInfoResponse.statusInd !== "string") )
			{
				console.log( "Invalid radio info response; missing status indicator" );
				return;
			}

			if( radioInfoResponse.statusInd === "Success" )
			{
				updateRadioInfoPanel( radioInfoResponse.RadioEquipmentInfoData );
			}
			else
			{
				// Failure has occurred. Read failure reason.
				if( !("_failReason" in radioInfoResponse) ||
				     (typeof radioInfoResponse._failReason !== "string") )
				{
					console.log( "Invalid radio info response; missing failure reason" );
					return;
				}

				console.log( "Radio info failure reason: " + radioInfoResponse._failReason );

				if( radioInfoResponse._failReason === "invalidSession" )
				{
					stopRequestTimer();

					// Configuration failed because the user session has expired.
					window.alert( "Session has expired - Please login again" );

					// Open login page with session expired indication.
					location.assign( "login.php?expired" );
					return;
				}
			}
		}

		else if( xmlHttp.readyState == 4 )
		{
			// HTTP level failure has occurred.
			console.log( "Failed to receive radio info response from server" );

			// Try again next interval
			startRequestTimer();
		}
	}
	var updateRadioInfoPanel = function (radioEquipInfoData)
	{
		if( radioEquipInfoData == null )
		{
			return;
		}
		
		var $radioInfoPanel = $("#radioInfoPanel");
		var $radioInfoDescriptiveParms = $(".descparam");
		//Synchronization Source update
		if( !("RadioInfo" in radioEquipInfoData)  ||
		    (typeof radioEquipInfoData.RadioInfo === "undefined") )
		{
			console.log( "Invalid radio info response; missing Radio Info" );
			$radioInfoPanel.find( "#syncSource" ).text("Not available");
		}
		else
		{
			
			for (radioInfoArray in radioEquipInfoData)
		    createRadioInfo(radioEquipInfoData[radioInfoArray]);
		}
		
	}
	
	NSNReady( function()
	{	

		// Request information to display from server.
		sendRadioInfoRequest();

		$( "#displayRadioInfoLink" ).click( function() {
	
			if( $( "#radioInfoPanel" ).is( ":visible" ) )
			{
				return;
			}

			// Hide any open panel(s) in the display area.
			$( ".content-display-panel" ).not( "#radioInfoPanel" ).trigger( "closePanel" );

			// Show the radio info panel in the display area.
			$( "#radioInfoPanel" ).show();

			sendRadioInfoRequest();
		});
	
		$( "#radioInfoPanel" ).bind( "closePanel", function()
		{
			// Stop periodic timer if active.
			stopRequestTimer();

			if( typeof xmlHttp !== "undefined" )
			{
				xmlHttp.removeEventListener( "readystatechange", processRadioInfoResponse, false );
				xmlHttp.abort();
			}

			$( "#radioInfoPanel" ).hide();
		});

		$("#radioInfoPanel").hide();
		$("#radioHiddenWrapper").hide();
	});

})( jQuery )
