// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2016, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		Login.js
//
// ****************************************************************************

( function( $ )
{

	$( "#loginDialog" ).bind( "showLoginDialog", function()
	{
		$( "#loginDialog" ).trigger( "open" );

		// Set focus to user name field once dialog has opened.
		setTimeout( function()
		{
			$( "#username" ).focus();
		}, 100 );
	});


	$( "#loginHistoryDialog" ).bind( "showLoginHistory", function()
	{
		var $dialog = $( "#loginHistoryDialog" );
		populateLoginHistoryInDialog( $dialog );

		$dialog.trigger( "open" );

		// Set focus to close button once dialog has opened.
		setTimeout( function()
		{
			$( "#loginHistoryCloseButton" ).focus();
		}, 100 );

		$( "#loginHistoryCloseButton" ).click( function()
		{
			if( $( this ).is( ".disabled" ) )
			{
				return;
			}

			$dialog.trigger( "close" );
		});

		$dialog.bind( "close", function()
		{
			location.assign( "index.php" );
		});
	});


	var populateLoginHistoryInDialog = function( $dialog )
	{
		var userAccount = $dialog.find( "#userAccount" ).text();

		var $loginHistoryBts = $dialog.find( "#btsLoginHistory" );
		var btsHistoryAvailable = formatLastSuccessfulLoginString( $loginHistoryBts );
		populateFailedAttemptCount( $loginHistoryBts, userAccount );

		var $loginHistoryNetwork = $dialog.find( "#networkLoginHistory" );
		var networkHistoryAvailable = formatLastSuccessfulLoginString( $loginHistoryNetwork );
		populateFailedAttemptCount( $loginHistoryNetwork, userAccount );

		if( networkHistoryAvailable )
		{
			// If network account, show both network login history and local BTS
			// login history (even if not available).
			$dialog.find( "#loginHistoryNotAvailable" ).hide();
		}
		else if( btsHistoryAvailable )
		{
			// Local account or network account but network login history not available
			// (can't distinguish between the two cases).
			$loginHistoryNetwork.hide();
			$dialog.find( "#loginHistoryNotAvailable" ).hide();
		}
		else
		{
			$loginHistoryBts.hide();
			$loginHistoryNetwork.hide();
		}
	}


	var formatLastSuccessfulLoginString = function( $loginHistory )
	{
		var lastSuccessfulLogin = $loginHistory.find( ".last-successful-login" ).text();

		if( lastSuccessfulLogin == "Not available" )
		{
			return false;
		}

		var dateObject = new Date( lastSuccessfulLogin );
		if( isNaN( dateObject.getTime() ) )
		{
			console.log( "Invalid last successful login time" );
			return false;
		}

		var formattedLoginString = dateObject.toLocaleString();
		var timeZoneString = determineLocalTimeOffset();
		formattedLoginString += " (GMT " + timeZoneString + ")";

		$loginHistory.find( ".last-successful-login" ).text( formattedLoginString );
		return true;
	}


	var populateFailedAttemptCount = function( $loginHistory, userAccount )
	{
		var $failedAttemptCountElem = $loginHistory.find( ".failed-attempt-count" );
		var failedAttemptCount = parseInt( $failedAttemptCountElem.find( ".text" ).text() );

		if( (!isNaN( failedAttemptCount )) && (failedAttemptCount > 0) )
		{
			var messageString = "";
			if( $loginHistory.is( "#btsLoginHistory" ) )
			{
				messageString = formatFailedAttemptCountBts( failedAttemptCount, userAccount );
			}
			else
			{
				messageString = formatFailedAttemptCountNetwork( failedAttemptCount, userAccount );
			}

			$failedAttemptCountElem.find( ".text" ).text( messageString );
			$failedAttemptCountElem.show();
		}
		else
		{
			$failedAttemptCountElem.hide();
		}
	}


	var formatFailedAttemptCountBts = function( failedAttemptCount, userAccount )
	{
		var messageString = "";

		if( failedAttemptCount == 1 )
		{
			messageString = "There has been 1 unsuccessful login attempt for ";
			messageString += userAccount;
			messageString += " to this network element since the last successful login.";
		}
		else
		{
			messageString = "There have been ";
			messageString += failedAttemptCount;
			messageString += " unsuccessful login attempts for ";
			messageString += userAccount;
			messageString += " to this network element since the last successful login.";
		}

		return messageString;
	}


	var formatFailedAttemptCountNetwork = function( failedAttemptCount, userAccount )
	{
		var messageString = "";

		if( failedAttemptCount == 1 )
		{
			messageString = "There has been 1 unsuccessful login attempt for ";
			messageString += userAccount;
			messageString += " to any combination of network elements since the last successful login.";
		}
		else
		{
			messageString = "There have been ";
			messageString += failedAttemptCount;
			messageString += " unsuccessful login attempts for ";
			messageString += userAccount;
			messageString += " to any combination of network elements since the last successful login.";
		}

		return messageString;
	}

})( jQuery )
