// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		Menu.js
//
// ****************************************************************************

( function( $ )
{
	var panelXPos = 300;
	var menuIsManuallyOpened = false;

	var hideOrShowMenu = function( $menu )
	{
		// A single content panel should always be open.
		var $openPanel = $( ".content-display-panel:visible" );
		if( !($openPanel.length > 0) )
		{
			// Hmm, curious...
			console.log( "No open content panel" );

			$menu.show();
			return;
		}

		var panelWidth = $openPanel.width();
		var windowWidth = $( window ).width();

		var neededWidth = panelXPos + panelWidth;

		if( windowWidth < neededWidth )
		{
			if( !menuIsManuallyOpened )
			{
				$menu.hide();
				$( "#menuLink" ).show();
				$openPanel.addClass( "left-aligned" );
			}
		}
		else
		{
			$menu.show();
			$( "#menuLink" ).hide();
			$openPanel.removeClass( "left-aligned" );
		}
	}


	NSNReady( function()
	{
		var $menu = $( "#menuPanel" );
		menuIsManuallyOpened = false;

		// Initially hide the show menu link
		$( "#menuLink" ).hide();

		// Wait for page to finish setting up.
		setTimeout( function()
		{
			// Save off position of open content display panel. Should
			// initially be in its regular, non-left aligned position.
			var $openPanel = $( ".content-display-panel:visible" );
			if( $openPanel.length > 0 )
			{
				var panelOffset = $openPanel.offset();
				panelXPos = panelOffset.left;
			}

			// Check if there's enough space to show the menu; hide if necessary.
			hideOrShowMenu( $menu );
		}, 200 );

		$( "#menuLink" ).click( function()
		{
			$menu.show();
			$( this ).hide();
			menuIsManuallyOpened = true;

			var $openPanel = $( ".content-display-panel:visible" );
			$openPanel.removeClass( "left-aligned" );
		});

		$( ".content-panel-link" ).click( function()
		{
			if( $( this ).parent().is( ".disabled" ) )
			{
				return;
			}

			// Delay execution to ensure click handler that opens content panel
			// runs before we check whether to hide or show menu (determination
			// depends on width of the newly opened panel).
			setTimeout( function()
			{
				menuIsManuallyOpened = false;
				hideOrShowMenu( $menu );
			}, 100 );
		});

		$menu.bind( "contentPanelResized", function()
		{
			hideOrShowMenu( $menu );
		});

		$( window ).resize( function()
		{
			menuIsManuallyOpened = false;
			hideOrShowMenu( $menu );
		});

		$( ".content-display-panel" ).click( function()
		{
			menuIsManuallyOpened = false;
			hideOrShowMenu( $menu );
		});
	});

})( jQuery )
