// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2018, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		RFDiagTest.js
//
// ****************************************************************************

(function($)
{
    var REQUEST_TIMER_INTERVAL = 1000;
    var MAX_RFDIAG_DATA = 8192;
    var MAX_CELL_NUM = 3;
    var xmlHttpRfDiag;
    var xmlHttpRfDiagCellInfo;
    var xmlHttpRfDiagData;
    var dataRequestTimerId;
    var cellDataRequestTimerId;
    NSNReady(function()
    {

        $("#rfDiagLink").click(function() {

            if($("#rfDiagPanel").is(":visible"))
            {
                return;
            }

            // Hide any open panel(s) in the display area.
            $(".content-display-panel").not("#rfDiagPanel").trigger("closePanel");

            //set the z-index
            $('.rfdiagpulldown').css('z-index', '8');
            sendRFDiagCellRequest();
            $("#rfDiagPanel").show();
            $("#rfDiagSpinner").hide();

            // Initial state: spinner hidden, ping button enabled.
            $("#rfDiagResult").hide();
            $("#rfDiagPerformButton").removeClass("disabled");

            // Set focus to target IP field and select contents.
            $("#rfDiagOptions").select();
            $("#rfDiagOptions").focus();
            // Clear output area.
            $("#rfDiagOutputArea").val("");
        });

        $("#rfDiagPerformButton").click(function() {

            var $rfDiagPerformButton = $(this);
            if($rfDiagPerformButton.is(".disabled"))
            {
                return;
            }

            $rfDiagPerformButton.addClass("disabled");

            $("#rfDiagOutputArea").val("");
            var $spinner = $("#rfDiagSpinner");
            $spinner.show();
            positionSpinner($spinner);
            sendRFDiagRequest();
            return;
        });

        $("#rfDiagPanel").bind("closePanel", function() {
            // Stop any ongoing request.
            if(typeof xmlHttpRfDiag !== "undefined") {
                xmlHttpRfDiag.removeEventListener("readystatechange", processRFDiagResponse, false);
                xmlHttpRfDiag.abort();
            }
            if(typeof xmlHttpRfDiagData !== "undefined") {
                xmlHttpRfDiagData.removeEventListener("readystatechange", processRFTestDataResponse, false);
                xmlHttpRfDiagData.abort();
            }
            if(typeof xmlHttpRfDiagCellInfo !== "undefined") {
                xmlHttpRfDiagCellInfo.removeEventListener("readystatechange", processRfDiagCellResponse, false);
                xmlHttpRfDiagCellInfo.abort();
            }
            $("#rfDiagSpinner").hide();
            $("#rfDiagPanel").hide();
            stopCellDataRequestTimer();
            stopDataRequestTimer();
        });

        $("#rfDiagPanel").hide();
    });

    //Section for handling cell information
    var sendRFDiagCellRequest = function()
    {
        // Create and send XMLHttpRequest to server
        try
        {
            xmlHttpRfDiagCellInfo = new XMLHttpRequest();

            // Register event listener for response
            xmlHttpRfDiagCellInfo.addEventListener("readystatechange", processRfDiagCellResponse, false);

            // GET information asynchronously from server
            xmlHttpRfDiagCellInfo.open("GET", "cgi-bin/CellInfoHandler.php", true);
            xmlHttpRfDiagCellInfo.send();
        }
        catch(exception)
        {
            console.log("Asynchronous cell information request failed");

            // Set timer and try again later.
            startCellDataRequestTimer();
            return;
        }
    };

    var createNewPulldown = function()
    {
        $(".rfdiagpulldown").remove();
        var $pulldown = E('select').attr("id","rfDiagOptions").attr("type","pulldown").addClass("rfdiagpulldown pulldown");
        $("#rfDiagPulldownContainer").append($pulldown);
    }

    var processRfDiagCellResponse = function()
    {
        if((xmlHttpRfDiagCellInfo.readyState == 4) && (xmlHttpRfDiagCellInfo.status == 200))
        {
            var RFDiagCellResponse;

            try
            {
                // A valid response should contain a JSON object.
                RFDiagCellResponse = JSON.parse(xmlHttpRfDiagCellInfo.responseText);
            }
            catch(exception)
            {
                // Parsing failure
                console.log("JSON parsing error in processRfDiagCellResponse():\n" + exception);
                console.log(xmlHttpRfDiagCellInfo.responseText);
                $("#rfDiagOptions").empty();
                $("#rfDiagOptions").append('<option value = "all">All Cells</option>');
                startCellDataRequestTimer();
                return;
            }


            if(!("statusInd" in RFDiagCellResponse) ||
                (typeof RFDiagCellResponse.statusInd !== "string"))
            {
                console.log("Invalid RfDiag cell info response; missing status indicator");
                $("#rfDiagOptions").empty();
                $("#rfDiagOptions").append('<option value = "all">All Cells</option>');
                startCellDataRequestTimer();
                return;
            }

            if(RFDiagCellResponse.statusInd === "Success")
            {
                stopCellDataRequestTimer();
                createNewPulldown();
                updateDropDownOptions(RFDiagCellResponse);
                $("#rfDiagOptions").pulldown();
            }
            else
            {
                // Failure has occurred. Read failure reason.
                if(!("_failReason" in RFDiagCellResponse) ||
                    (typeof RFDiagCellResponse._failReason !== "string"))
                {
                    console.log("Invalid RfDiag cell info response; missing failure reason");
                    $("#rfDiagOptions").empty();
                    $("#rfDiagOptions").append('<option value = "all">All Cells</option>');
                    startCellDataRequestTimer();
                    return;
                }

                console.log("Cell info failure reason: " + RFDiagCellResponse._failReason);

                if(RFDiagCellResponse._failReason === "invalidSession")
                {
                    stopCellDataRequestTimer();
                    window.alert("Session has expired - Please login again");

                    // Open login page with session expired indication.
                    location.assign("login.php?expired");
                    return;
                }
            }
        }
        else if(xmlHttpRfDiagCellInfo.readyState == 4)
        {
            // HTTP level failure has occurred.
            console.log("Failed to receive RFDiag cell info response from server");
            $("#rfDiagOptions").empty();
            $("#rfDiagOptions").append('<option value = "all">All Cells</option>');
            // Try again next interval
            startCellDataRequestTimer();        }
    };

    var startCellDataRequestTimer = function()
    {
        if($("#rfDiagPanel").is(":visible"))
        {
            cellDataRequestTimerId = setTimeout(function() {

                // Reset timer ID to undefined
                cellDataRequestTimerId = void(0);

                // Invoke call back function
                sendRFDiagCellRequest();

            }, REQUEST_TIMER_INTERVAL);
        }

        // Else, panel has been closed while waiting for response from server; don't
        // start timer.
    };

    var stopCellDataRequestTimer = function()
    {
        if(typeof cellDataRequestTimerId !== "undefined")
        {
            clearTimeout(cellDataRequestTimerId);

            // Reset to undefined
            cellDataRequestTimerId = void(0);
        }
    };

    var updateDropDownOptions = function(CellInfoResponse)
    {
        if(CellInfoResponse === null)
        {
            return;
        }
        var rfDiagPullDownOptions = $("#rfDiagOptions");
        //remove pull down options
        rfDiagPullDownOptions.empty();
        //add all cells option
        rfDiagPullDownOptions.append('<option value = "all">All Cells</option>');

        //check the cell info in the respond should be an array
        if("Cell" in  CellInfoResponse)
        {
            if($.isArray(CellInfoResponse.Cell))
            {
                for(var i = 0;(i < CellInfoResponse.Cell.length) && (i < MAX_CELL_NUM);i++)
                {
                    if(!("_globalCellId" in CellInfoResponse.Cell[i]) ||
                        (typeof CellInfoResponse.Cell[i]._globalCellId !== "string"))
                    {
                        console.log("Invalid cell info in rfdiag test; missing _globalCellId");
                    }
                    else
                    {
                        if(!isNaN(CellInfoResponse.Cell[i]._globalCellId))
                        {
                            var lncelString = (CellInfoResponse.Cell[i]._globalCellId);
                            //build option html
                            var optionString = '<option value = "' + lncelString + '">LNCEL-' + lncelString + '</option>';
                            rfDiagPullDownOptions.append(optionString);
                        }
                    }
                }
            }
            else
            {
                if(!("_globalCellId" in CellInfoResponse.Cell) ||
                    (typeof CellInfoResponse.Cell._globalCellId !== "string"))
                {
                    console.log("Invalid cell info in rfdiag test; missing _globalCellId");
                }
                else
                {
                    if(!isNaN(CellInfoResponse.Cell._globalCellId))
                    {
                        var lncelString = (CellInfoResponse.Cell._globalCellId);
                        //build option html
                        var optionString = '<option value = "' + lncelString + '">LNCEL-' + lncelString + '</option>';
                        rfDiagPullDownOptions.append(optionString);
                    }
                }
            }
        }
        else
        {
            console.log("Invalid cell info in rfdiag test; no cells");
        }

    };

    //Section for initiating test
    var sendRFDiagRequest = function()
    {
        var testTarget;
        // Read user data from target IP field.
        if($("#rfDiagOptions").val() != "")
        {
            testTarget = "targetCellId=" + $("#rfDiagOptions").val();
        }

        var csrfToken = $("#rttPanel").find("input[name='csrfToken']").val();
        // Escape special characters
        var csrfTokenEncoded = encodeURIComponent(csrfToken);

        // Create post data
        var postData = testTarget + "&csrfToken=" + csrfTokenEncoded;

        // Create and send XMLHttpRequest to server
        try
        {
            xmlHttpRfDiag = new XMLHttpRequest();

            // Register event listener for response
            xmlHttpRfDiag.addEventListener("readystatechange", processRFDiagResponse, false);

            // POST information to server
            xmlHttpRfDiag.open("POST", "cgi-bin/RfTestHandler.php", true);

            // Set encoding used for the request body (HTML form) and length of contents.
            xmlHttpRfDiag.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xmlHttpRfDiag.setRequestHeader("Content-length", postData.length);
            xmlHttpRfDiag.send(postData);
        }
        catch(exception)
        {
            console.log("Asynchronous RFDiagTest request failed");
            $("#rfDiagPerformButton").removeClass("disabled");
            $("#rfDiagOutputArea").val("Request failed");
            $("#rfDiagSpinner").hide();
        }
    };

    var processRFDiagResponse = function()
    {
        if((xmlHttpRfDiag.readyState == 4) && (xmlHttpRfDiag.status == 200))
        {
            var rfDiagResponse;

            try
            {
                // A successful response should contain a JSON object.
                rfDiagResponse = JSON.parse(xmlHttpRfDiag.responseText);
            }
            catch(exception)
            {
                // Parsing failure
                console.log("JSON parsing error in processRFDiagResponse():\n" + exception);
                console.log(xmlHttpRfDiag.responseText);
                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagOutputArea").val("Request failed");
                $("#rfDiagSpinner").hide();
                return;
            }

            if(!("statusInd" in rfDiagResponse) ||
                (typeof rfDiagResponse.statusInd !== "string"))
            {
                console.log("Invalid RFDiag response; missing status indicator");
                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagOutputArea").val("Request failed");
                $("#rfDiagSpinner").hide();
                return;
            }

            if(rfDiagResponse.statusInd === "Success")
            {
                sendRfTestDataRequest();
            }
            else
            {
                $("#rfDiagOutputArea").val("Request failed");
                // Failure has occurred. Read failure reason.
                if(!("_failReason" in rfDiagResponse) ||
                    (typeof rfDiagResponse._failReason !== "string"))
                {
                    console.log("Invalid RFDiag response; missing failure reason");
                    $("#rfDiagPerformButton").removeClass("disabled");
                    $("#rfDiagSpinner").hide();
                    return;
                }

                console.log("RFDiag failure reason: " + rfDiagResponse._failReason);

                if(rfDiagResponse._failReason === "invalidSession")
                {
                    // Measurement failed because the user session has expired.
                    window.alert("Session has expired - Please login again");

                    // Open login page with session expired indication.
                    location.assign("login.php?expired");
                    return;
                }

                if(rfDiagResponse._failReason === "invalidSecurityToken")
                {
                    // Security Token has expired.
                    window.alert("Security token has expired - Please login again");

                    // Open login page with session expired indication.
                    location.assign("login.php?expired");
                    return;
                }
                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagOutputArea").val("Request failed");
                $("#rfDiagSpinner").hide();
            }
        }
        else if(xmlHttpRfDiag.readyState == 4)
        {
            // HTTP level failure has occurred.
            console.log("Failed to receive RFDiag response from server");
            $("#rfDiagOutputArea").val("Request failed");
            $("#rfDiagPerformButton").removeClass("disabled");
            $("#rfDiagSpinner").hide();

            // Return focus to target IP field and select contents.
            $("#rfDiagOptions").select();
            $("#rfDiagOptions").focus();
        }
    };

    //Section for gathering test data
    var sendRfTestDataRequest = function()
    {
        // Create and send XMLHttpRequest to server
        try
        {
            xmlHttpRfDiagData = new XMLHttpRequest();

            // Register event listener for response
            xmlHttpRfDiagData.addEventListener("readystatechange", processRFTestDataResponse, false);

            // POST information to server
            //xmlHttpRfDiagData.open("POST", "cgi-bin/RfTestDataRequestHandler.php", true);
            xmlHttpRfDiagData.open( "GET", "cgi-bin/RfTestDataRequestHandler.php", true );
            xmlHttpRfDiagData.send();
        }
        catch(exception)
        {
            console.log("Asynchronous RFDiagTest request failed");
            $("#rfDiagPerformButton").removeClass("disabled");
            $("#rfDiagOutputArea").val("");
            $("#rfDiagSpinner").hide();
            return;
        }
    };

    var processRFTestDataResponse = function()
    {
        if((xmlHttpRfDiagData.readyState == 4) && (xmlHttpRfDiagData.status == 200))
        {
            var rfTestDataResponse;

            try
            {
                // A successful response should contain a JSON object.
                rfTestDataResponse = JSON.parse(xmlHttpRfDiagData.responseText);
            }
            catch(exception)
            {
                // Parsing failure
                console.log("JSON parsing error in processRFTestDataResponse():\n" + exception);
                console.log(xmlHttpRfDiagData.responseText);
                return;
            }

            if(!("statusInd" in rfTestDataResponse) ||
                (typeof rfTestDataResponse.statusInd !== "string"))
            {
                console.log("Invalid RFData response; missing status indicator");
                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagOutputArea").val("Request failed");
                $("#rfDiagSpinner").hide();
                return;
            }

            if(rfTestDataResponse.statusInd === "Success")
            {

                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagSpinner").hide();
                displayRFDiagResults(rfTestDataResponse);
            }
            else if(rfTestDataResponse.statusInd === "InProgress")
            {
                startDataRequestTimer();
            }
            else
            {
                $("#rfDiagOutputArea").val("");

                // Failure has occurred. Read failure reason.
                if(!("_failReason" in rfTestDataResponse) ||
                    (typeof rfTestDataResponse._failReason !== "string"))
                {
                    console.log("Invalid RFData response; missing failure reason");
                    $("#rfDiagOutputArea").val("Request failed");
                    $("#rfDiagSpinner").hide();
                    return;
                }

                console.log("RFData failure reason: " + rfTestDataResponse._failReason);

                if(rfTestDataResponse._failReason === "invalidSession")
                {
                    // Measurement failed because the user session has expired.
                    window.alert("Session has expired - Please login again");

                    // Open login page with session expired indication.
                    location.assign("login.php?expired");
                    return;
                }

                if(rfTestDataResponse._failReason === "invalidSecurityToken")
                {
                    // Security Token has expired.
                    window.alert("Security token has expired - Please login again");

                    // Open login page with session expired indication.
                    location.assign("login.php?expired");
                    return;
                }
                $("#rfDiagPerformButton").removeClass("disabled");
                $("#rfDiagOutputArea").val("Request failed");
                $("#rfDiagSpinner").hide();
            }
        }
        else if(xmlHttpRfDiagData.readyState == 4)
        {
            // HTTP level failure has occurred.
            console.log("Failed to receive RFData response from server");
            $("#rfDiagOutputArea").val("Request failed");
            $("#rfDiagPerformButton").removeClass("disabled");
            $("#rfDiagSpinner").hide();

            // Return focus to target IP field and select contents.
            $("#rfDiagOptions").select();
            $("#rfDiagOptions").focus();
        }
    };

    var startDataRequestTimer = function()
    {
        if($("#rfDiagPanel").is(":visible"))
        {
            dataRequestTimerId = setTimeout(function() {

                // Reset timer ID to undefined
                dataRequestTimerId = void(0);

                // Invoke call back function
                sendRfTestDataRequest();

            }, REQUEST_TIMER_INTERVAL);
        }

        // Else, panel has been closed while waiting for response from server; don't
        // start timer.
    };

    var stopDataRequestTimer = function()
    {
        if(typeof dataRequestTimerId !== "undefined")
        {
            clearTimeout(dataRequestTimerId);

            // Reset to undefined
            dataRequestTimerId = void(0);
        }
    };

    var displayRFDiagResults = function(rfTestDataResponse)
    {
        if(rfTestDataResponse == null)
        {
            return;
        }
        if(!("CLIOutputFile" in rfTestDataResponse) ||
            (typeof rfTestDataResponse.CLIOutputFile !== "string"))
        {
            console.log("partial RFDiag response; missing file name");
            $("#rfDiagOutputArea").val("Request failed");
            $("#downloadRfDiagLink").attr("href", "");
            return;
        }
        if(!("CLIOutput" in rfTestDataResponse) ||
            (typeof rfTestDataResponse.CLIOutput !== "string"))
        {
            console.log("Invalid RFDiag response; missing CLIOutput");
            var url = rfTestDataResponse.CLIOutputFile;
            $("#rfDiagOutputArea").val("Request failed");
            $("#downloadRfDiagLink").attr("href", url);
            $("#rfDiagResult").show();
            return;
        }
        var url = rfTestDataResponse.CLIOutputFile;
        $("#downloadRfDiagLink").attr("href", url);
        // Limit data to avoid excessive output in display area.
        var rfDiagData = rfTestDataResponse.CLIOutput.substr(0, MAX_RFDIAG_DATA);
        $("#rfDiagOutputArea").val(rfDiagData);
        $("#rfDiagResult").show();
    };

    var positionSpinner = function($spinner)
    {
        // Position the spinner in the center of the parent container.
        var topPos = ($spinner.parent().height() - $spinner.outerHeight()) / 2;
        var leftPos = ($spinner.parent().width() - $spinner.outerWidth()) / 2;

        $spinner.css(
            {
                top: topPos + "px",
                left: leftPos + "px"
            });
    };
})(jQuery)
