// ****************************************************************************
// ----------------------------------------------------------------------------
//            Copyright 2018, Nokia Networks
//            All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:        SASPanel.js
//
// ****************************************************************************

(function( $ )
{
    var CBSD_INFO_REQUEST_TIMER_INTERVAL = 3000;
    var xmlCbsdInfoHttp;
    var xmlCbsdUpdateHttp;
    var cbsdTimerId;
    var MAX_CBSDS = 2;
    var MIN_NUM_TABLE_ROWS = 2;
    var cbsdXmlHttp;
    var cbsdArray = [];
    var currentCbsdIndex = 0;

    var startCbsdInfoRequestTimer = function()
    {
        stopCbsdInfoRequestTimer();
        //if( $( "#cbsdTable" ).is( ":visible" ) )
        //{
            cbsdTimerId = setTimeout( function() {

                // Reset timer ID to undefined
                cbsdTimerId = void( 0 );

                // Invoke call back function
                SendCbsdInfoRequest();
            }, CBSD_INFO_REQUEST_TIMER_INTERVAL );
        //}

        // Else, panel has been closed while waiting for response from server; don't
        // start timer.
    }

    var stopCbsdInfoRequestTimer = function()
    {
        if( typeof cbsdTimerId !== "undefined" )
        {
            clearTimeout( cbsdTimerId );
            // Reset to undefined
            cbsdTimerId = void( 0 );
        }
    }

    // CbsdEntry object
    var CbsdEntry = function( CbsdId, associatedCells, cbsdSerialNumber, CbsdCategory, CbsdOperationState, antennaAzimuth, antennaBeamwidth,
            antennaDowntilt, antennaGain, antennaModel, height, heightType, horizontalAccuracy, latitude, longitude, verticalAccuracy )
    {
        this.CbsdId = initializeStringValue( CbsdId );
        this.associatedCells = initializeStringValue( associatedCells );
        this.cbsdSerialNumber = initializeStringValue( cbsdSerialNumber );
        this.CbsdCategory = initializeStringValue( CbsdCategory );
        this.CbsdOperationState = initializeStringValue( CbsdOperationState );
        this.antennaAzimuth = initializeStringValue( antennaAzimuth );
        this.antennaBeamwidth = initializeStringValue( antennaBeamwidth );
        this.antennaDowntilt = initializeStringValue( antennaDowntilt );
        this.antennaGain = initializeStringValue( antennaGain );
        this.antennaModel = initializeStringValue( antennaModel );
        this.height = initializeStringValue( height );
        this.heightType = initializeStringValue( heightType );
        this.horizontalAccuracy = initializeStringValue( horizontalAccuracy );
        this.latitude = initializeStringValue( latitude );
        this.longitude = initializeStringValue( longitude );
        this.verticalAccuracy = initializeStringValue( verticalAccuracy );
    }

    NSNReady( function()
    {
        // Setup cbsd table.
        var $table = $( "#cbsdTable" );
        $table.standard_table( MIN_NUM_TABLE_ROWS, MAX_CBSDS );
        setupTableCells( $table );
        
        $( "#CBSDConfigurationDialog" ).bind("close", function()
        {
            $( "#cbsdDetailsText" ).val("");
            $( "#cbsdExtensionDetailsText" ).val("");

            $( "#CBSDConfigurationDialogDimmer" ).hide();
        });

        $( "#CBSDConfigurationLink" ).click( function() {

            if( $( "#cbsdTable" ).is( ":visible" ) )
            {
                return;
            }

            if( $( this ).parent().is( ".disabled" ) )
            {
                return;
            }
            // Hide any open panel(s) in the display area.
            $( ".content-display-panel" ).not( "#cbsdTable" ).trigger( "closePanel" );

            // Deselect all rows
            $('#cbsdTable tbody tr').removeClass('selected');

            // Show the cbsd panel in the display area.
            $( "#CBSDOverviewPanel" ).show();
            $( "#cbsdDetailsButton" ).addClass( "disabled" );

            //bind cbsd detail button to selectionEvent
            $table.bind("selectionEvent", function()
            {
                var $selected_row = $table.find( "tbody tr.selected" );
                if( $selected_row.length > 0 )
                {
                    var rowIndex = $selected_row.index();
                    if( ( rowIndex >= 0 )  && ( rowIndex < cbsdArray.length ) )
                    {
                        $( "#cbsdDetailsButton" ).removeClass( "disabled" );
                    }
                    else
                    {
                        $( "#cbsdDetailsButton" ).addClass( "disabled" );
                    }
                }
                else
                {
                    $( "#cbsdDetailsButton" ).addClass( "disabled" );
                }
            });

            $table.bind("openEvent", function()
            {
                var $selected_row = $table.find( "tbody tr.selected" );
                if( $selected_row.length > 0 )
                {
                    var rowIndex = $selected_row.index();
                    if( ( rowIndex >= 0 )  && ( rowIndex < cbsdArray.length ) )
                    {
                        updateCbsdDialogValues(rowIndex);
                        displayCbsdDialog();
                    }
                }
            });

            $( "#CBSDConfigurationDialogDimmer" ).hide();

            SendCbsdInfoRequest();
        });

        $( "#cbsdDetailsButton" ).click( function() {
            if( $( this ).is( ".disabled" ) )
            {
                return;
            }
            var rowIndex = $table.find( "tbody tr.selected" ).index();
            if( (rowIndex >= 0 ) && (rowIndex < cbsdArray.length) )
            {
                updateCbsdDialogValues(rowIndex);
                displayCbsdDialog();
            }
        });

        $( "#CBSDEditButton" ).click( function() {
            if( $( this ).is( ".disabled" ) )
            {
                return;
            }

            var $CBSDUpdateDialog = $("#CBSDUpdateDialog");
            if( $CBSDUpdateDialog.is(":visible")){
                // Dialog window already open
                return;
            }
            displayDiaglogBoxCBSDInfo();
            enableCbsdPanelInputs();
            stopCbsdInfoRequestTimer();
            $(".cbsdinput").parent().removeClass("error");
            $(".cbsdinputpulldown").parent().removeClass("error");

            //set the z-index in order to make the drop down for Height Type appear in line with the dialog box
            $('.cbsdinputpulldown').css('z-index', '12');

            //initialize buttons
            var $cancelButton = $("#updateCBSDCancelButton");
            var $updateButton = $("#updateCBSDUpdateButton");
            //hide progress indicator
            $("#CbsdUpdateProgressIndicator").hide();
        
            // initialize confirm button
            $updateButton.find(".button-content" ).text( "Update" );
            $updateButton.removeClass( "disabled" ).removeClass("call-to-action").show();
        
            //initialize cancel button
            $cancelButton.removeClass("disabled");
            $cancelButton.add("call-to-action");
            $cancelButton.find(".button-content" ).text( "Cancel" );
            $( "#CbsdUpdateErrorDescription" ).hide().prev().removeClass( "ruled" );

            // Open CBSD update dialog
            $CBSDUpdateDialog.trigger( "open" );
            // Hide CBSD Configuration Dialog and dimmer
            $( "#CBSDConfigurationDialog" ).hide();
            $( "#CBSDConfigurationDialogDimmer" ).hide();

            // Set focus to cancel button once dialog has opened.
            setTimeout( function() {
                $cancelButton.focus();
            }, 100 );

            // Event listener for confirm button 
            $updateButton.click( function(){
                if( $( this ).is( ".disabled" ) ){
                    return;
                }

                $cancelButton.addClass("disabled");
                $( this ).addClass( "disabled" );
                updateAndShowProgressIndicator( "current" );
                $( "#CbsdUpdateErrorDescription" ).hide().prev().removeClass( "ruled" );
                sendCBSDUpdateRequest();        
                startCbsdInfoRequestTimer();
            });

            // Event listener for cancel button 
            $cancelButton.click(function(){
                if( $( this ).is(".disabled") ){
                    return;
                }

                // Close the dialog window.
                startCbsdInfoRequestTimer();
                $CBSDUpdateDialog.trigger("close");
            });

            $("#CBSDUpdateDialog").bind( "close", function(){
                // Stop any ongoing request.
                // Note, the dialog window itself is closed by handler in webuiDialogs.js
                if( typeof xmlHttpConfigRequest !== "undefined" ){
                    xmlHttpConfigRequest.removeEventListener( "readystatechange", processCbsdUpdateResponse, false );
                    xmlHttpConfigRequest.abort();
                }
                startCbsdInfoRequestTimer();
            });
        });


        $( "#CBSDOverviewPanel" ).bind( "closePanel", function()
        {
            if( typeof cbsdXmlHttp !== "undefined" )
            {
                cbsdXmlHttp.removeEventListener( "readystatechange", processCbsdInfoResponse, false );
                cbsdXmlHttp.abort();
            }

            $( "#CBSDOverviewPanel" ).hide();
        });

        $( "#CBSDConfigurationDialog" ).bind( "closePanel", function()
        {
            $( "#CBSDConfigurationDialog" ).hide();
        });

        $( "#CBSDConfigurationDialog" ).bind( "closePanel", function(){
            if( typeof xmlCbsdInfoHttp !== "undefined" ){
                xmlCbsdInfoHttp.removeEventListener( "readystatechange", processCbsdInfoResponse, false );
                xmlCbsdInfoHttp.abort();
            }

            $( "#CBSDConfigurationDialog" ).hide();
            stopCbsdInfoRequestTimer();
        });

        // CBSD panel is hidden until opened by user.
        $( "#CBSDOverviewPanel" ).hide();
        $( "#CBSDConfigurationDialogDimmer" ).hide();
        $( "#CBSDConfigurationDialog" ).hide();
    });


    var enableCbsdPanelInputs = function(){
        stopCbsdInfoRequestTimer();         
        $(".cbsdinput").removeAttr("readonly").parent().removeClass("disabled");
        $(".cbsdinputpulldown").removeAttr("disabled");
        $("#updateCBSDUpdateButton")
        .find(".button-content" )
        .text( "Update" );
        $("#updateCBSDCancelButton").removeClass("disabled");
        $("#updateCBSDUpdateButton").removeClass("disabled");
    }

    var disableCbsdPanelInputs = function(){
        //disable input fields
        $(".cbsdinput").attr("readonly","true").parent().addClass("disabled");
        $(".cbsdinputpulldown").attr("disabled","true");
        $("#CBSDEditButton")
        .find(".button-content" )
        .text( "Edit" );
        SendCbsdInfoRequest();
        $(".cbsdinput").parent().removeClass("error");
    }

    var SendCbsdInfoRequest = function()
    {
        var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();
        var csrfTokenEncoded = encodeURIComponent(csrfToken);
        try
        {
            cbsdXmlHttp = new XMLHttpRequest();
            cbsdXmlHttp.addEventListener( "readystatechange", processCbsdInfoResponse, false );
            cbsdXmlHttp.open( "GET", "cgi-bin/CbsdInfoHandler.php", true );
            cbsdXmlHttp.send();
        }
        catch( exception ) {
            console.log( "Asynchronous get Cbsd info request failed" );
        }
        startCbsdInfoRequestTimer();
    }

    var populateCbsdPost = function(){
        var postline = "";
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxlongitude").val() != "")
            {postline += "longitude=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxlongitude").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxlatitude").val() != "")
            {postline += "latitude=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxlatitude").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxantennaAzimuth").val() != "")
            {postline += "antennaAzimuth=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxantennaAzimuth").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxantennaBeamwidth").val() != "")
            {postline += "antennaBeamwidth=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxantennaBeamwidth").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxantennaDowntilt").val() != "")        
            {postline += "antennaDowntilt=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxantennaDowntilt").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxheight").val() != "") 
            {postline += "height=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxheight").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxheightType").val() != "2")
            {postline += "heightType=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxheightType").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxhorizontalAccuracy").val() != "")
            {postline += "horizontalAccuracy=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxhorizontalAccuracy").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxverticalAccuracy").val() != "")
            {postline += "verticalAccuracy=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxverticalAccuracy").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxantennaGain").val() != "")
            {postline += "antennaGain=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxantennaGain").val() + "&";}
        if($( "#CBSDUpdateDialog" ).find("#dialogBoxantennaModel").val() != "")
            {postline += "antennaModel=" + $( "#CBSDUpdateDialog" ).find("#dialogBoxantennaModel").val() + "&";}
        postline += "_cbsdId=" + $( "#CBSDConfigurationDialog" ).find("#cbsdId").text();
        console.log(postline);
        return postline;
    }

    var updateAndShowProgressIndicator = function( stepName, displayText ){
        // displayText argument is "optional". Expected to be explicitly passed
        // by calling function for info and warning step indicators.
        if( typeof displayText === "undefined" ){
            switch( stepName ){
            case "current":
                displayText = "Performing update";
                break;

            case "error":
                displayText = "Operation failed";
                break;

            case "success":
                displayText = "Update initialized";
                break;

            case "warning":
                break;

            default:
                // Explicit display text should have been provided.
                console.log( "Unrecognized step: " + stepName );
                return;
            }
        }
        var classList = "step " + stepName;

        $( "#CbsdUpdateProgressIndicator" )
        .removeClass()
        .addClass( classList )
        .find( ".text" ).text( displayText ).end()
        .show();
    }

    var sendCBSDUpdateRequest = function(){
        var csrfToken = $( "#rttPanel" ).find( "input[name='csrfToken']" ).val();

        var csrfTokenEncoded = encodeURIComponent( csrfToken );
        var poptest = populateCbsdPost();
        // Create post data
        postData = populateCbsdPost() + "&csrfToken=" + csrfTokenEncoded;
        // Create and send XMLHttpRequest to server
        updateAndShowProgressIndicator( "current" );    
        try{
            xmlCbsdUpdateHttp = new XMLHttpRequest();

            // Register event listener for response
            xmlCbsdUpdateHttp.addEventListener( "readystatechange", processCbsdUpdateResponse, false );

            // POST information to server
            xmlCbsdUpdateHttp.open( "POST", "cgi-bin/CbsdUpdateHandler.php", true );
            // Set encoding used for the request body (HTML form) and length of contents.
            xmlCbsdUpdateHttp.setRequestHeader( "Content-Type", "application/x-www-form-urlencoded" );
            xmlCbsdUpdateHttp.setRequestHeader( "Content-length", postData.length );
            xmlCbsdUpdateHttp.send( postData );
        }
        catch(exception){
            console.log( "Asynchronous CBSD request failed" );
            updateAndShowProgressIndicator("error");
            updateButtonsOnFailure();           
            return;
        }
    }

    var processCbsdUpdateResponse = function(){
        if( (xmlCbsdUpdateHttp.readyState == 4) && (xmlCbsdUpdateHttp.status == 200) ){
            try{    
                var CbsdUpdateResponse = JSON.parse(xmlCbsdUpdateHttp.responseText);
            }
            catch(exception){
                console.log( "JSON parsing error in processConfigResetRequestResponse():\n" + exception );
                console.log( xmlCbsdUpdateHttp.responseText );
                updateAndShowProgressIndicator( "error" );
                updateButtonsOnFailure();
                return;
            }

            if(!("statusInd" in CbsdUpdateResponse)){
                console.log( "Invalid cbsd update response; missing status indicator" );
                updateAndShowProgressIndicator( "error" );
                updateButtonsOnFailure();
                return;
            }
            if(CbsdUpdateResponse.statusInd === "Success"){
                // Update progress indication.
                updateAndShowProgressIndicator( "success" );
                updateButtonsOnSuccess();
            }
            else{
                // Failure has occurred. Read failure reason.
                if( !("_failReason" in CbsdUpdateResponse) ||
                    (typeof CbsdUpdateResponse._failReason !== "string") ){
                    console.log( "Invalid CBSD response; missing failure reason" );
                    return;
                }

                console.log( "CBSD update failure reason: " + CbsdUpdateResponse._failReason );

                if( CbsdUpdateResponse._failReason === "invalidSession" ){
                    // Measurement failed because the user session has expired.
                    window.alert( "Session has expired - Please login again" );

                    // Open login page with session expired indication.
                    location.assign( "login.php?expired" );
                    return;
                }

                if( CbsdUpdateResponse._failReason === "invalidSecurityToken"){
                    // Measurement failed because the security token has expired.
                    updateAndShowProgressIndicator( "warning", "Security Token expired" );

                    // Security Token has expired.
                    window.alert( "Security token has expired - Please login again" );

                    // Open login page with session expired indication.
                    location.assign( "login.php?expired" );
                    return;
                }
                if("additionalInfo" in CbsdUpdateResponse){
                    for(x in CbsdUpdateResponse.additionalInfo){
                        if(CbsdUpdateResponse.additionalInfo[x] == "valid")
                        {
                            $("#dialogBox" + x).parent().removeClass("error");
                        }
                        else
                        {
                            $("#dialogBox" + x).parent().addClass("error").focus();
                            $("#dialogBox" + x).select();
                        }
                    }
                    updateAndShowProgressIndicator("error","Invalid parameters");
                }
                else{
                    updateAndShowProgressIndicator("error");
                }
                updateButtonsOnFailure(); 
            }
        }
        else if( xmlCbsdUpdateHttp.readyState == 4 ){
            // HTTP level failure has occurred.
            console.log( "Failed to receive config reset change response from server" );

            // Update progress indication.
            updateAndShowProgressIndicator( "error" );
            updateButtonsOnFailure();
        }
    }

    var processCbsdInfoResponse = function()
    {
	    if( (cbsdXmlHttp.readyState == 4) && (cbsdXmlHttp.status == 200) ){
		    var cbsdInfoResponse;

		    try{
	            // A successful response should contain a JSON object.
			    cbsdInfoResponse = JSON.parse( cbsdXmlHttp.responseText );
		    }
		    catch( exception ){
		        // Parsing failure
			    console.log( "JSON parsing error in processCbsdInfoResponse():\n" + exception );
			    console.log( cbsdXmlHttp.responseText );
			    return;
		    }

		    if( !("statusInd" in cbsdInfoResponse) ||
			    (typeof cbsdInfoResponse.statusInd !== "string") ){
			    console.log( "Invalid CBSD response; missing status indicator" );
			    return;
		    }

		    if( cbsdInfoResponse.statusInd === "Success" ){
			    //displayCBSDInfo( cbsdInfoResponse );
			    updateCbsdTableValues( cbsdInfoResponse );
		    }
		    else{
			    // Failure has occurred. Read failure reason.
			    if( !("_failReason" in cbsdInfoResponse) ||
				    (typeof cbsdInfoResponse._failReason !== "string") ){
				    console.log( "Invalid CBSD response; missing failure reason" );
				    return;
			    }

			    console.log( "CBSD failure reason: " + cbsdInfoResponse._failReason );

			    if( cbsdInfoResponse._failReason === "invalidSession" ){
				    // Measurement failed because the user session has expired.
				    window.alert( "Session has expired - Please login again" );

				    // Open login page with session expired indication.
				    location.assign( "login.php?expired" );
				    return;
			    }

			    if( cbsdInfoResponse._failReason === "invalidSecurityToken"){
                    // Measurement failed because the security token has expired.
                    updateAndShowProgressIndicator( "warning", "Security Token expired" );

				    // Security Token has expired.
				    window.alert( "Security token has expired - Please login again" );

				    // Open login page with session expired indication.
				    location.assign( "login.php?expired" );
				    return;
                }
			}
		}

    	else if( cbsdXmlHttp.readyState == 4 ){
	        // HTTP level failure has occurred.
		    console.log( "Failed to receive CBSD response from server" );
        }
    }

    var updateCbsdDialogValues = function( index )
    {
        currentCbsdIndex = index;

        var accountRole = $( "#menuPanel" ).find( "input[name='accountRole']" ).val();
        var accessRight = $( "#menuPanel" ).find( "input[name='accessRight']" ).val();
        if ((accountRole === "secAdmin") || (accountRole === "readOnlyUser") || (accessRight === "read-only")) {
            $("#CBSDEditButton").addClass("disabled");
        }

        if(cbsdArray[index].CbsdId !== null)
            $("#cbsdId").text(cbsdArray[index].CbsdId);
        else
            $("#cbsdId").text("");

        if(cbsdArray[index].associatedCells !== null)
            $("#associatedCells").text(cbsdArray[index].associatedCells);
        else
            $("#associatedCells").text("");

        if(cbsdArray[index].cbsdSerialNumber !== null)
            $("#cbsdSerialNumber").text(cbsdArray[index].cbsdSerialNumber);
        else
            $("#cbsdSerialNumber").text("");

        if(cbsdArray[index].CbsdCategory !== null)
            $("#cbsdCategory").text(cbsdArray[index].CbsdCategory);
        else
            $("#cbsdCategory").text("");

        if(cbsdArray[index].CbsdOperationState !== null)
            $("#cbsdOperationState").text(cbsdArray[index].CbsdOperationState);
        else
            $("#cbsdOperationState").text("");

        if(cbsdArray[index].antennaAzimuth !== null)
            $("#antennaAzimuth").text(cbsdArray[index].antennaAzimuth);
        else
            $("#antennaAzimuth").text("");

        if(cbsdArray[index].antennaBeamwidth !== null)
            $("#antennaBeamwidth").text(cbsdArray[index].antennaBeamwidth);
        else
            $("#antennaBeamwidht").text("");

        if(cbsdArray[index].antennaDowntilt !== null)
            $("#antennaDowntilt").text(cbsdArray[index].antennaDowntilt);
        else
            $("#antennaDowntilt").text("");

        if(cbsdArray[index].antennaGain !== null)
            $("#antennaGain").text(cbsdArray[index].antennaGain);
        else
            $("#antennaGain").text("");

        if(cbsdArray[index].antennaModel !== null)
            $("#antennaModel").text(cbsdArray[index].antennaModel);
        else
            $("#antennaModel").text("");

        if(cbsdArray[index].height !== null)
            $("#height").text(cbsdArray[index].height);
        else
            $("#height").text("");

        if(cbsdArray[index].heightType !== null){
            if(cbsdArray[index].heightType === "0")
                $("#heightType").text("Above Ground Level (AGL)");    
            else if(cbsdArray[index].heightType === "1")
                $("#heightType").text("Above Mean Sea Level (AMSL)");  
            else if(cbsdArray[index].heightType === "2")
                $("#heightType").text("No Selection");
            else
                $("#heightType").text("");
        }
        else
            $("#heightType").text("");

        if(cbsdArray[index].latitude !== null)
            $("#latitude").text(cbsdArray[index].latitude);
        else
            $("#latitude").text("");

        if(cbsdArray[index].longitude !== null)
            $("#longitude").text(cbsdArray[index].longitude);
        else
            $("#longitude").text("");

        if(cbsdArray[index].horizontalAccuracy !== null)
            $("#horizontalAccuracy").text(cbsdArray[index].horizontalAccuracy);
        else
            $("#horizontalAccuracy").text("");

        if(cbsdArray[index].verticalAccuracy !== null)
            $("#verticalAccuracy").text(cbsdArray[index].verticalAccuracy);
        else
            $("#verticalAccuracy").text("");

    }

    var displayCbsdDialog = function(){
        if( $( "#CBSDConfigurationDialog" ).is( ":visible" ) )
        {
            return;
        }
        $( "#CBSDConfigurationDialog" ).trigger("open");
        $( "#CBSDConfigurationDialog" ).show();
        $( "#CBSDConfigurationDialogDimmer" ).show();
    }

    var updateButtonsOnSuccess = function(){

        disableCbsdPanelInputs();
        var $cancelButton = $("#updateCBSDCancelButton");
        $cancelButton.removeClass( "disabled" );
        $cancelButton.find( ".button-content" ).text( "Close" );
        $cancelButton.addClass( "call-to-action" );
        $cancelButton.focus();
    }

    var updateButtonsOnFailure = function(){
        enableCbsdPanelInputs();
    }

    var displayDiaglogBoxCBSDInfo = function( )
    {
        $("#dialogBoxcbsdId").val($( "#CBSDConfigurationDialog" ).find("#cbsdId").text());
        $("#dialogBoxlongitude").val($( "#CBSDConfigurationDialog" ).find("#longitude").text());
        $("#dialogBoxlatitude").val($( "#CBSDConfigurationDialog" ).find("#latitude").text());
        $("#dialogBoxantennaAzimuth").val($( "#CBSDConfigurationDialog" ).find("#antennaAzimuth").text());
        $("#dialogBoxantennaBeamwidth").val($( "#CBSDConfigurationDialog" ).find("#antennaBeamwidth").text());
        $("#dialogBoxantennaDowntilt").val($( "#CBSDConfigurationDialog" ).find("#antennaDowntilt").text());
        $("#dialogBoxheight").val($( "#CBSDConfigurationDialog" ).find("#height").text());
        if($( "#CBSDConfigurationDialog" ).find("#heightType").text() == "Above Ground Level (AGL)")
        {
            $("#dialogBoxheightType").selectedIndex = "0";
            $("#dialogBoxheightType").val("0").change();   
        }
        else if($( "#CBSDConfigurationDialog" ).find("#heightType").text() == "Above Mean Sea Level (AMSL)")
        {
            $("#dialogBoxheightType").selectedIndex = "1";
            $("#dialogBoxheightType").val("1").change(); 
        }
        else if($( "#CBSDConfigurationDialog" ).find("#heightType").text() == "No Selection")
        {
            $("#dialogBoxheightType").selectedIndex = "2";
            $("#dialogBoxheightType").val("2").change(); 
        }
        $("#dialogBoxhorizontalAccuracy").val($( "#CBSDConfigurationDialog" ).find("#horizontalAccuracy").text());
        $("#dialogBoxverticalAccuracy").val($( "#CBSDConfigurationDialog" ).find("#verticalAccuracy").text());
        $("#dialogBoxantennaGain").val($( "#CBSDConfigurationDialog" ).find("#antennaGain").text())
		if($("#dialogBoxantennaGain").val() == "")
		{
			$("#dialogBoxantennaGain").parent().find('span.required').show();
		}
		else
		{
			$("#dialogBoxantennaGain").parent().find('span.required').hide();
		}
        $("#dialogBoxantennaModel").val($( "#CBSDConfigurationDialog" ).find("#antennaModel").text())
    }

    var updateCbsdTableValues = function( cbsdInfoResponse )
    {
        var tmpCbsdModEntry;

        if( cbsdInfoResponse == null )
        {
            console.log("cbsdInfoResponse null");
            return;
        }

        // Clear out existing cbsd array.
        while( cbsdArray.length > 0 )
        {
            cbsdArray.pop();
        }

        if( "Cbsd" in cbsdInfoResponse )
        {
            if( Array.isArray( cbsdInfoResponse.Cbsd ) )
            {
                for( var i = 0; (i < cbsdInfoResponse.Cbsd.length && i < MAX_CBSDS); i++ )
                {
                    var tmpCbsdEntry = new CbsdEntry(
                        cbsdInfoResponse.Cbsd[i]._cbsdId,
                        cbsdInfoResponse.Cbsd[i].associatedCells,
                        cbsdInfoResponse.Cbsd[i].cbsdSerialNumber,
                        cbsdInfoResponse.Cbsd[i]._cbsdCategory,
                        cbsdInfoResponse.Cbsd[i]._cbsdOperationState,
                        cbsdInfoResponse.Cbsd[i].antennaAzimuth,
                        cbsdInfoResponse.Cbsd[i].antennaBeamwidth,
                        cbsdInfoResponse.Cbsd[i].antennaDowntilt,
                        cbsdInfoResponse.Cbsd[i].antennaGain,
                        cbsdInfoResponse.Cbsd[i].antennaModel,
                        cbsdInfoResponse.Cbsd[i].height,
                        cbsdInfoResponse.Cbsd[i].heightType,
                        cbsdInfoResponse.Cbsd[i].horizontalAccuracy,
                        cbsdInfoResponse.Cbsd[i].latitude,
                        cbsdInfoResponse.Cbsd[i].longitude,
                        cbsdInfoResponse.Cbsd[i].verticalAccuracy);
                    cbsdArray.push( tmpCbsdEntry );
                }
            }

            else
            {
                var tmpCbsdEntry = new CbsdEntry(
                    cbsdInfoResponse.Cbsd._cbsdId,
                    cbsdInfoResponse.Cbsd.associatedCells,
                    cbsdInfoResponse.Cbsd.cbsdSerialNumber,
                    cbsdInfoResponse.Cbsd._cbsdCategory,
                    cbsdInfoResponse.Cbsd._cbsdOperationState,
                    cbsdInfoResponse.Cbsd.antennaAzimuth,
                    cbsdInfoResponse.Cbsd.antennaBeamwidth,
                    cbsdInfoResponse.Cbsd.antennaDowntilt,
                    cbsdInfoResponse.Cbsd.antennaGain,
                    cbsdInfoResponse.Cbsd.antennaModel,
                    cbsdInfoResponse.Cbsd.height,
                    cbsdInfoResponse.Cbsd.heightType,
                    cbsdInfoResponse.Cbsd.horizontalAccuracy,
                    cbsdInfoResponse.Cbsd.latitude,
                    cbsdInfoResponse.Cbsd.longitude,
                    cbsdInfoResponse.Cbsd.verticalAccuracy);

                cbsdArray.push( tmpCbsdEntry );
            }
        }

        // Display cbsds in table; note: empty table displayed if no cbsd
        if( $( "#cbsdTable" ).is( ":visible" ) )
            displayCbsdTable();
        if( $( "#CBSDConfigurationDialog" ).is( ":visible" ) )
            updateCbsdDialogValues(currentCbsdIndex);
    }

    var displayCbsdTable = function()
    {
        $table = $( "#cbsdTable" );

        var rowsInTable = $table.find( "tbody > tr" ).length;

        // Clear out display table
        for( var i = 1; i <= rowsInTable; i++ )
        {
            var $row = $table.find( "tbody > tr:nth-of-type(" + i + ")" );
            clearCbsdRow( $row );
        }

        for( var i = 0; (i < cbsdArray.length && i < rowsInTable); i++ )
        {
            var $row = $table.find( "tbody > tr:nth-of-type(" + (i+1) + ")" );
            populateCbsdRow( $row, cbsdArray[i] );
        }

        $( "#menuPanel" ).trigger( "contentPanelResized" );
    }

    var setupTableCells = function( $table )
    {
        var rowsInTable = $table.find( "tbody > tr" ).length;
        for( var i = 1; i <= rowsInTable; i++ )
        {
            var $row = $table.find( "tbody > tr:nth-of-type(" + i + ")" );
            $row.find( "td:first-child" ).addClass( "cbsd-id cell-value" )
                .next().addClass( "cbsd-associated-cells cell-value" )
                .next().addClass( "cbsd-serial-number cell-value" )
                .next().addClass( "cbsd-category cell-value" )
				.next().find( ".cell-value").addClass( "cbsd-operation-state" );
        }
    }

    var clearCbsdRow = function( $row )
    {
        $row.find( ".cell-value" ).text( "" );
    }

    var populateCbsdRow = function( $row, CbsdEntry )
    {
        var tmpStr;
        $row.find( ".cbsd-id" ).text( CbsdEntry.CbsdId );
        $row.find( ".cbsd-associated-cells" ).text( CbsdEntry.associatedCells );
        if (CbsdEntry.cbsdSerialNumber.length > 30)
        {
            tmpStr = CbsdEntry.cbsdSerialNumber.substring(0, 30);
            tmpStr += "...";
        }
        else
        {
            tmpStr = CbsdEntry.cbsdSerialNumber;
        }
        $row.find( ".cbsd-serial-number" ).text( tmpStr );
        $row.find( ".cbsd-category" ).text( CbsdEntry.CbsdCategory );
        $row.find( ".cbsd-operation-state" ).text( CbsdEntry.CbsdOperationState );
    }

})( jQuery )
