// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		StandardTable.js
//
// ****************************************************************************

( function( $ )
{

	var DEFAULT_MIN_NUM_ROWS = 10;
	var DEFAULT_MAX_NUM_ROWS = 200;


	$.fn.standard_table = function( argMinNumRows, argMaxNumRows )
	{
		var minNumRows = argMinNumRows || DEFAULT_MIN_NUM_ROWS;
		var maxNumRows = argMaxNumRows || DEFAULT_MAX_NUM_ROWS;

		return this.each( function()
		{
			initializeTable( $( this ), minNumRows, maxNumRows );
		});
	}


	var initializeTable = function( $table, minNumRows, maxNumRows )
	{
		$table.find( "tbody:first-child, tr:first-child, th:first-child, td:first-child" )
				.addClass( "first-child" ).end()
			.find( "tbody:last-child, tr:last-child, th:last-child, td:last-child" )
				.addClass( "last-child" ).end()
			.find( "tbody tr:nth-child( even )" )
				.addClass( "alt" ).end()
			.find( "thead th:last-child" )
				.wrapInner( E( "div", "cell" ) )
				.find( ".cell")
					.append( E( "div", "inner" ) );

		$table.find( "tbody td:last-child" )

                                .append( E( "div", "cell" ) )
                                .find(".cell").append( E( "div", "inner" ) )
                                .append( E("div", "cell-value") );



		// Set up selection for the initial set of rows.
		var $rows = $table.find( "tbody > tr" );
		setup_selection( $table, $rows );

		var rowsInTable = $rows.length;

		// Make sure the table has at least the minimum number of rows
		if( rowsInTable < minNumRows )
		{
			var rowsToAdd = minNumRows - rowsInTable;
			$table.add_rows_to_table( rowsToAdd, maxNumRows );
			rowsInTable = $table.find( "tbody > tr" ).length;
		}

		// Also make sure the table doesn't have more than the maximum number of rows...
		if( rowsInTable > maxNumRows )
		{
			var rowsToRemove = rowsInTable - maxNumRows;
			$table.remove_rows_from_table( rowsToRemove, minNumRows );
		}

		add_sort_indicator( $table );
	}


	var setup_selection = function( $table, $rows )
	{
		var $selection_unit = null;

		if( $table.is ( ".cell-selection" ) )
		{
			$selection_unit = $rows.find( "td" );
		}
		else if( $table.is( ".row-selection" ) )
		{
			$selection_unit = $rows;
		}

		if( $selection_unit )
		{
			$selection_unit.click( function( event )
			{
				$table.find( "tbody .selected" ).not( this ).removeClass( "selected" );
				$( this ).toggleClass( "selected" );
				$table.trigger( "selectionEvent" );
			});
                        $selection_unit.dblclick( function( event ){
                                $table.find( "tbody .selected" ).not( this ).removeClass( "selected" );
                                $( this ).addClass( "selected" );
                                $table.trigger( "selectionEvent" );
				$table.trigger( "openEvent" );
                        });
		}
	}


	var add_sort_indicator = function( $table )
	{
		$table.find( "thead th.sortable" ).each( function()
		{
			var $elm = $( this );

			$elm.click( function( e )
			{
				e.stopPropagation();

				if( !$elm.is( ".selected" ) )
				{
					$table.find( "thead th.selected" ).removeClass( "selected" );
					$elm.addClass( "selected" );
				}
				else
				{
					$elm.toggleClass( "up" );
				}

				$elm.trigger( "sortNeeded" );
			});

			if( $elm.hasClass( "last-child" ) )
			{
				$elm.find( ".cell" ).appendlist( [ T( " " ), E( "span", "arrow" ) ] );
			}
			else
			{
				$elm.appendlist( [ T( " " ), E( "span", "arrow" ) ] );
			}
		});
	}


	$.fn.remove_rows_from_table = function( numRows, minNumRows )
	{
		var rowsInTable = $table.find( "tbody > tr" ).length;

		for( var i = 0; ((i < numRows) && (rowsInTable > minNumRows)); i++ )
		{
			this.find( "tbody > tr:last-child" ).remove();
			this.find( "tbody > tr:last-child" ).addClass( "last-child" );
			rowsInTable--;
		}
	}

	$.fn.add_rows_to_table = function( numRows, maxNumRows )
	{
		this.find( "tbody > tr:last-child" ).removeClass( "last-child" );

		var rowsInTable = this.find( "tbody > tr" ).length;
		var columnsInTable = this.find( "thead > tr:first-child > th" ).length;

		for( var i = 0; ((i < numRows) && (rowsInTable < maxNumRows)); i++ )
		{
			// Add row and first cell. Assumes at least one column in table...
			this.append( "<tr><td></td></tr>" );

			var $newRow = this.find( "tbody > tr:last-child" );

			// Add cells to fill up the row.
			for( var cell = 1; cell < columnsInTable; cell++ )
			{
				$newRow.append( "<td></td>" );
			}

			// Setup the new cells
			$newRow.find( "td:first-child" ).addClass( "first-child" );
			$newRow.find( "td:last-child" ).addClass( "last-child" )
				.append( E( "div", "cell" ) )
				.find(".cell").append( E( "div", "inner" ) )
				.append( E("div", "cell-value") );

			setup_selection( this, $newRow );
			rowsInTable++;
		}

		this.find( "tbody > tr:last-child" ).addClass( "last-child" );
		this.find( "tbody > tr:nth-child(even)" ).addClass( "alt" );
	}

})( jQuery )
