// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		WebuiUtilities.js
//
// ****************************************************************************

function initializeStringValue( arg )
{
	if( typeof arg === "string" )
	{
		return arg;
	}
	else
	{
		console.log( "Not string type" );
		return " ";
	}
}

function zeroPad( value, requiredLength )
{
	var outputString = "" + value;
	while( outputString.length < requiredLength )
	{
		outputString = "0" + outputString;
	}

	return outputString;
}

function determineLocalTimeOffset()
{
	// Date.getTimezoneOffset() method provides offset in minutes, with
	// sign reversed; e.g., GMT -06:00 (CST) comes out as +360 (minutes).
	// Convert to +/-hh:mm format; e.g., +09:00.

	var offset = new Date().getTimezoneOffset();

	// Reverse sign.
	var offsetString = (offset <= 0) ? "+" : "-";

	// Parse hours
	offsetString += zeroPad( parseInt( Math.abs( offset / 60 ) ), 2 );
	offsetString += ":";

	// Parse minutes
	offsetString += zeroPad( Math.abs( offset % 60 ), 2 );

	return offsetString;
}

