// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:		webuiDialogs.js
//
// ****************************************************************************

/**
 * Page-centered dialogs.
 */
(function ($)
{
    var $window = $(window)
    var dimmerCounter = 1;

    var position_dimmer = function( $dimmer )
    {
        if ($dimmer.is(':hidden'))
        {
            return
        }
        
        $dimmer.css({
            top: $window.scrollTop(),
            left: $window.scrollLeft()
        })
    }

    $window.scroll( function()
    {
        $( ".dialog-dimmer" ).each( function()
        {
            position_dimmer( $( this ) );
        });
    });

    var position_dialog = function ($dialog, middleTop)
    {
        if( $dialog.is( ".notification" ) )
        {
            // Notifications always have fixed position; no calculation required.
            return;
        }

        // Position the dialog
        // in the center of the screen
        var top = ($window.height() - $dialog.outerHeight()) * .46 + $window.scrollTop()
        var left = ($window.width() - $dialog.outerWidth()) / 2 + $window.scrollLeft()

        // Make sure dialog isn't hidden by WebUI header panel.
        var headerPanelHeight = $( ".headerPanel" ).height();
        if( top < (headerPanelHeight + $window.scrollTop()) )
        {
            top = headerPanelHeight + $window.scrollTop();
        }

        if( middleTop )
        {
            top = 0;
            left = ($dialog.parent().width() - $dialog.outerWidth()) / 2 + $dialog.parent().scrollLeft();
        }
		
        $dialog.css(
        {
            top: top + 'px',
            left: left + 'px'
        })
    }
    
    var setup_dragbar = function ($dialog, $dragbar)
    {
        // Handle events on the (optional) drag bar
        
        var is_dragging = false
        var last_event = null
        
        var onmove = function (e)
        {
            e.preventDefault()
            
            if (!is_dragging)
            {
                is_dragging = true
                last_event = e
                return
            }
            
            var diff = {
                top: e.pageY - last_event.pageY,
                left: e.pageX - last_event.pageX
            }
            
            // Make sure dialog isn't hidden by WebUI header panel.
            var headerPanelHeight = $( ".headerPanel" ).height();
            var topPos = parseInt( $dialog.css( "top" ) ) + diff.top;
            if( topPos < (headerPanelHeight + $window.scrollTop()) )
            {
                topPos = headerPanelHeight + $window.scrollTop();
            }

            $dialog.css(
            {
                top: topPos + 'px',
                left: (parseInt($dialog.css('left')) + diff.left) + 'px',
            })

            last_event = e
        }
        
        var onup = function (e)
        {
            $(document).unbind('mousemove', onmove)
            $(document).unbind('mouseup', onup)
            is_dragging = false
        }
        
        $dragbar
            .bind('mousedown', function (e)
            {
                e.preventDefault()
                $(document).bind('mousemove', onmove)
                $(document).bind('mouseup', onup)
            })
    }
    
    // Create a new dialog
    $.fn.dialog = function ()
    {
        return this.each(function (options)
        {
            var $dialog = $(this)

            options = $.extend(
            {
                // If true, there will be no close button.
                // This can also be set by adding a class of "modal" to the 
                // source element.
                is_modal: $dialog.is('.modal'),
                
                // If true, reposition the dialog to the center of the viewport
                // when the viewport size changes
                position_on_resize: !$dialog.is('.inline'),
                
                // If true, dims the background when the dialog is opened.
                // This can also be set by adding a class of "dim" to the 
                // source element.
                dim_on_open: $dialog.is('.dim'),
				
                // Sets position to middle-top of parent div if true.
                position_middle_top: $dialog.is( '.dialogMiddleTop' )

            }, options)

            var $dialog = $(this)

            var $dimmer = null;
            if( options.dim_on_open )
            {
                var dimmerId = $dialog.attr( "id" ) + "Dimmer-" + dimmerCounter;
                dimmerCounter++;

                $dimmer = E( "div", "dialog-dimmer" )
                    .attr( "id", dimmerId )
                    .hide()
                    .appendTo( "body" );

                // For error and warning dialogs, apply corresponding class to dimmer;
                // provides higher z-index to ensure dimmer covers everything on page.
                if( $dialog.hasClass( "error" ) )
                {
                    $dimmer.addClass( "error" );
                }
                else if( $dialog.hasClass( "warning" ) )
                {
                    $dimmer.addClass( "warning" );
                }
            }


            $dialog
                .addClass('dialog')
                .wrapInner(E('div', 'content', E('div', 'inner')))
                .append(E('div', 'bottom', E('div')))
                .find('> .content')
                    .prepend(E('div', 'top'))
                .end()
                .bind('open', function ()
                {
                    position_dialog($(this), options.position_middle_top)

                    if( $dimmer )
                    {
                        position_dimmer( $dimmer );
                        $dimmer.show();
                    }

                    // Increase z-index of newly opened dialog so that it sits on top of other
                    // dialogs, if any. Also lower previously active (on top) dialog, if any.
                    $( ".dialog:visible" ).not( this ).removeClass( "active" );
                    $( this ).addClass( "active" );

                    $(this).show();

                })
                .bind('close', function ()
                {
                    if( $dimmer )
                    {
                        $dimmer.hide();
                    }

                    $( this ).removeClass( "active" );
                    $(this).hide();

                })

            var $title = $dialog.find('.title')
            
            if ($title.length > 0)
            {
                $title
					.wrapInner(E('div', 'content'))
                    .prepend(E('div', 'dragbar', E('div')))
					
            }
            
            if (!options.is_modal)
            {
                E('a', 'close').attr('href', '#').appendTo($dialog)
                    .click(function (e)
                    {
                        e.preventDefault()
                        $dialog.trigger('close')
                    })
            }

            var $dragbar = $dialog.find('.dragbar')

            if ($dragbar.length > 0)
            {
                $dialog.addClass('draggable')
                setup_dragbar($dialog, $dragbar)
                $dragbar.click( function()
                {
                    // Increase z-index of dialog when clicked so that it sits on top of other
                    // dialogs, if any. Also lower previously active (on top) dialog, if any.
                    $( ".dialog:visible" ).not( $dialog ).removeClass( "active" );
                    $dialog.addClass( "active" );
                });
            }
            
            if (options.position_on_resize)
            {
                $window.resize(function ()
                {
                    if ($dialog.is(':visible'))
                    {
                        position_dialog($dialog, options.position_middle_top )
                    }
                })
            }
            
            if ($dialog.is('.error,.warning'))
            {
                $dialog.find('> .content > .inner > .title > .content h1')
                    .prepend(E('span', 'icon'))
            }
        })
    }
    
	NSNReady(function () { 
		// Setup dialogs already on the page
	    $('.dialog').dialog()
	 })
})(jQuery)
