<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2017, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	CbsdUpdateRequest.php
//
// Description:	Source file for the CbsdUpdateRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";


class CbsdUpdateRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;  
		$this->cgiSecurityToken = $cgiSecurityToken;
	}


	// Accessor(s) and mutator(s)
	public function SetCbsdId($cbsdId)
	{
		$this->cbsdId = $cbsdId;
                $this->isCbsdIdPresent = true;
	}

	public function SetLatitude($latitude )
	{
		$this->latitude = $latitude;
                $this->isLatitudePresent = true;
	}
	public function SetLongitude($longitude )
	{
		$this->longitude = $longitude;
                $this->isLongitudePresent = true;
	}
	public function SetHeightType($heightType )
	{
		$this->heightType = $heightType;
                $this->isHeightTypePresent = true;
	}
	public function SetHeight($height )
	{
		$this->height = $height;
                $this->isHeightPresent = true;
	}
	public function SetHorizontalAccuracy($horizontalAccuracy )
	{
		$this->horizontalAccuracy = $horizontalAccuracy;
                $this->isHorizontalAccuracyPresent =  true;
	}
	public function SetVerticalAccuracy($verticalAccuracy )
	{
		$this->verticalAccuracy = $verticalAccuracy;
                $this->isVerticalAccuracyPresent =  true;
	}
	public function SetAntennaAzimuth($antennaAzimuth )
	{
		$this->antennaAzimuth = $antennaAzimuth;
                $this->isAntennaAzimuthPresent = true;
	}
	public function SetAntennaDowntilt($antennaDowntilt )
	{
		$this->antennaDowntilt = $antennaDowntilt;
                $this->isAntennaDowntiltPresent = true;
	}
	public function SetAntennaGain($antennaGain )
	{
		$this->antennaGain = $antennaGain;
                $this->isAntennaGainPresent = true;
	}
	public function SetAntennaBeamwidth($antennaBeamwidth )
	{
		$this->antennaBeamwidth = $antennaBeamwidth;
                $this->isAntennaBeamwidthPresent = true;
	}
	public function SetAntennaModel($antennaModel )
	{
		$this->antennaModel = $antennaModel;
                $this->isAntennaModelPresent = true;
	}
	protected function BuildMessageBody()
	{

		$msgString = "";
		$msgString .= "<CbsdUpdateRequest>\n";
                if($this->isCbsdIdPresent)
                {
                    $msgString .= "<_cbsdId>" . $this->cbsdId . "</_cbsdId>";
                }

                if($this->isLatitudePresent)
                {
                    $msgString .= "<latitude>" . $this->latitude . "</latitude>";
                }
                if($this->isLongitudePresent)
                {
		    $msgString .= "<longitude>" . $this->longitude . "</longitude>";
                }
                if($this->isHeightTypePresent)
                {
		    $msgString .= "<heightType>" . $this->heightType . "</heightType>";
                }
                if($this->isHeightPresent)
                {
		    $msgString .= "<height>" . $this->height . "</height>";
                }
                if($this->isHorizontalAccuracyPresent)
                {
		    $msgString .= "<horizontalAccuracy>" . $this->horizontalAccuracy . "</horizontalAccuracy>";
                }
                if($this->isVerticalAccuracyPresent)
                {
		    $msgString .= "<verticalAccuracy>" . $this->verticalAccuracy . "</verticalAccuracy>";
                }
                if($this->isAntennaAzimuthPresent)
                {
		    $msgString .= "<antennaAzimuth>" . $this->antennaAzimuth . "</antennaAzimuth>";
                }
                if($this->isAntennaDowntiltPresent)
                {
		    $msgString .= "<antennaDowntilt>" . $this->antennaDowntilt . "</antennaDowntilt>";
                }
                if($this->isAntennaGainPresent)
                {
		    $msgString .= "<antennaGain>" . $this->antennaGain . "</antennaGain>";
                }
                if($this->isAntennaBeamwidthPresent)
                {
		    $msgString .= "<antennaBeamwidth>" . $this->antennaBeamwidth . "</antennaBeamwidth>";
                }
                if($this->isAntennaModelPresent)
                {
		    $msgString .= "<antennaModel>" . $this->antennaModel . "</antennaModel>";
                }
		$msgString .= "</CbsdUpdateRequest>\n";
		return $msgString;
	}


	// Private data member(s)
        private $latitude;
        private $isLatitudePresent = false;
	private $longitude;
        private $isLongitudePresent = false;
	private $heightType;
        private $isHeightTypePresent = false;
	private $height;
        private $isHeightPresent = false;
	private $horizontalAccuracy;
        private $isHorizontalAccuracyPresent = false;
	private $verticalAccuracy;
        private $isVerticalAccuracyPresent = false;
	private $antennaAzimuth;
        private $isAntennaAzimuthPresent = false;
	private $antennaDowntilt;
        private $isAntennaDowntiltPresent = false;
	private $antennaGain;
        private $isAntennaGainPresent = false;
	private $antennaBeamwidth;
        private $isAntennaBeamwidthPresent = false;
	private $antennaModel;
        private $isAntennaModelPresent = false;
        private $cbsdId;
        private $isCbsdIdPresent = false;
};

?>
