<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ConfigResetRequest.php
//
// Description:	Source file for the ConfigResetRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class ConfigResetRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken)
	{
		parent::__construct();
		$this->sessionId = $sessionId;
		$this->cgiSecurityToken = $cgiSecurityToken;
		$this->removeSiteId = "";
		$this->removeSecurityCredentials = "";
	}
	public function SetRemoveSiteId( $removeSiteId )
	{
		$this->removeSiteId = $removeSiteId;
	}

	public function GetRemoveSiteId()
	{
		return $this->removeSiteId;
	}

	public function SetRemoveSecurityCredentials( $removeSecurityCredentials )
	{
		$this->removeSecurityCredentials = $removeSecurityCredentials;
	}

	public function GetRemoveSecurityCredentials()
	{
		return $this->removeSecurityCredentials;
	}

	
	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<ConfigurationResetRequest>\n";
		$msgString .= "<_removeSecurityCredentials>" . $this->removeSecurityCredentials . "</_removeSecurityCredentials>\n";
		$msgString .= "<_removeSiteId>" . $this->removeSiteId . "</_removeSiteId>\n";
		$msgString .= "</ConfigurationResetRequest>\n";
		return $msgString;
	}
}

?>
