<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	LinkManagementRequest.php
//
// Description:	Source file for the LinkManagementRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class LinkManagementRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId )
	{
		parent::__construct();
		$this->sessionId = $sessionId;
		$this->userActivityInd = false;
	}


	// Accessor(s) and mutator(s)

	public function SetUserActivityIndicator()
	{
		$this->userActivityInd = true;
	}

	public function GetUserActivityIndicator()
	{
		return $this->userActivityInd;
	}


	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<LinkManagementRequest>\n";

		if( $this->userActivityInd === true )
		{
			$msgString .= "<userActivityIndicator></userActivityIndicator>\n";
		}
		$msgString .= "</LinkManagementRequest>\n";

		return $msgString;
	}


	// Private data member(s)
	private $userActivityInd;
}

?>
