<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	LoginRequest.php
//
// Description:	Source file for the LoginRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class LoginRequest extends CreatedMessage
{
	private $username;
	private $password;
	
	// Constructor for sent messages
	public function __construct( $username, $password, $cgiSecurityToken)
	{
		parent::__construct();

		$this->username = $username;
		$this->password = $password;
		$this->cgiSecurityToken = $cgiSecurityToken;
 	}

	public function SetUserName( $username )
	{
		$this->username = $username;
	}

	public function GetUserName()
	{
		return $this->username;
	}

	public function SetPassWord( $password )
	{
		$this->password = $password;
	}

	public function GetPassWord()
	{
		return $this->password;
	}

	protected function BuildMessageBody()
	{
		// Escape special characters in message strings that could cause
		// XML parsing to fail.
		$userNameEncoded = htmlspecialchars( $this->username );
		$passWordEncoded = htmlspecialchars( $this->password );

		$msgString = "";
		$msgString .= "<LoginRequest>\n";
		$msgString .= "<_password>" . $passWordEncoded . "</_password>\n";
		$msgString .= "<_userName>" . $userNameEncoded . "</_userName>\n";
		$msgString .= "</LoginRequest>\n";

		return $msgString;
	}
}

?>
