<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2016, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ModifyBandClassRequest.php
//
// Description:	Source file for the ModifyBandClassRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class ModifyBandClassRequest extends CreatedMessage
{
  public function __construct( $sessionId, $cgiSecurityToken)
  {
    parent::__construct();
    $this->sessionId = $sessionId;
    $this->cgiSecurityToken = $cgiSecurityToken;
    $this->bandClass =  "";
  }
  
  public function SetBandClass($bandClass)
  {
    $this->bandClass = $bandClass;
  }
  
  protected function BuildMessageBody()
  {
    //Message to backend goes here
    $msgString = "";
    $msgString .= "<ModifyBandClassRequest>\n";
    $msgString .= "<_bandClass>" . $this->bandClass . "</_bandClass>\n";
    $msgString .= "</ModifyBandClassRequest>\n";
          return $msgString;

  }
}

?>