<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	ResetRequest.php
//
// Description:	Source file for the ResetRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class ResetRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId, $cgiSecurityToken )
	{
		parent::__construct();
		$this->sessionId = $sessionId;
		$this->cgiSecurityToken = $cgiSecurityToken;
		$this->_antModId = "0";
	}

	public function SetAntModId( $_antModId )
	{
		$this->_antModId = $_antModId;
	}

	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<ResetRequest>\n";
		$msgString .= "<_resetCoverage>site</_resetCoverage>\n";
		$msgString .= "<_antModId>" . $this->_antModId . "</_antModId>\n";
		$msgString .= "</ResetRequest>\n";

		return $msgString;
	}

	// Private data member(s)
	private $_antModId;
}

?>
