<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2014, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	SnapshotRequest.php
//
// Description:	Source file for the SnapshotRequest class.
//
// ****************************************************************************

include_once "CreatedMessage.php";

class SnapshotRequest extends CreatedMessage
{
	// Constructor
	public function __construct( $sessionId )
	{
		parent::__construct();
		$this->sessionId = $sessionId;

		// Default to full log collection.
		$this->_logCoverage = "full";
	}


	public function SetLogCoverage( $_logCoverage )
	{
		// Currently "full" and "minor" are the only values supported.
		if( ($_logCoverage === "full") || ($_logCoverage === "minor") )
		{
			$this->_logCoverage = $_logCoverage;
		}
	}

	public function GetLogCoverage()
	{
		return $this->_logCoverage;
	}


	protected function BuildMessageBody()
	{
		$msgString = "";
		$msgString .= "<SnapshotRequest>\n";
		$msgString .= "<_logCoverage>" . $this->_logCoverage . "</_logCoverage>\n";
		$msgString .= "</SnapshotRequest>\n";

		return $msgString;
	}


	private $_logCoverage;
}

?>
