<?php
// ****************************************************************************
// ----------------------------------------------------------------------------
//			Copyright 2015, Nokia Networks
//			All Rights Reserved
// ----------------------------------------------------------------------------
//
// Title:	TokenResponse.php
//
// Description:	Source file for the TokenResponse class.
//
// ****************************************************************************

include_once "AcceptedMessage.php";

class LoginTokenResponse extends AcceptedMessage
{
	// Constructor
	public function __construct()
	{
		// Invoke parent constructor (not done automatically in PHP).
		parent::__construct();

		$this->statusInd = "Invalid";
		$this->SecurityToken = "";
	}


	public function Parse( SimpleXMLElement $sxe )
	{
		// Parsing a received message. The passed-in argument should be
		// an already parsed (from XML) SimpleXMLElement representing the
		// message body.

		if( !$sxe )
		{
			syslog( LOG_ERR, "Null XML element in TokenResponse::Parse()" );
			return;
		}

		$statusPresent = false;
		foreach( $sxe->children() as $node )
		{
			switch( $node->getName() )
			{
			case "statusInd":
				$this->SetStatus( (string)$node );
				$statusPresent = true;
				break;

			case "CGISecurityToken":
				$this->SecurityToken = (string)$node;
				break;

				// Default: ignoring other elements, if any.
			}
		}

		// Check for presence of mandatory element(s).
		if( !$statusPresent )
		{
			// Missing mandatory element.
			syslog( LOG_ERR, "Invalid TokenResponse message; missing statusInd element" );
			return;
		}


		// Message is valid.
		$this->okFlag = true;
	}


	// Accessor(s) and mutator(s).

	public function SetStatus( $statusInd )
	{
		if( ($statusInd === "Success") || ($statusInd === "Failure") )
		{
			$this->statusInd = $statusInd;
		}
	}

	public function GetStatus()
	{
		return $this->statusInd;
	}

	public function GetToken()
	{
		return $this->SecurityToken;
	}

	// Private attribute(s)
	private $statusInd;
	private $SecurityToken;
}

?>
