#!/bin/bash

echo "slave_files_update started"
which_board_file="/usr/bin/which_board"
enter="
"
slave_files="slave_files.xml"
software_directory="/ffs/run/"
software_release_version="PSVER"

if [ ! -e $which_board_file ]
then
        echo "file which_board does not exist - slave_file_update stopped"
        exit 1
fi

if [ ! $($which_board_file) == "BOARD_FZM_MASTER" ] && [ ! $($which_board_file) == "BOARD_FZM_SLAVE" ];
then
        echo "not FWHD board - slave_file_update stopped"
        exit 0
fi

if [ ! -e $slave_files ]
then
        echo "file slave_files.xml does not exist - slave_file_update stopped"
        exit 1
fi

######################################################################################
####Fill checksum
file_name_line=".*name=\""
file_name_line_end="\".*"
temp_line=""

# read file to variable and add 'enter' after each: '\>',' >', '">"
old_file=$(cat $slave_files | sed  "s/\/>/\/>\n/g" | sed "s/ >/ >\n/g" | sed "s/\">/\">\n/g")

new_list=""

#line should contains white space
IFS=''
while read -r line;
do
        if [[ "$line" == *"<file"* ]]; then
			#get file name
            temp_line=$(echo -e "$line" | sed "s/$file_name_line//g" | sed "s/$file_name_line_end//g")
			#update file path and change '*' to '\*' to avoid 'sed' command issue
			file_name_orig="$temp_line"
			file_name_orig=$(echo "$file_name_orig" | sed "s;\*;\\\*;g")
			temp_line="$software_directory$temp_line"

			if [ -e $temp_line ]; then
				#file exists -> check md5sum and exactly file name 

				#get file name without wildcard '*' and write it finally in slave_files.xml
				file_name_final=$(md5sum $temp_line | awk '{print $2}')
				file_name_final=$(echo -e "$file_name_final" | sed "s;$software_directory;;g")
				line=$(echo "$line" | sed "s;$file_name_orig;$file_name_final;g")
				
				#get md5sum
				checksum_md5_line=$(md5sum $temp_line | awk '{print $1}')

				#add last 5 digit of md5sum to software_release_version
				#skip APPDEF*tgz file, because APPDEF.tgz file is modified on Slave 
				#and md5sum of the file will be always different on Master and Slave
				if [[ ! $temp_line == *"APPDEF"* ]]
				then
					if [[ $temp_line == *"u-boot.img"* ]]
					then
						#for u-boot.img get binary file and use its md5sum to software version
						temp_uboot_bin_line=$(echo "$temp_line" | sed "s;u-boot.img;u-boot.bin;g")
						mkimage -p 0 -g $temp_uboot_bin_line $temp_line
						if [ -e $temp_uboot_bin_line ]; then
							checksum_uboot_bin_line==$(md5sum $temp_uboot_bin_line | awk '{print $1}')
							software_release_version="$software_release_version$(echo '_')${checksum_uboot_bin_line: -5}"
						fi
					else
						software_release_version="$software_release_version$(echo '_')${checksum_md5_line: -5}"
					fi
				fi
			
				#add md5sum to xml
				new_line=$(echo -e "$line" | sed "s/checksum/$checksum_md5_line/g")
	            #add new line
        	    new_list="$new_list$new_line"
			else
				#insert line to the file
                new_list="$new_list$line"
			fi
        else
            if [ -n "$line" ]; then
				#insert line to the file
				new_list="$new_list$line"
            else
                # empty line means there was enter in original file
                new_list=$new_list$enter
            fi
        fi

done <<< "$old_file"

echo "$new_list" > $slave_files

###########################################################################
#Change '/' to '\/' in $software_release_version to avoid sed command error
software_release_version=$(echo "$software_release_version" | sed "s:/:\\\/:g")
####Fill Software version
sed -i "s/software_release_version/$software_release_version/g" $slave_files

#move slave_files.xml and slave_post_install.sh to /ram to allow slave get it from master
mv /opt/hwr/slave_files.xml /ram/
mv /opt/hwr/slave_post_install.sh /ram/

echo "slave_files_update completed"
 
exit 0
