#!/bin/bash

#
# Usage example:
#   cat RTCCSConfig.xml | ./parse_xml.sh ccs.service.em.core_count
#   # will print the value of 'ccs.service.em.core_count' tag to stdout 
#

read_dom () {
    local IFS=\>
    read -d \< ENTITY CONTENT
    local RET=$?
    TAG_NAME=${ENTITY%% *}
    ATTRIBUTES=${ENTITY#* }
    return $RET
}

print_tag_value() {
    local tag_name="$1"
    if [[ $TAG_NAME = "tag" ]] ; then
        eval local $ATTRIBUTES
        if [[ $name = "$tag_name" ]] ; then
            echo $CONTENT
        fi
    fi
}

while read_dom; do
    print_tag_value $1
done
