#!/bin/sh

if [ "x${ROOT_DIR}" = "x" ]; then
  if [ -d "/tmp/SIM" ]; then
    ROOT_DIR="/tmp/SIM"
  else
    ROOT_DIR=""
  fi
fi

PATH="${ROOT_DIR}/opt/trs/bin:${PATH}"

LOGDIR=${ROOT_DIR}/ffs/run/logs
STBLOGDIR=${ROOT_DIR}/ffs/stb/logs

# enable shell variables
set +o nounset

echo "TRS Shutdown Started"

count=`test_hlEeprom getResetCnt allResets | /usr/bin/awk '/Function returns/ {print $3}' 2>/dev/null`
echo "TRS Reset Count: ${count}"

#echo "TRS Writing Journal To File"
#journalctl -b > ${LOGDIR}/JournalLog.${count}

# the LogReader garbles some of the entries.  until it is fixed use ascii output
#echo "TRS Writing Trace Log To File"
ukpt dump ${LOGDIR}/TraceLog.${count}
#ukpt "*" > ${LOGDIR}/TraceLog.${count}

#echo "TRS Writing Ccs Log To File"
cp /opt/trs/etc/ccs_log.txt ${LOGDIR}/CcsLog.${count}

# if the stb is unlocked copy logs to stb
if [ -w ${STBLOGDIR} ]; then
    cp -af ${LOGDIR}/TraceLog.${count} ${STBLOGDIR}/TraceLog.${count}
    cp -af ${LOGDIR}/CcsLog.${count} ${STBLOGDIR}/CcsLog.${count}
    #cp -af ${LOGDIR}/JournalLog.${count} ${STBLOGDIR}/JournalLog.${count}
fi

echo "TRS Shutdown Complete"

unset count
set -o nounset

