#!/bin/sh

##################### VTC IPSEC WRAPPER SCRIPT ##########################################
##          This script is required to enable/disable IPsec in FP and                  ##
##          start/stop/status/statusall IPsec daemon                                   ##
############################### 13.12.2013 ##############################################
newline=$'\n'
IPSEC="/usr/sbin/ipsec"
OPT_DIR="/opt/trs"
TRS_BIN_DEST="${OPT_DIR}/bin"

   
function usage()
{
    echo "To start ipsec daemon"
    echo "$0 start ${newline}"

    echo "To stop ipsec daemon"
    echo "$0 stop ${newline}"

    echo "To restart ipsec daemon"
    echo "$0 restart ${newline}"

    echo "To check status of ipsec daemon"
    echo "$0 status ${newline}"

    echo "To check statusall of ipsec daemon"
    echo "$0 statusall ${newline}"
}


startIpsecDaemon()
{
    $IPSEC start
}

stopIpsecDaemon()
{
    $IPSEC stop
}

ipSecStatus()
{
    $IPSEC status
}

ipSecStatusall()
{
    $IPSEC statusall
}

validate_args()
{
    if [ "$#" -eq 1 ]; then
        case $1 in

            enable) #Ignore,No fastpath in FZM
                ;;

            disable) #Ignore,No fastpath in FZM
                ;;

            start)
                startIpsecDaemon
                ;;

            stop)
                stopIpsecDaemon
                ;;

            restart)
                stopIpsecDaemon
                sleep 2
                startIpsecDaemon
                ;;

            status)
                ipSecStatus
                ;;

            statusall)
                ipSecStatusall
                ;;

            *)
                echo "invalid argument"
                usage
                exit
                ;;
        esac
    fi
}

if [ "$#" -eq 1 ]; then
    validate_args $1
else
    usage
    exit
fi
