#!/bin/sh

## Paths and definitions
tc=/sbin/tc
ext=br0 # External Interface!
ext_ingress=ifb0 # Ifb device

ext_up=2000kbit
ext_down=25200kbit

mplane_ip=0.0.0.0

if [ -e "/tmp/iptables_addresses.conf" ]; then
   mplane_ip=`cat /tmp/iptables_addresses.conf | grep "IP_MPLANE" | cut -c11-`
   if [ ! "$mplane_ip" ];then
     return 0;
   fi
else
   return 0;
fi

modprobe ifb
modprobe sch_fq_codel
modprobe act_mirred

# Clear old queuing disciplines (qdisc) on the interfaces
$tc qdisc del dev $ext_ingress root

#########
# INGRESS
#########

# Create ingress on external interface
$tc qdisc add dev $ext handle ffff: ingress

ip link set $ext_ingress up # if the interace is not up bad things happen

# Filter m-plane tcp packets and forward the traffic to the IFB device
#$tc filter add dev $ext parent ffff: protocol ip u32 match ip protocol 0x6 0xff match ip dst $mplane_ip action mirred egress redirect dev $ext_ingress

# Create an EGRESS filter on the IFB device
$tc qdisc add dev $ext_ingress root handle 1: htb default 11

# Add root class HTB with rate limiting
$tc class add dev $ext_ingress parent 1: classid 1:1 htb rate $ext_down
$tc class add dev $ext_ingress parent 1:1 classid 1:11 htb rate $ext_down prio 0

# Add FQ_CODEL qdisc without ECN support 
$tc qdisc add dev $ext_ingress parent 1:11 fq_codel noecn

#########
# EGRESS
#########
# Add FQ_CODEL to EGRESS on external interface
#$tc qdisc add dev $ext root handle 1: htb default 11

# Add root class HTB with rate limiting
#$tc class add dev $ext parent 1: classid 1:1 htb rate $ext_up
#$tc class add dev $ext parent 1:1 classid 1:11 htb rate $ext_up prio 0 

# Add FQ_CODEL qdisc without ECN support - on egress 
#$tc qdisc add dev $ext parent 1:11 fq_codel noecn

