#!/bin/bash
#To collect Core files in ORB hang Scenario
file="/tmp/check.txt"
if [ -f "$file" ]; then
	echo "File $file Present: debug_orbhang.sh is already triggered"
	exit
else
	echo "FILE $file not Present: Triggered debug_orbhang.sh"
	touch $file
	rm -rf /ffs/run/debug
	mkdir -p /ffs/run/debug
        UNIT_TYPE=`/opt/trs/bin/test_envInfo envInfoUnitTypeIsFzm | grep UNIT`
        if [ "UNIT_FZM" != "$UNIT_TYPE" ]; then
            UNIT_TYPE=`/opt/trs/bin/test_envInfo envInfoUnitType | grep UNIT`
        fi
	declare -A TID
	TID=( ["0x5E150101"]="trsMgr"  ["0x949F0101"]="trsDrvCore"  ["0xBE3B0101"]="ipcsAdaptor"  ["0x5C4B0101"]="topAdapterTask"  ["0x74420101"]="cdm"  ["0xAA9D0101"]="rstpAdaptor"  ["0x81650101"]="SmaCertMgr"  ["0xCBC10101"]="Nma"  ["0xC61F0101"]="SmaRuim"  ["0xA76C0101"]="SmaFileTransfer"  ["0x748C0101"]="NmapAgent"  ["0x87380101"]="IpTestSuite"  ["0xBC080101"]="trswConfig"  ["0xA6710101"]="SmaXoh"  ["0xA5460101"]="atmAdaptor"  ["0x83720101"]="SmaRuem"  ["0x524F0101"]="trsDrvCoreBfd"  ["0xF62A0101"]="SmaAsn1"  ["0x55E90201"]="trsDrvExt" )

	if [ "UNIT_FZM" = "$UNIT_TYPE" ] || [ "UNIT_FCTA" = "$UNIT_TYPE" ]; then
		/opt/trs/bin/ukpt 255 > /opt/trs/etc/trs_logs.txt
	else
		gunzip -f /var/log/trs.*
		cat /var/log/trs* > /opt/trs/etc/trs_logs.txt
	fi
	cat /opt/trs/etc/trs_logs.txt | grep -n "waits now 180 seconds for response from" > /opt/trs/etc/ORBhang_logs.txt
	i=`cat /opt/trs/etc/ORBhang_logs.txt | grep -n "waits now 180 seconds for response from" | wc -l`

	if [ "$i" -gt 0 ]; then
		cat /opt/trs/etc/ORBhang_logs.txt | egrep -o 0[xX][0-9a-fA-F]\+ > /opt/trs/etc/all_TIDs.txt
		awk 'NR % 2 == 0' /opt/trs/etc/all_TIDs.txt > /opt/trs/etc/TIDs.txt
		awk '!seen[$0]++' /opt/trs/etc/TIDs.txt > /opt/trs/etc/Final_TIDs.txt
		Total_TIDs=`cat /opt/trs/etc/Final_TIDs.txt | grep -n "0x" | wc -l`
		declare -a Values
		readarray -t Values < /opt/trs/etc/Final_TIDs.txt
		rm /opt/trs/etc/Final_TIDs.txt /opt/trs/etc/all_TIDs.txt /opt/trs/etc/TIDs.txt
	fi
	rm /opt/trs/etc/trs_logs.txt /opt/trs/etc/ORBhang_logs.txt

	while [ "$Total_TIDs" -gt "0" ]; do
		for key in ${!TID[@]}; do
			if [ ${key} = ${Values[$Total_TIDs-1]} ]; then
				Process_name=${TID[${key}]}
				break
			fi
		done
		kill -6 `pidof $Process_name`
		echo "Killed Process: ${Values[$Total_TIDs-1]} ${TID[${key}]}"
		sleep 60
		if [ "UNIT_FCTJ" = "$UNIT_TYPE" ]; then
			find /ffs/run/logs/* -name *coreinfo.txt | cut -d'/' -f1-8 > /ffs/run/logs/trs_corefiles
			core_path=`cat /ffs/run/logs/trs_corefiles`
			if [ -s ${core_path} ]; then
				echo "core_path: $core_path"
				cp -r $core_path/* /ffs/run/debug
				rm -rf $core_path/*
			else
	        	                echo "FILE $corepath no content"
			fi
		fi
		if [ "UNIT_FCTA" = "$UNIT_TYPE" ]; then
			cp -r /var/tmp/diagn/node_0x1011/0x1011/* /ffs/run/debug
			rm -rf /var/tmp/diagn/node_0x1011/0x1011/*
		fi
		if [ "UNIT_FZM" = "$UNIT_TYPE" ]; then
			cp -r /var/tmp/diagn/node_0x123d/0x123d/* /ffs/run/debug
			rm -rf /var/tmp/diagn/node_0x123d/0x123d/*
		fi
		Total_TIDs=`expr $Total_TIDs - 1`
	done
	if [ "UNIT_FZM" != "$UNIT_TYPE" ]; then
		cp -r /var/log/trs* /ffs/run/debug
		cp -r /var/log/messages* /ffs/run/debug
	fi
	echo "done"
fi
