#!/bin/sh

ALETABLE="/tmp/ale_table.txt"
TMPBUFFER="/tmp/ale_tmp.txt"
WIFIPORT_ALE_TABLE="/tmp/wifiport_ale_table.txt"

rm -f $ALETABLE $TMPBUFFER
cat /sys/devices/soc.*/2090000.netcp/ale_table > $TMPBUFFER
sed '/entries/d' $TMPBUFFER > $ALETABLE
isEndofFile="0"
NoOfAttempts="0"

while [ "$isEndofFile" == "0" -o "$NoOfAttempts" != 30 ]
do
    sed -n '$p' $TMPBUFFER | grep "entries, +"  > /dev/null #check if more entries are present in the last line
    if [ "$?" == "1" ]; then
        entries=`wc -l $ALETABLE | awk '{ print $1 }'`
        isEndofFile="1"
        break;
    fi
    cat /sys/devices/soc.*/2090000.netcp/ale_table > $TMPBUFFER
    sed '/entries/d' $TMPBUFFER >> $ALETABLE
    NoOfAttempts=$(($NoOfAttempts + 1))
done
