# TRS configuration delete. This script will be
# executed by HWAPI module when configuration reset action is
# triggered via SEM or with reset button press.
# Req Reference: WBTS_STRT_69673

PERSISTENCE_DIR_RUN=/ffs/run/trs_data/db
PERSISTENCE_DIR_STB=/ffs/stb/trs_data/db
ACTIVE_PATH=/ffs/run/trs_data/active
ACPAR_FILE=/ffs/run/trs_data/active/ACPAR.xml
AC_LOG_FILE=/ffs/run/trs_data/active/autoConnectionFile
DHCP_LEASE_FILE=/ffs/run/trs_data/active/dhclient.leases
DHCP_SFN_LEASE_FILE=/ffs/run/trs_data/active/dhcpd_sfn.leases
DHCP_MAC_FILE=/ffs/run/trs_data/active/dhcpmacaddr.txt
DHCP_LEASE_FILE_STB=/ffs/stb/trs_data/active/dhclient.leases
DHCP6_LEASE_FILE=/ffs/run/logs/dhclient6.leases
DHCP_MAC_FILE_STB=/ffs/stb/trs_data/active/dhcpmacaddr.txt
LOG_FILE=/var/log/config_reset.log
TRSW_NEAC_FILE=/ffs/run/trs_data/active/keystorage/neac.db
BACKUP_LOG_FILE=/var/log/config_reset_backup.log
WPA_SUPPL_DHCP_OFFER_MTU_XML=/ffs/run/trs_data/active/wpa_suppl_dhcp_offer_mtu.xml
export SHELL=/bin/sh


# delete persist.db and persist.bak from active as well as standby directories
if [ -e "$LOG_FILE" ]; then
  count=$(wc -l "$LOG_FILE"|awk '{print $1}')

  if [ $count -gt 98  ]; then
     rm -f "${BACKUP_LOG_FILE}" >/dev/null 2>&1
     mv -f "${LOG_FILE}" "${BACKUP_LOG_FILE}"
  fi
fi


 echo "TRS configuration delete Triggerd at: $(date)" >> $LOG_FILE

 if [ -e "${PERSISTENCE_DIR_RUN}/persist.bak" ]; then
    rm -f "${PERSISTENCE_DIR_RUN}/persist.bak" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_RUN}/persist.db" ]; then
     rm -f "${PERSISTENCE_DIR_RUN}/persist.db" >/dev/null 2>&1
 fi
 
 if [ -e "${PERSISTENCE_DIR_RUN}/port_swap.db" ]; then
     rm -f "${PERSISTENCE_DIR_RUN}/port_swap.db" >/dev/null 2>&1
 fi
 
 if [ -e "${PERSISTENCE_DIR_STB}/persist.bak" ]; then
    rm -f "${PERSISTENCE_DIR_STB}/persist.bak" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_STB}/persist.db" ]; then
    rm -f "${PERSISTENCE_DIR_STB}/persist.db" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_STB}/port_swap.db" ]; then
    rm -f "${PERSISTENCE_DIR_STB}/port_swap.db" >/dev/null 2>&1
 fi
 
 if [ -e "${ACPAR_FILE}" ]; then
    rm -f "${ACPAR_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${TRSW_NEAC_FILE}" ]; then
    if [ ! -f "${ACTIVE_PATH}/notToDelNeacDB.txt" ]; then
       rm -f "${TRSW_NEAC_FILE}" >/dev/null 2>&1
    else
       rm -f "${ACTIVE_PATH}/notToDelNeacDB.txt" >/dev/null 2>&1
    fi
 fi

 if [ -e "${DHCP_LEASE_FILE}" ]; then
     rm -f "${DHCP_LEASE_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${DHCP6_LEASE_FILE}" ]; then
     rm -f "${DHCP6_LEASE_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${DHCP_SFN_LEASE_FILE}" ]; then
     rm -f "${DHCP_SFN_LEASE_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${DHCP_MAC_FILE}" ]; then
     rm -f "${DHCP_MAC_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${DHCP_LEASE_FILE_STB}" ]; then
     rm -f "${DHCP_LEASE_FILE_STB}" >/dev/null 2>&1
 fi

 if [ -e "${DHCP_MAC_FILE_STB}" ]; then
     rm -f "${DHCP_MAC_FILE_STB}" >/dev/null 2>&1
 fi

 if [ -e "${AC_LOG_FILE}" ]; then
    rm -f "${AC_LOG_FILE}" >/dev/null 2>&1
 fi

 if [ -e "${WPA_SUPPL_DHCP_OFFER_MTU_XML}" ]; then
    rm -f "${WPA_SUPPL_DHCP_OFFER_MTU_XML}" >/dev/null 2>&1
 fi

 echo "TRS Configuration delete finished at: $(date)" >> $LOG_FILE
