# TRS configuration delete. This script will be
# executed by HWAPI module when configuration reset action is
# triggered via SEM or with reset button press.

PERSISTENCE_DIR_RUN=/ffs/run/trs_data/db
PERSISTENCE_DIR_STB=/ffs/stb/trs_data/db
PNASC_FILE=/ffs/run/config/pnasc_params.xml
LOG_FILE=/var/log/config_reset.log
BACKUP_LOG_FILE=/var/log/config_reset_backup.log
SUPPLICANT_CERT_DIR=/ffs/run/trs_data/active/keystorage/supplicantcerts/
SUPPLICANT_EAPTLS_CERT_DIR=/ffs/run/trs_data/active/keystorage/supplicantcerts/eaptls/

export SHELL=/bin/sh

if [ -e "$LOG_FILE" ]; then
  count=$(wc -l "$LOG_FILE"|awk '{print $1}')
  if [ $count -gt 98  ]; then
     rm -f "${BACKUP_LOG_FILE}" >/dev/null 2>&1
     mv -f "${LOG_FILE}" "${BACKUP_LOG_FILE}"
  fi
fi


 echo "TRS 802.1X configuration delete Triggerd at: $(date)" >> $LOG_FILE

 if [ -e "${PERSISTENCE_DIR_RUN}/persist.bak" ]; then
    rm -f "${PERSISTENCE_DIR_RUN}/persist.bak" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_RUN}/persist.db" ]; then
    rm -f "${PERSISTENCE_DIR_RUN}/persist.db" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_STB}/persist.bak" ]; then
    rm -f "${PERSISTENCE_DIR_STB}/persist.bak" >/dev/null 2>&1
 fi

 if [ -e "${PERSISTENCE_DIR_STB}/persist.db" ]; then
    rm -f "${PERSISTENCE_DIR_STB}/persist.db" >/dev/null 2>&1
 fi

 if [ -e "${PNASC_FILE}" ]; then
    rm -f "${PNASC_FILE}" >/dev/null 2>&1
 fi

 if [ -d "$SUPPLICANT_EAPTLS_CERT_DIR" ]; then
    rm -f $SUPPLICANT_EAPTLS_CERT_DIR* >/dev/null 2>&1
 fi

 if [ -d "$SUPPLICANT_CERT_DIR" ]; then
    rm -f $SUPPLICANT_CERT_DIR* >/dev/null 2>&1
 fi

 echo "TRS 802.1X Configuration delete finished at: $(date)" >> $LOG_FILE
