# is for Starting/Stopping/Restarting Lighttpd. You won't need
# to edit anything.
# Decide the conf file based upon if CA cert is available 
LIGHTTPD_CONF=/opt/trs/etc/lighttpd.conf
PIDFILE=/tmp/lighttpd.pid
BTSOM_LIGHTTPD_CONF=/opt/trs/etc/btsom_lighttpd.conf
BTSOM_PIDFILE=/tmp/btsom_lighttpd.pid
FZAP_FILE=/tmp/isFZAP
export SHELL=/bin/sh
 
case "$1" in
  start)
    # Starts the lighttpd deamon
    echo "Starting Lighttpd"
    #PATH=$PATH:/usr/local/bin /usr/sbin/lighttpd -f $LIGHTTPD_CONF &
    /usr/sbin/lighttpd -f $LIGHTTPD_CONF &
    /usr/sbin/lighttpd -f $BTSOM_LIGHTTPD_CONF &
    ;;
  stop)
    # stops the daemon bt cat'ing the pidfile
    echo "Stopping Lighttpd"
    kill `/bin/cat $PIDFILE`
    kill `/bin/cat $BTSOM_PIDFILE`
    ;;
  restart)
    ## Stop the service regardless of whether it was
    ## running or not, start it again.
    echo "Restarting Lighttpd"
    $0 stop
    $0 start
    ;;
  reload)
    # reloads the config file by sending HUP
    echo "Reloading config"
    kill -HUP `/bin/cat $PIDFILE`
    kill -HUP `/bin/cat $BTSOM_PIDFILE`
    ;;
  *)
    echo "Usage: lighttpdctrl (start|stop|restart|reload)"
    exit 1
    ;;
esac
