#!/bin/sh

export PATH=/bin:/sbin:/usr/bin:/usr/local/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

#LTE1266
UNIT=`/opt/trs/bin/test_envInfo envInfoUnitType | head -1`
if [ $UNIT == "UNIT_FCTA" ]; then
FLAG=`/opt/trs/bin/test_envInfo envInfoIfRP441 | head -1`
if [ $FLAG == "RP441_ENABLE" ]; then
FTP_DIR="/shareTmp/transport/ftp"
else
FTP_DIR="/tmp/ftp"
fi
else
FTP_DIR="/tmp/ftp"
fi

was_cgi_bin=$(wasCgiBin $SCRIPT_NAME)
if [ $was_cgi_bin -eq 1 ]; then
    sendUnauthorizedMessage 0 "Enhanced Log Collection"
    exit
fi

while [ $# -ge 1 ]; do
    case "$1" in
    "np_debug_info") np_debug_info="yes";;
    "np_tables") np_tables="yes";;
    *) echo "not understood";;
    esac
    shift
done

UNIT=$(test_envInfo -a|sed -e '/Unit/ !d;s/.*UNIT_//;s/)$//;s/\s//')
PRODUCT=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
DATE=$(date 2>/dev/null)

echo '**********************************************'
echo '*                                            *'
echo '*       Product: '$PRODUCT'                       *'
echo '*       Unit:    '$UNIT'                        *'
echo '*                                            *'
echo '*       '$DATE'          *'
echo '*                                            *'
echo '**********************************************'
echo ''
echo ''
echo '**********************************************'
echo '*                                            *'
echo '*       uCode counters                       *'
echo '*                                            *'
echo '**********************************************'
echo ''
echo 'cat /proc/me/uc_cnt/all_bank'
cat /proc/me/uc_cnt/all_bank 2>/dev/null
echo ''
echo 'cat /proc/me/gp_cnt/all_bank'
cat /proc/me/gp_cnt/all_bank 2>/dev/null
echo ''
echo 'cat /proc/me/init'
cat /proc/me/init 2>/dev/null
echo ''
echo '**********************************************'
echo '*                                            *'
echo '*       NP ARP table                         *'
echo '*                                            *'
echo '**********************************************'
echo ''
echo 'np me_iubiptest_show_arp_table'
np me_iubiptest_show_arp_table 2>/dev/null
echo ''
if [ "WCDMA" = "$PRODUCT" ]; then
    echo ''
    echo 'grep -i ucode /proc/me/init'
    grep -i ucode /proc/me/init 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 48 0'
    np me_aal2test_tx_qos_pmcntr 48 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 49 0'
    np me_aal2test_tx_qos_pmcntr 49 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 50 0'
    np me_aal2test_tx_qos_pmcntr 50 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 51 0'
    np me_aal2test_tx_qos_pmcntr 51 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 52 0'
    np me_aal2test_tx_qos_pmcntr 52 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 53 0'
    np me_aal2test_tx_qos_pmcntr 53 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 54 0'
    np me_aal2test_tx_qos_pmcntr 54 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 55 0'
    np me_aal2test_tx_qos_pmcntr 55 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 56 0'
    np me_aal2test_tx_qos_pmcntr 56 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 57 0'
    np me_aal2test_tx_qos_pmcntr 57 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 58 0'
    np me_aal2test_tx_qos_pmcntr 58 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 59 0'
    np me_aal2test_tx_qos_pmcntr 59 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 60 0'
    np me_aal2test_tx_qos_pmcntr 60 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 61 0'
    np me_aal2test_tx_qos_pmcntr 61 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 62 0'
    np me_aal2test_tx_qos_pmcntr 62 0 2>/dev/null
    echo ''
    echo 'np me_aal2test_tx_qos_pmcntr 63 0'
    np me_aal2test_tx_qos_pmcntr 63 0 2>/dev/null
fi

if [ "$np_debug_info" = "yes" ]; then
    echo ''
    echo '**********************************************'
    echo '*                                            *'
    echo '*       uCode debug information              *'
    echo '*                                            *'
    echo '**********************************************'
    echo ''
    echo 'hp scratch_ring_info'
    hp scratch_ring_info 2>/dev/null
fi

if [ "WCDMA" = "$PRODUCT" ]; then
    echo ''
    echo '**********************************************'
    echo '*                                            *'
    echo '*       TLS/CPP counters                     *'
    echo '*       CPP AAL2 paths                       *'
    echo '*                                            *'
    echo '**********************************************'
    echo ''
    objcli tls_show_iubip_cac 2>/dev/null
    objcli tls_show_aal2path 2>/dev/null
    objcli tls_show_aal2s_counter 2>/dev/null
    objcli tls_show_ipcs_counter 2>/dev/null
fi

test_envInfo envInfoEthernetInterfaces > /dev/null 2> /dev/null
NETHIF=$?
if [ $NETHIF -gt 0 ]; then
    echo ''
    echo '**********************************************'
    echo '*                                            *'
    echo '*       Ethernet counters                    *'
    echo '*  EIF1-3 counters cleared every 15 minutes  *'
    echo '*  TOP counters not cleared                  *'
    echo '*                                            *'
    echo '**********************************************'
    echo ''
    test_envInfo envInfoL2SwHwAvailable > /dev/null 2> /dev/null
    OCTETH=$?
    if [ 0 = $OCTETH ]; then
        echo 'ml2counters -n p=EIF1'
        ml2counters -n p=EIF1
        echo ''
        echo 'ml2counters -n p=EIF2'
        ml2counters -n p=EIF2
        echo ''
        echo 'ml2counters -n p=EIF3'
        ml2counters -n p=EIF3
        if [ "FTIB" = "$UNIT" -o "FTLB" = "$UNIT" ]; then
            echo ''
            echo 'ml2counters -n p=TOP'
            ml2counters -n p=TOP
        fi
        if [ "FTLB" = "$UNIT" ]; then
            echo ''
            echo 'ml2counters -n p=OCT0'
            ml2counters -n p=OCT0
            echo ''
            echo 'ml2counters -n p=OCT1'
            ml2counters -n p=OCT1
            echo ''
            echo 'ml2counters -n p=OCT2'
            ml2counters -n p=OCT2
            echo ''
            echo 'ml2counters -n p=OCT3'
            ml2counters -n p=OCT3
        fi 
        echo ''
        echo 'ml2lstat'
        ml2lstat 2>&1
    else
        echo 'OCT> test_octEthIf -c -x -i EIF1'
        rsh 192.168.255.97 "LD_LIBRARY_PATH=/usr/local/lib /usr/local/bin/test_octEthIf -c -x -i EIF1"
        echo ''
        echo 'OCT> test_octEthIf -c -x -i EIF2'
        rsh 192.168.255.97 "LD_LIBRARY_PATH=/usr/local/lib /usr/local/bin/test_octEthIf -c -x -i EIF2"
        echo ''
        echo 'OCT> test_octEthIf -c -x -i EIF3'
        rsh 192.168.255.97 "LD_LIBRARY_PATH=/usr/local/lib /usr/local/bin/test_octEthIf -c -x -i EIF3"
    fi
fi

# If optional argument is given, then dump the np tables
# this is done this way, because this script is called twice, because of the counters
# but the np tables are necessary to be dumped only once
if [ "$np_tables" = "yes" ]; then
  if [ "LTE_WMP" = "$PRODUCT" -o "LTE_DCM" = "$PRODUCT" ]; then
    echo ''
    echo '**********************************************'
    echo '*                                            *'
    echo '*     Ucode configuration and TEID table     *'
    echo '*                                            *'
    echo '**********************************************'
    echo ''
    np me_ltetest_show_config 2>/dev/null
  fi
  if [ "WCDMA" = "$PRODUCT" ]; then
    echo ''
    echo '**********************************************'
    echo '*                                            *'
    echo '*       AAL2 and AAL5 connections            *'
    echo '*                                            *'
    echo '**********************************************'
    echo ''
    echo 'np me_aal5_aal2_and_tm41_showAll_Connections'
    np me_aal5_aal2_and_tm41_showAll_Connections 2>/dev/null
    echo ''
    echo 'np me_iubiptest_show_all_connections'
    np me_iubiptest_show_all_connections 2>/dev/null
  fi
fi
echo ''
echo '**********************************************'
echo '*                                            *'
echo '*       Log files                            *'
echo '*                                            *'
echo '**********************************************'
echo ''
echo 'cat /ffs/run/trs_data/active/bist_log.txt'
cat /ffs/run/trs_data/active/bist_log.txt
echo ''
echo 'cat /etc/iproute2/rt_tables'
cat /etc/iproute2/rt_tables
echo ''
echo '**********************************************'
echo '*                                            *'
echo '*       System Interface Blocks              *'
echo '*                                            *'
echo '**********************************************'
if [ "FTOA" = "$UNIT" ]; then
  echo ''
  echo 'Not yet implemented for unit '$UNIT'.'
fi

if [ "FTOA" != "$UNIT" ]; then
  echo ''
  objcli SIB_StatsGet 2>/dev/null
fi

if [ "WCDMA" = "$PRODUCT" ]; then
  echo ''
  echo '**********************************************'
  echo '*                                            *'
  echo '*       LLP register dumps                   *'
  echo '*                                            *'
  echo '**********************************************'
  if [ "FTOA" = "$UNIT" ]; then
    echo ''
    echo 'Not yet implemented for unit '$UNIT'.'
  fi

  if [ "FTOA" != "$UNIT" ]; then
    if [ "FTIB" != "$UNIT" ]; then
      echo ''
      cd /tmp
      objcli regdump_DS1E1F 2>/dev/null
      objcli regdump_RDC 2>/dev/null
      objcli regdump_HIB 2>/dev/null
      objcli regdump_LIB 2>/dev/null
      objcli regdump_SIB 2>/dev/null
      objcli regdump_AAL1 2>/dev/null
      objcli regdump_IMA 2>/dev/null
      echo 'For dumps see LLP_reg_dumps_x.tar.gz!'
    fi
  fi 
fi

echo ''
echo '**********************************************'
echo '*           end of script                    *'
echo '**********************************************'
echo ''

if [ "$np_tables" = "yes" ]; then
    touch ${FTP_DIR}/getCountersReady1
else
    touch ${FTP_DIR}/getCountersReady2
fi
