#!/bin/sh

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

if [ "x${ROOT_DIR}" = "x/tmp/SIM" ]; then
    simulation=1
else
    simulation=0
fi

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${ROOT_DIR}/opt/trs/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

# detect machine (processor) type
MACHINE=$(uname -m)

if [ "$MACHINE" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi

if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

. ${FUNCTIONS}

was_cgi_bin=$(wasCgiBin $SCRIPT_NAME)
if [ $was_cgi_bin -eq 1 ]; then
  sendMessage 0 "Please use the link [ Download TRS Log file -> Basic Log Collection ]" "Unauthorized - Access denied" 6
  exit
fi

if [ $# -eq 1 ]; then
    filename="$1"
else
    filename="FtmLog.tgz"
fi

test_envInfo envInfoUnitType >/dev/null
UNIT=$?

if [ $simulation -ne 0 ]; then
    TMPPATH=${ROOT_DIR}/tmp
else
    TMPPATH=${ROOT_DIR}/ffs/run/logs
fi

collectAndSendBasicLogfiles()
{
  local TMPDIR
  local LOGDOWNLDSTATUS="/tmp/debugLogDownloadStatus"
  touch $LOGDOWNLDSTATUS
  chmod 0644 $LOGDOWNLDSTATUS
  # create a tmp dir especially for the
  TMPDIR=$(mktemp -d ${TMPPATH}/getSettingsTmpDir.XXXXXX)

  # Collect Traces
  ../protected/ukptTraces.sh > "${TMPDIR}/Traces.log"

  # Add extended information
  ../protected/ShowLocalSettings.cgi > "${TMPDIR}/ExtendedSystemInfo.log"

  if [ "armv5teb" = "${MACHINE}" ]; then
      # On Octeon: retrieve remote static log and add to logfile
      test_envInfo envInfoOcteonAvailable >/dev/null
      if [ 0 -eq $? ]; then
          mkdir -p ${ROOT_DIR}/tmp/octLogDir -m 0775 >/dev/null
          mkdir -p ${TMPDIR}/octeonLogs -m 0775 >/dev/null
          ukpt remoteLog >/dev/null
          cp -r ${ROOT_DIR}/tmp/octLogDir/* ${TMPDIR}/octeonLogs >/dev/null
          rm -rf ${ROOT_DIR}/tmp/octLogDir >/dev/null
      fi
  fi

if [ $simulation -ne 0 ]; then
  if [ -s "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ]; then
      cp "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ${TMPDIR} 
  fi
else
  if [ -s "${ROOT_DIR}/ffs/stb/trs_data/active/ConfigurationMigration.log" ]; then
      cp "${ROOT_DIR}/ffs/stb/trs_data/active/ConfigurationMigration.log" ${TMPDIR} 
  fi
  if [ -s "${ROOT_DIR}/ffs/stb/trs_data/passive/ConfigurationMigration.log" ]; then
      cp "${ROOT_DIR}/ffs/stb/trs_data/passive/ConfigurationMigration.log" ${TMPDIR} 
  fi
  if [ -s "${ROOT_DIR}/ffs/run/trs_data/active/TmlParsing.txt" ]; then
      cp "${ROOT_DIR}/ffs/run/trs_data/active/TmlParsing.txt" ${TMPDIR} 
  fi
fi
 
 # bundle the thing
  if [ $# -eq 1 ]; then
      # to file $filename
      tar -c -C ${TMPDIR} . | gzip -c -q > $filename
  else
      # dump to standard out
      tar -c -C ${TMPDIR} . | gzip -c -q
  fi

  rm -rf ${TMPDIR}
  rm -f $LOGDOWNLDSTATUS
}

cat <<EOF
Content-type: application/x-tar-gz
Etag: `date -t 2>/dev/null`
Expires: -1
EOF

cache_control

cat <<EOF
Connection: Keep-Alive 800
Content-Disposition: attachment; filename="$filename"
X-content-type-options: nosniff

EOF

collectAndSendBasicLogfiles ${1+"$@"} </dev/null 2>/dev/null
