#!/bin/sh

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

if [ "x${ROOT_DIR}" = "x/tmp/SIM" ]; then
    simulation=1
else
    simulation=0
fi

export PATH=/bin:/sbin:/usr/bin:/usr/local/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib
LOGDIR=/var/log
BACKTRACE_ACTIVE_FILES=/usr/local/etc/config/bt-*
BACKTRACE_PASSIVE_FILES=/mnt/passive/usr/local/etc/config/bt-*
#LTE1266
UNIT=`/opt/trs/bin/test_envInfo envInfoUnitType | head -1`
if [ $UNIT == "UNIT_FCTA" ]; then
FLAG=`/opt/trs/bin/test_envInfo envInfoIfRP441 | head -1`
if [ $FLAG == "RP441_ENABLE" ]; then
FTP_DIR="/shareTmp/transport/ftp"
else
FTP_DIR="/tmp/ftp"
fi
else
FTP_DIR="/tmp/ftp"
fi

if [ $simulation -ne 0 ]; then
    # SIM env
    ACTIVE_CORE_DIR="${ROOT_DIR}/var/log"
    COREFILE_ACTIVE="${ACTIVE_CORE_DIR}/*core* ${HOME}/*core* /tmp/*core* ${HOME}/memcheck_*.log /tmp/memcheck_*.log ${HOME}/helgrind_*.log /tmp/helgrind_*.log"
else
    COREFILE_ACTIVE=/usr/local/etc/config/core*
fi
COREFILE_PASSIVE=/mnt/passive/usr/local/etc/config/core*

collectExtendedLogfiles ()
{
  # create a tmp dir
  TMPDIR=$(mktemp -d /tmp/extendedSettingsTmpDir.XXXXXX)

  # start SCF snapshot, copy at the end of this function
  # we send this into background because we do not want this script to block
  mkdir -p "${ROOT_DIR}${FTP_DIR}" -m 0775 >/dev/null
  objcli generate_scf >/dev/null &

  OURDIR=$(dirname $0)

  # Dump Counters once
  ${OURDIR}/GetCounters.cgi np_tables np_debug_info | gzip -c -q -1 > ${TMPDIR}/Counters.log.gz 2>/dev/null

  if [ -s /tmp/HIB_reg_dump.txt ]; then
    tar -czf "${TMPDIR}/LLP_reg_dumps_1.tar.gz" /tmp/*_reg_dump.txt
    rm /tmp/*_reg_dump.txt
  fi

  # Collect Traces
  ${OURDIR}/../protected/ukptTraces.sh > ${TMPDIR}/Traces.log

  # Add extended information
  ${OURDIR}/../protected/ShowLocalSettings.cgi > ${TMPDIR}/ExtendedSystemInfo.log

  # Add post-motem informations
  find $LOGDIR -name "*Trace*" -exec cp {} ${TMPDIR} \;

  # add core dumps
  for core_file in $COREFILE_ACTIVE; do
      cp "$core_file" ${TMPDIR}
      rm -f "$core_file"
  done

  # and the passive partition core files
  for core_file in $COREFILE_PASSIVE; do
      cp "$core_file" "${TMPDIR}/passivePartition.$(basename "$core_file")"
      rm -f "$core_file"
  done

  # adding backtrace files
  if [ -n "$(ls --color=no $BACKTRACE_ACTIVE_FILES)" ]; then
      cp -f $BACKTRACE_ACTIVE_FILES ${TMPDIR}
      rm -f $BACKTRACE_ACTIVE_FILES
  fi

  if [ -n "$(ls --color=no $BACKTRACE_PASSIVE_FILES)" ]; then
      cp -f $BACKTRACE_PASSIVE_FILES ${TMPDIR}
      rm -f $BACKTRACE_PASSIVE_FILES
  fi

  # Dump Counters once for the second time, but including the np_tables
  ${OURDIR}/GetCounters.cgi | gzip -c -q -1 >> ${TMPDIR}/Counters.log.gz 2>/dev/null

  if [ -s /tmp/HIB_reg_dump.txt ]; then
    tar -czf ${TMPDIR}/LLP_reg_dumps_2.tar.gz /tmp/*_reg_dump.txt
    rm /tmp/*_reg_dump.txt
  fi

  # On Octeon: retrieve remote static log and add to logfile
  test_envInfo envInfoOcteonAvailable > /dev/null
  if [ 0 -eq $? ]; then
      mkdir -p /tmp/remoteLogDir -m 0775 >/dev/null
      mkdir -p ${TMPDIR}/octeonLogs -m 0775 >/dev/null
      ukpt remoteLog extendedLog >/dev/null
      cp -r /tmp/remoteLogDir/* ${TMPDIR}/octeonLogs >/dev/null
      rm -rf /tmp/remoteLogDir >/dev/null
  fi 

  # copy the post bist log file before making a bundle
  if [ -s ${FTP_DIR}/SelfTest.txt ]; then
    cp ${FTP_DIR}/SelfTest.txt ${TMPDIR}
  fi

  if [ -s /tmp/tftpboot/filx-post_log.txt ]; then
    cp /tmp/tftpboot/filx-post_log.txt ${TMPDIR}
  fi

  for index in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15; do
      if [ -e "${ROOT_DIR}${FTP_DIR}/configDumpReady" ]; then
          cp -f "${ROOT_DIR}${FTP_DIR}/config.xml" ${TMPDIR} >/dev/null
          break
      fi      
      sleep 2
  done

  # RLe: leave this as last one. Otherwise the current traces might miss informations
  # Create Dump file for current settings
  ukpt dump "${TMPDIR}/FtmDump.bin" >/dev/null

  chmod ug+rw -R ${TMPDIR} >/dev/null

  # bundle the thing
  tar -c -C ${TMPDIR} . | gzip -c -q > ${FTP_DIR}/FTM_log_file.tar.gz

  rm -rf ${TMPDIR}
}

collectExtendedLogfiles </dev/null 2>/dev/null
