#!/bin/sh
export PATH=$PATH:/usr/local/bin:/bin:/usr/bin:/usr/sbin:/sbin:/opt/trs/bin/;
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

EXE="ruimUdpClient"
SHA256="sha256"
SED="/usr/bin/sed"
TOK="tokenGenerator"
OPENSSL=`which openssl`
unitIsFsmr3=$(wasFsmr3)
unitIsFzm=$(isFzm)
uintIsFsmr4=$(isFsmr4)
product=$(getProduct)
HOST_LOG_FILE="/etc/auth_log.txt"
TRS_DATA="/ffs/run/trs_data"
TRS_ACTIVE_DATA=$TRS_DATA/active
TMLPARSING_RESULT=$TRS_ACTIVE_DATA/TmlParsing.txt
BANNERTEXT_FILE=$TRS_ACTIVE_DATA/application_banner.txt
if [ $unitIsFsmr3 -eq 1 ] || [ $unitIsFzm -eq 1 ] || [ $uintIsFsmr4 -eq 1 ]; then
  EXEPATH="/opt/trs/bin/"$EXE
  SHAEXE="/opt/trs/bin/"$SHA256
  root_path="/opt/trs/www/html"
else
  EXEPATH="/usr/local/bin/"$EXE
  SHAEXE="/usr/local/bin/"$SHA256
  root_path="/www/html"
fi
if [ "$product" = "LTE_WMP" ] || [ "$product" = "WCDMA" ] && [ $unitIsFsmr3 -eq 1 ]  || [ $uintIsFsmr4 -eq 1 ]; then
  if [ -f $BANNERTEXT_FILE ]; then
     str=$(<$BANNERTEXT_FILE) 
  fi
else
    str="You are about to access a private system. This system is for the use of authorized users only. All connections are logged to the extent and by means acceptable by the local legislation. Any unauthorized access or access attempts may be punished to the fullest extent possible under the applicable local legislation."
fi
remote_user=$REMOTE_USER
query_string=$QUERY_STRING
request_uri=$REQUEST_URI
http_auth_info="$HTTP_AUTHORIZATION"
fileType=`echo $query_string|cut -d '=' -f2`
encryptedCred=`echo $http_auth_info|cut -d ' ' -f2|grep -v -e '[^A-Za-z0-9+\/=]'`
decryptedCred=`echo $encryptedCred|base64 -d`
userName=`echo $decryptedCred|cut -d ':' -f1`
password=`echo $decryptedCred|cut -d ':' -f2`
urandomString=`echo "$(head /dev/urandom | tr -dc A-Za-z0-9 | head -c10)"`
auth_file=/tmp/auth_
export REMOTE_USER=$userName
ip_addr=$SERVER_NAME
isOldValues="0"
oldTimestamp=""
oldToken=""
oldFileName=""
POST_DATA=""
sessionId=""
loginencryptedCred=""
newSessionId=""
session_file=/tmp/session_

parse_query_string ()
{
    declare -a RECV_QUERY_STRING=`echo $1 | cut -d '?' -f2 | sed 's/&/ /g'`
    for element in ${RECV_QUERY_STRING[@]}; do
         name=$( echo $element|cut -d= -f1 )
         value=$( echo $element|cut -d= -f2 )
         if [ $name = "stamp" ]; then
            oldTimestamp=$value
         elif [ $name = "token" ]; then
            oldToken=$value
            if [ ! -z "$userName" ]; then
                touch /tmp/user_name.txt
                chmod 664 /tmp/user_name.txt
                echo $userName > /tmp/user_name.txt
            fi
         elif [ $name = "frame" ]; then
            oldFileName=$value
         elif [ $name = "EncodedCreds" ]; then
            loginencryptedCred=$value
            decryptedCredForRemoteUser=`echo $loginencryptedCred|base64 -d`
            userNameForRemoteUser=`echo $decryptedCredForRemoteUser|cut -d ':' -f1`
            if [ ! -z "$userNameForRemoteUser" ]; then
                touch /tmp/user_name.txt
                chmod 664 /tmp/user_name.txt
                echo $userNameForRemoteUser > /tmp/user_name.txt
            fi
         elif [ $name = "FTMSession" ]; then
            sessionId=$value
         fi
    done
}

get_session_id ()
{
    declare -a RECV_COOKIE_STRING=`echo $1 | sed 's/;/ /g'`
    declare -a RECV_COOKIE_STRING2=`echo $2 | sed 's/;/ /g'`
    flag=0;
    for element in ${RECV_COOKIE_STRING[@]}; do
         name=$( echo $element|cut -d= -f1 )
         value=$( echo $element|cut -d= -f2 )
         if [ $name = "FTMSession" ]; then
            sessionId=$value
            flag=1
         fi
    done
    if [ $flag -eq  0 ]; then
        for element in ${RECV_COOKIE_STRING2[@]}; do
            name=$( echo $element|cut -d= -f1 )
            value=$( echo $element|cut -d= -f2 )
            if [ $name = "FTMSession" ]; then
               sessionId=$value
               flag=1
            fi
        done
    fi

}

POST_DATA=$(</dev/stdin)

echo $request_uri | grep -Fq "?"
if [ $? = "0" ]; then
 parse_query_string "$request_uri"
elif ! [ -z $POST_DATA ]; then
  parse_query_string $POST_DATA
fi

remoteIp=$REMOTE_ADDR

CCS_DIR="/opt/CCS"
TRSW_LBT1698_ENABLED="0x1A0077"
TRSW_LTE2486_ENABLED="0x1A0078"
CCS_CONFIG_FILE="/ffs/run/swconfig.txt"
ENABLE_CSRF="1"
ENABLE_2486="1"
filename11=`echo $request_uri|cut -d '/' -f3`
filename=`echo $filename11|cut -d '?' -f1`
filename1=`echo $filename|cut -d '.' -f1`
timestamp=`date +%s`

if [ "$product" = "LTE_WMP" ] ||  [ "$product" = "WCDMA" ] && [ $unitIsFsmr3 -eq 1 ] || [ $uintIsFsmr4 -eq 1 ] || [ $unitIsFzm -eq 1 ] ; then
  value=`${CCS_DIR}/evaluateRadParam $TRSW_LTE2486_ENABLED $CCS_CONFIG_FILE`
  if [ -f $CCS_CONFIG_FILE -a $value == "0x00000000" ]; then
    ENABLE_2486="0"
  fi
else
  ENABLE_2486="0"
fi


value=`${CCS_DIR}/evaluateRadParam $TRSW_LBT1698_ENABLED $CCS_CONFIG_FILE`
if [ -f $CCS_CONFIG_FILE -a $value == "0x00000000" ]; then
  ENABLE_CSRF="0"
fi

istok="0"
grep -Fq "********" $root_path$request_uri
if [ $? = "0" ]; then
  istok=1
fi

if [ $ENABLE_2486 = "1" ]; then
  if [ $unitIsFsmr3 -eq 1 ]; then
    loginencryptedCred=`echo $loginencryptedCred | sed 's/%\([0-9A-F][0-9A-F]\)/\\\x\1/g' | xargs echo -e`
  else
    loginencryptedCred=$(echo "$loginencryptedCred" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e)
  fi
fi

if [ ! -z $oldTimestamp -o ! -z $oldFileName ]; then
  isOldValues="1"
fi

if [ $filename = "index.cgi" ]; then
   sh $root_path$request_uri
   exit
fi

if [ $ENABLE_2486 = "0" ]; then
  tokenstring=`echo "$filename1$remoteIp$timestamp$encryptedCred"`
  token=`$SHAEXE $tokenstring 0`
else
  get_session_id $HTTP_COOKIE
  if [ $filename1 = "login" -a $fileType = "cgi" ]; then
    sessionIdstring=`echo $urandomString`
    newSessionId=`$SHAEXE $sessionIdstring 1`
    tokenstring=`echo "$filename1$remoteIp$timestamp$newSessionId"`
    token=`$SHAEXE $tokenstring 0`
  else
    tokenstring=`echo "$filename1$remoteIp$timestamp$sessionId"`
    token=`$SHAEXE $tokenstring 0`
  fi
fi

if [ $ENABLE_2486 = "0" ]; then
  #Checking if encrypted credentials is empty
  if [ -z $encryptedCred ]; then
    echo "Content-type: text/plain"
    echo "Status: 401"
    echo  "WWW-authenticate: Basic realm=$str"
    echo ""
    exit
  fi
elif [[ -z $sessionId ]]; then
  if [ $filename = "login.cgi" ]; then
    if [[ -z $loginencryptedCred ]]; then
cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
      exit
    fi
  elif [ $filename != "login.cgi" -a $filename != "index.html" -a $filename != "sessionInvalid.html" -a $filename != "login.html" ]; then

cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
    exit
  fi
fi


if [ $fileType = "cgi" ]; then
  req_type="0"
  rand=$RANDOM

  if [ $ENABLE_2486 = "0" ]; then
    echo $encryptedCred >  $auth_file$rand
  else
    req_type="1"
    echo $sessionId > $session_file$rand

    if [ $filename1 = "login" ]; then
      if [[ -z $sessionId ]]; then
        echo $loginencryptedCred > $auth_file$rand
        echo $newSessionId > $session_file$rand
        req_type="2"
      fi
    fi
  fi

  if [ $ENABLE_CSRF = "0" ];then
    if [ $ENABLE_2486 = "0" -o $req_type = "2" ]; then
      out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp )
    else
      out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp )
    fi
  else
    if [ $filename1 = "activeNavigation" -o $filename1 = "TmlParsing" -o $filename1 = "login" -o $filename1 = "portNetworkAccessSecurity" -o $filename1 = "portNetworkAccessSecurityLogLevel" ]; then
      if [ $ENABLE_2486 = "0" -o $req_type = "2" ]; then
        out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $filename1 $timestamp $token )
      else
        out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $filename1 $timestamp $token )
      fi
    elif [ $filename1 = "portMirrorringInput" -o $filename1 = "portMirrorringStatus" ]; then
      if [ $ENABLE_2486 = "0" ]; then
        out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $filename1 $timestamp $token )
      else
        out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $filename1 $timestamp $token )
      fi
    else
          filename1=$oldFileName
          timestamp=$oldTimestamp
          token=$oldToken
          out=$( $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $oldFileName $oldTimestamp $oldToken )
    fi
  fi
  output=$?
  #parsing last login info
  lastLoginInfo_col="$out"
  lastLoginInfo=`echo "$lastLoginInfo_col" | sed -e 's/\:/-/g'`
  neFailedAttempt=`echo "$lastLoginInfo" | cut -d',' -f2`
  neSuccessAttempt=`echo "$lastLoginInfo" | cut -d',' -f3`
  cnumFailedAttempt=`echo $lastLoginInfo | cut -d',' -f4`
  cnumSuccessAttempt=`echo $lastLoginInfo | cut -d',' -f5`
  lastLoginInfoMsg="$neFailedAttempt \r $neSuccessAttempt \r $cnumFailedAttempt \r $cnumSuccessAttempt"

  if [ $req_type = "0" -o $req_type = "2" ]; then
    rm -f $auth_file$rand
  fi

  if [ $req_type = "1" -o $req_type = "2" ]; then
    rm -f $session_file$rand
  fi

  if [ $output = "2" -o $output -eq 9 ]; then
    if [ $ENABLE_2486 = "1" ]; then
      if [ $filename1 = "login" ]; then
        if [ $output -eq 9 ]; then
        warningOrGrace=`echo $out|cut -d ',' -f1`
	    if [ $warningOrGrace -gt 0 ]; then
            days=$[$warningOrGrace]
            if [ $days -eq 1 ];then
               passwdAlert="Your password will expire today. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct."
            else
               passwdAlert="Your password will expire in $[$days-1] days. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct."
            fi
          # negative out means that password has expired and grace logins are left
          elif [ $warningOrGrace -le 0 ]; then
            attempts=$[0 - $warningOrGrace]
            passwdAlert="Your password has expired and you have $attempts grace logins left. Contact your network security administrator to get the password changed."
          fi
        fi
      elif [ $filename1 = "logout" ]; then
cat <<EOF
Content-type: text/html
Set-Cookie: FTMSession=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; Max-Age=-1448947917; domain=$HTTP_HOST; path=/; secure; httponly
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
        exit
      fi
    fi
    message="$lastLoginInfoMsg \r $passwdAlert"
    request_prog_name=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f 1`
    QUERY_STRING=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f2`
    if [ $istok = "1" -a $ENABLE_CSRF = "1" ]; then
        if [ -z $POST_DATA ]; then
           sh $root_path$request_prog_name $timestamp $token $filename1
        else
           if [ $ENABLE_2486 = "1" -a $filename1 = "login" ]; then
             sh $root_path$request_prog_name $POST_DATA $output
           else
             sh $root_path$request_prog_name $POST_DATA
           fi
        fi
    else
        if [ $ENABLE_2486 = "1" -a $filename1 = "login" ]; then
          sh $root_path$request_prog_name $POST_DATA $output $newSessionId $HTTP_HOST "$message"
        else
          sh  $root_path$request_prog_name $POST_DATA
        fi
    fi
     if [ $output -eq 9 -a $filename1 = "activeNavigation" -a $ENABLE_2486 = "0" ]; then
    # out greater than 0 means that password is about to expire

      out=echo $out | cut -d',' -f1

      if [ $out -gt 0 ];then
          days=$[$out]
          if [ $days -eq 1 ];then
             echo "<script>alert('Your password will expire today. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.')</script>"
          else
              echo "<script>alert('Your password will expire in $[$days-1] days. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.')</script>"
          fi
    # negative out means that password has expired and grace logins are left
        elif [ $out -le 0 ]; then
            attempts=$[0 - $out]
            echo "<script>alert('Your password has expired and you have $attempts grace logins left. Contact your network security administrator to get the password changed.')</script>"
        fi
      fi
  elif [ $ENABLE_2486 = "1" -a $output = "22" ]; then
    request_prog_name="protected/sessionInvalid.html"
cat <<EOF
Content-type: text/html
Set-Cookie: FTMSession=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; Max-Age=-1448947917; domain=$HTTP_HOST; path=/; secure; httponly
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/$request_prog_name
Connection: keep-alive

EOF
  elif [ $ENABLE_2486 = "1" -a $filename1 = "logout" ]; then
     if [ $output = "16" -o $output = "17" -o $output = "18" -o $output -eq "24" ]; then
cat <<EOF
Content-type: text/html
Set-Cookie: FTMSession=deleted;expires=Thu, 01-Jan-1970 00:00:01 GMT; Max-Age=-1448947917; domain=$HTTP_HOST; path=/; secure; httponly
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
     fi
  elif [ $ENABLE_2486 = "1" -a $output = "6" ]; then
    request_prog_name=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f 1`
    QUERY_STRING=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f2`
    sh $root_path$request_prog_name $POST_DATA $output $newSessionId $HTTP_HOST "$message"
  elif [ $ENABLE_2486 = "1" -a $output = "10" -a $filename1 = "login" ]; then
    request_prog_name="/protected/login.cgi"
    sh $root_path$request_prog_name $POST_DATA $output
  elif [ $ENABLE_2486 = "1" -a $output = "23" ]; then
    echo "<script>alert('Could not create session, max session limit is reached.')</script>"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
  elif [ $output = "3" -o $output = "5" ]; then
    if ls /lte1460/portMirroringTmp.zip* >/dev/null 2>&1; then
        if [ $filename1 = "portMirrorringInput" ]; then
            request_prog_name=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f 1`
            QUERY_STRING=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f2`
            sh  $root_path$request_prog_name $POST_DATA
        else
	    if [ -f /tmp/user_name.txt ]; then
	        export REMOTE_USER=`cat /tmp/user_name.txt`
	    fi
	    /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 160 > /dev/null
            request_prog_name="/protected/tokenInvalid.html"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
            cat $root_path$request_prog_name
        fi
    else
        if [ -f /tmp/user_name.txt ]; then
            export REMOTE_USER=`cat /tmp/user_name.txt`
        fi
	/opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 160 > /dev/null
        request_prog_name="/protected/tokenInvalid.html"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
        cat $root_path$request_prog_name
    fi
  #the permission code 18 returned from ruimUdpClient when the user is a Read_Only CNUM user
  #we call readOnlyActiveNavigation.cgi with the restricted options for Read_Only user
  #this condition will only be executed for read only users
  #for Read_Write CNUM user and local user, the exisitng page/options will be displayed
  elif [ $output -eq 18 -o $output -eq 21  -o $output -eq 16 -o $output -eq 17 -o $output -eq 24 ]; then
   if [ $filename1 = "login" -a $ENABLE_2486 = "1" ]; then
        warningOrGrace=`echo $out|cut -d ',' -f1`
	    if [ $warningOrGrace -gt 0 ]; then
            days=$[$warningOrGrace]
            if [ $days -eq 1 ];then
               passwdAlert="Your password will expire today. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct."
            else
               passwdAlert="Your password will expire in $[$days-1] days. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct."
            fi
          # negative out means that password has expired and grace logins are left
          elif [ $warningOrGrace -le 0 ]; then
            attempts=$[0 - $warningOrGrace]
            passwdAlert="Your password has expired and you have $attempts grace logins left. Contact your network security administrator to get the password changed."
          fi
   message="$lastLoginInfoMsg \r $passwdAlert"
   read_only_user=1
     request_prog_name="/protected/login.cgi"
     sh  $root_path$request_prog_name $POST_DATA $output $newSessionId $HTTP_HOST "$message" $read_only_user
   elif [ $output -eq 18 -a $filename1 = "activeNavigation" ]; then
     isRemoteUser=1
     request_prog_name="/protected/readOnlyActiveNavigation.cgi"
     sh  $root_path$request_prog_name $POST_DATA $isRemoteUser
   elif [ $output -eq 24 -a $filename1 = "activeNavigation" ]; then
     request_prog_name="/protected/readOnlyActiveNavigation.cgi"
     sh  $root_path$request_prog_name $POST_DATA
   elif [ $output -eq 16 -a $filename1 = "activeNavigation" ]; then
     request_prog_name="/protected/secAdminActiveNavigation.cgi"
     sh  $root_path$request_prog_name $POST_DATA
   elif [ $output -eq 17 -a $filename1 = "activeNavigation" ]; then
     request_prog_name="/protected/appAdminActiveNavigation.cgi"
     sh  $root_path$request_prog_name $POST_DATA
   else
     request_prog_name=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f 1`
     QUERY_STRING=`echo $request_uri | sed -e 's/\?/ /g' | cut -d ' ' -f2`
     if [ -z $POST_DATA ]; then
       sh $root_path$request_prog_name $timestamp $token $filename1
     else
       sh $root_path$request_prog_name $POST_DATA
     fi
   fi

   if [ \( $ENABLE_2486 = "0" -a $output -eq 21 -a $filename1 = "activeNavigation" \) -o \( $ENABLE_2486 = "1" -a $output -eq 21 -a $filename1 = "login" \) ]; then
    # out greater than 0 means that password is about to expire
        if [ $out -gt 0 ];then
          days=$[$out]
          if [ $days -eq 1 ];then
              echo "<script>alert('Your password will expire today. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.')</script>"
          else
              echo "<script>alert('Your password will expire in $[$days-1] days. Contact your network security administrator to get the password changed.Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.')</script>"
          fi
    # negative out means that password has expired and grace logins are left
        elif [ $out -le 0 ]; then
            attempts=$[0 - $out]
            echo "<script>alert('Your password has expired and you have $attempts grace logins left. Contact your network security administrator to get the password changed.')</script>"
        fi
    fi
  elif [ $ENABLE_2486 = "1" -a $output -eq "8" ]; then
    echo "<script>alert('Access denied due to pending login delay.')</script>"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
  elif [ $ENABLE_2486 = "1" -a $output -eq "7" ]; then
    echo "<script>alert('Your password has expired. Contact your network security administrator to get the password changed. Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.')</script>"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
  elif [ $ENABLE_2486 = "1" -a $output -eq "12" ]; then
    echo "<script>alert('No role fetched for this CNUM account!')</script>"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
  else
    if [ $ENABLE_2486 = "0" ]; then
      echo "Content-type: text/plain"
      echo "Status: 401"
      echo  "WWW-authenticate: Basic realm=$str"
      echo ""
      exit
    else
      if [ $filename1 = "login" ]; then
        sh $root_path$request_prog_name $POST_DATA $output
        exit
      fi
cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
    fi
  fi
elif [ $fileType = "html" ]; then
  req_type="0"
  rand=$RANDOM

  if [ $ENABLE_2486 = "0" ]; then
    echo $encryptedCred > $auth_file$rand
  else
    if [[ -z $sessionId ]]; then
      if [ $filename1 = "index" -o $filename1 = "sessionInvalid" -o $filename1 = "login" ]; then
cat <<EOF
Connection: Close
Content-type: text/html

EOF
		cat $root_path$request_uri
        exit
      else
cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
      fi
    else
      req_type="1"
      echo $sessionId > $session_file$rand
    fi
  fi

  if [ $ENABLE_CSRF = "0" ];then
    $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp
  else
    if [ $isOldValues = "0" ]; then
       $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $filename1 $timestamp $token
    else
       $EXEPATH $request_uri $req_type $rand $ENABLE_CSRF $remoteIp $oldFileName $oldTimestamp $oldToken
    fi
  fi
  output=$?
  if [ $output = "18" -o $output = "16" -o $output = "17" -o $output -eq "24" ]; then
    output=2
  fi

  if [ $req_type = "0" ]; then
    rm -f $auth_file$rand
  fi
  if [ $req_type = "1" ]; then
    rm -f $session_file$rand
  fi

  if [ $output = "2" -o $output -eq 9 -o $output -eq 21 ]; then
     if [ $filename1 = "index" ]; then
	  if [ $req_type = "0" -o $req_type = "1" ]; then
              request_uri="/protected/default.html"
          fi
     fi

cat <<EOF
Connection: Close
Content-type: text/html; charset=iso-8859-1

EOF
    if [ $ENABLE_CSRF = "1" -a $istok = "1" ]; then
      sed -e "s/########/$timestamp/g" -e "s/\*\*\*\*\*\*\*\*/$token/g" -e "s/$%$%$%$%/$filename1/g" $root_path$request_uri
    else
      cat $root_path$request_uri
    fi
  elif [ $ENABLE_2486 = "1" -a $output = "22" ]; then
    request_prog_name="protected/sessionInvalid.html"
cat <<EOF
Content-type: text/html
Set-Cookie: FTMSession=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT; Max-Age=-1448947917; domain=$HTTP_HOST; path=/; secure; httponly
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/$request_prog_name
Connection: keep-alive

EOF
  elif [ $output = "3" -o $output = "5" ]; then
    if ls /lte1460/portMirroringTmp.zip* >/dev/null 2>&1; then
        if [ $filename1 = "portMirrorringInput" ]; then
            cat $root_path$request_uri
        else
	    if [ -f /tmp/user_name.txt ]; then
		export REMOTE_USER=`cat /tmp/user_name.txt`
	    fi
	    /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 160 > /dev/null
            request_prog_name="/protected/tokenInvalid.html"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
            cat $root_path$request_prog_name
        fi
    else
        if [ -f /tmp/user_name.txt ]; then
	    export REMOTE_USER=`cat /tmp/user_name.txt`
        fi
	/opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 160 > /dev/null
        request_prog_name="/protected/tokenInvalid.html"
cat <<EOF
Connection: Close
Content-type: text/html

EOF
        cat $root_path$request_prog_name
    fi
  elif [ $output = "7" ]; then
    echo "Content-type: text/plain"
    echo "Status: 401"
    echo  "WWW-authenticate: Basic realm=\"Your password has expired. Contact your network security administrator to get the password changed. Note that BTS local password can be changed by BTS Site Manager but this is not recommended in networks controlled by NetAct.\""
    echo ""
    exit

  elif [ $output = "8" ]; then
    echo "Content-type: text/plain"
    echo "Status: 401"
    echo  "WWW-authenticate: Basic realm=\" ACCESS DENIED DUE TO PENDING LOGIN DELAY.... .\""
    echo ""
    exit

elif [ $output = "10" ]; then
    echo "Content-type: text/plain"
    echo "Status: 401"
    echo  "WWW-authenticate: Basic realm=\"BTS local user account is blocked.\""
    echo ""
    exit

  else
    if [ $ENABLE_2486 = "0" ]; then
      echo "Content-type: text/plain"
      echo "Status: 401"
      echo  "WWW-authenticate: Basic realm=$str"
      echo ""
      exit
    else
cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/protected/recoverInvalid.html
Connection: keep-alive

EOF
    fi
  fi
elif [ $fileType = "data" ]; then

   request_prog_name=$TMLPARSING_RESULT

cat <<EOF
Connection: Close
Content-type: text/html

EOF
    cat $request_prog_name

else
  if [ $ENABLE_2486 = "0" ]; then
    echo "Content-type: text/plain"
    echo "Status: 401"
    echo  "WWW-authenticate: Basic realm=$str"
    echo ""
    exit
  else
cat <<EOF
Content-type: text/html
Content-Length: 0
Status: 302 Found
Location: https://$HTTP_HOST/
Connection: keep-alive

EOF
  fi
fi
