#!/bin/sh

TMPPREFIX="extendedSettingsTmpDir"
GLOBALTMP=""

DIR_PATH=/ffs/run/logs

TIMESTAMP_FILE=`date "+%Y%m%d_%H%M"`
TIMESTAMP_LOG=`date "+%Y%m%d-%H:%M:%S"`
FILENAME="$DIR_PATH/Debug_${TIMESTAMP_FILE}_Failure.txt"
FPGA_FILEPATH="/dev/ddal/fpga/fpga_id5"
SYNCETH_FILEPATH="/dev/ddal/sync_eth/board5_0"

cp -f ${DIR_PATH}/*Failure.txt /tmp/

echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering Log Collection script: CollectExtendedLogs.cgi" >> ${FILENAME}
chmod 0644 ${FILENAME}
umask 002

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

if [ "x${ROOT_DIR}" = "x/tmp/SIM" ]; then
    simulation=1
else
    simulation=0
fi

if [ -d "/sdm_selected" ]; then
    RUN_DIR="${ROOT_DIR}/tmp"
    START_SCRIPT="${ROOT_DIR}/sdm_selected/start_script.conf"
else
    RUN_DIR="${ROOT_DIR}/ffs/run"
    STB_DIR="${ROOT_DIR}/ffs/stb"
    START_SCRIPT="${RUN_DIR}/trs_data/sim/start_script.conf"
fi

TRSCRASHLOG="${RUN_DIR}/logs/TRSCrashLogs.tgz"
EMTRSCRASHLOG="${RUN_DIR}/logs/EmTRSCrashLogs.tgz"

OPT_DIR="/opt/trs"
CCS_DIR="/opt/CCS"

TRS_BIN_DEST="${OPT_DIR}/bin"
TRS_LIB_DEST="${OPT_DIR}/lib64"

PROGRAM_ENVINFO="${TRS_BIN_DEST}/test_envInfo"

PROG_FASTPATHCONFIG="${TRS_BIN_DEST}/FPCiTest"
PROG_FPDEBUGACESS="${TRS_BIN_DEST}/fpdebugAccess"
PROG_DDAL_TEST_TOOL="${TRS_BIN_DEST}/ddal_test_tool"
LLPD="${TRS_BIN_DEST}/llpd"

if [ -f "/tmp/portMirrorringMemFailed" ]; then
    TRS_TRAFCMIRR_MEMALLOC_STATUS="/tmp/portMirrorringMemFailed"
else
    TRS_TRAFCMIRR_MEMALLOC_STATUS="/tmp/portMirrorringMemAllocated"
fi

VARLOGDIR=/var/log
TRSBOOTUPTCPDUMP="${VARLOGDIR}/eNB_boot_tcpdump.pcap"
OPT_PROTECTED="/opt/trs/www/html/protected"

# Signal handler function: removes temporary directory in case of
# premature termination of the script

onDie()
{
   echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}; Premature termination of the script" >> ${FILENAME}
    if [ -n "${GLOBALTMP}" ]
        then
        if [ ! -f "$filename" ]; then
             tar -c -C ${TMPDIR} . | gzip -c -q > $filename
        fi
        rm -rf  ${GLOBALTMP}
    fi
    rmdir $LOCKFILEDIR 2>&1
    exit 0;
}

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${ROOT_DIR}/opt/trs/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

# detect machine (processor) type
MACHINE=$(uname -m)

if [ "$MACHINE" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi


if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

#LTE1266
UNIT=`test_envInfo envInfoUnitType | head -1`
if [ $UNIT == "UNIT_FCTA" ]; then
    FLAG=`test_envInfo envInfoIfRP441 | head -1`
    if [ $FLAG == "RP441_ENABLE" ]; then
        FTP_DIR="/shareTmp/transport/ftp"
    else
        FTP_DIR="/tmp/ftp"
    fi
else
    FTP_DIR="/tmp/ftp"
fi

. ${FUNCTIONS}

[ -f "${START_SCRIPT}" ] && . "${START_SCRIPT}"

test_envInfo envInfoUnitType >/dev/null
UNIT=$?

if [ $simulation -ne 0 ]; then
    ACTIVE_CORE_DIR="${ROOT_DIR}/var/log"
    LOGDIR=${ROOT_DIR}/var/log
    STBLOGDIR=${ROOT_DIR}/ffs/stb/logs
else
    ACTIVE_CORE_DIR="${RUN_DIR}/logs"
    LOGDIR=${RUN_DIR}/logs
fi

chassis_slot=`head -c 8 "/proc/device-tree/soc-identity/chassis-slot-number"`

TMPPATH=${ROOT_DIR}/tmp

PASSIVE_CORE_DIR=${ROOT_DIR}/tmp/passCfg

if [ $simulation -ne 0 ]; then
    # SIM env
    COREFILE_ACTIVE="${ACTIVE_CORE_DIR}/*core* ${HOME}/*core* /tmp/*core* ${HOME}/memcheck_*.log /tmp/memcheck_*.log ${HOME}/helgrind_*.log /tmp/helgrind_*.log"
else
    COREFILE_ACTIVE="${ACTIVE_CORE_DIR}/core* ${ACTIVE_CORE_DIR}/../*core* ${ACTIVE_CORE_DIR}/${chassis_slot}/A/dumps/ /var/tmp/core* /var/tmp/diagn/core* /var/diagn/core*"
fi

COREFILE_PASSIVE=${PASSIVE_CORE_DIR}/core*

BACKTRACE_ACTIVE_FILES="${ACTIVE_CORE_DIR}/bt-* /var/tmp/diagn/bt-*"
BACKTRACE_PASSIVE_FILES="${PASSIVE_CORE_DIR}/bt-*"

was_cgi_bin=$(wasCgiBin $SCRIPT_NAME)

if [ $was_cgi_bin -eq 1 ]; then
    sendMessage 0 "Please use the link [ Download TRS Log file -> Enhanced Log Collection ]" "Unauthorized - Access denied" 6
    exit
fi

if [ $# -eq 1 ]; then
    filename="$1"
else
    filename="ExtendedFtmLog.tgz"
fi

collect_fp_qos_logs_to_a_file()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    #Get QoS FastPath debug data to log file.
    #call required debug functions.
    echo "*********************************" > "${TMPDIR}/fp_qos_logs.txt"
    echo "*** QoS : FastPath Debug logs ***" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "*********************************" >> "${TMPDIR}/fp_qos_logs.txt"
    echo " " >> "${TMPDIR}/fp_qos_logs.txt"

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_cfg_dbg ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_cfg_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_cfg_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_cfg_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_port_dbg for port-index: 1 ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_port_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_port_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_port_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_path_dbg_table for port-index: 1 ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_path_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_path_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_path_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_if_grp_dbg ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_if_grp_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_if_grp_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_if_grp_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###  iptest_qos_if_shldrid_dbg for if-index: 9  ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_if_shldrid_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_if_shldrid_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_if_shldrid_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_ip_discard_counters_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "###################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_ip_discard_counters_table.txt" ]; then
        cat /tmp/ipgw_qos_ip_discard_counters_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_ip_discard_counters_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_dscp_phb_dp_dbg_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_dscp_phb_dp_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "########################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_dscp_to_vlan_prio_mapping_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "########################################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt" ]; then
        cat /tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_dscp_to_vlan_prio_mapping_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    echo " " >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "### ipgw_qos_flow_clfr_dbg_table ###" >> "${TMPDIR}/fp_qos_logs.txt"
    echo "############################################" >> "${TMPDIR}/fp_qos_logs.txt"
    if [ -f "/tmp/ipgw_qos_flow_clfr_dbg_table.txt" ]; then
        cat /tmp/ipgw_qos_flow_clfr_dbg_table.txt >> "${TMPDIR}/fp_qos_logs.txt"
    else
        echo "File /tmp/ipgw_qos_flow_clfr_dbg_table.txt does not exist" >> "${TMPDIR}/fp_qos_logs.txt"
    fi

    #Done with dumping QoS FP debug data. Delete the temporary log files.
    rm -f /tmp/ipgw_qos_*_table.txt > /dev/null
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_fpapp_logs_to_a_file()
{

    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]};Copy TRS fpapp Log to TMPDIR" >> ${FILENAME}
    # Copy TRS fpapp Log to TMPDIR
    fpctrl print dlog | grep "TRS::FPAPP" > "/tmp/trs_fpapp.log"
    /opt/trs/bin/FpAppCfgDump
    if [ -f /tmp/lte_syscom_iwf_ul_connection_dump_table.txt ]; then
        cp /tmp/lte_syscom_iwf_ul_connection_dump_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_iwf_dl_connection_dump_table.txt ]; then
        cp /tmp/lte_syscom_iwf_dl_connection_dump_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/gtpu_mgmt_err_ind_table.txt ]; then
        cp /tmp/gtpu_mgmt_err_ind_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_iwf_config_table.txt ]; then
        cp /tmp/lte_syscom_iwf_config_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_application_ip_table.txt ]; then
        cp /tmp/lte_syscom_application_ip_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/l3l4_classifier_table.txt ]; then
        cp /tmp/l3l4_classifier_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/ipgw_iptest_show_interfaces_table.txt ]; then
        cp /tmp/ipgw_iptest_show_interfaces_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_mcast_iwf_dl_table.txt ]; then
        cp /tmp/lte_mcast_iwf_dl_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_fpb_config_table.txt ]; then
        cp /tmp/lte_fpb_config_table.txt ${TMPDIR}/
    fi
    if [ -f /tmp/lte_syscom_iwf_mcast_dl_connection_dump_table.txt ]; then
        cp /tmp/lte_syscom_iwf_mcast_dl_connection_dump_table.txt ${TMPDIR}/
    fi
    cp /tmp/trs_fpapp.log ${TMPDIR}/
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_fpctrl_package_logs()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Collect fpctrl package logs. Logs are generated in /ffs/run/logs/
    fpctrl pkg-trs

    # Move file to TMPDIR for collection
    cp /ffs/run/logs/netfp_logs.tgz ${TMPDIR}/ > /dev/null

    # Delete generated file after copying
    rm -f /ffs/run/logs/netfp_logs.tgz > /dev/null
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}

}

#Generate objcli gtpcounter values and move it to snapshot file
collect_r3gtp_counters()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate gtp counter values
    ${LLPD} /opt/trs/bin/objcli tls_show_r3gtp_counter > /tmp/r3gtp_counters.txt

    # Move file to TMPDIR for collection
    if [ -f /tmp/r3gtp_counters.txt ]; then
       cp /tmp/r3gtp_counters.txt ${TMPDIR}/ > /dev/null
    fi

     # Delete generated file after copying
     rm -f /tmp/r3gtp_counters.txt > /dev/null
     echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_bcmswitch_stats_logs()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    ethswitch > /tmp/bcmswitch_config.txt
    # Move file to TMPDIR for collection
    if [ -f /tmp/bcmswitch_config.txt ]; then
       cp /tmp/bcmswitch_config.txt ${TMPDIR}/ > /dev/null
    fi

     # Delete generated file after copying
     rm -f /tmp/bcmswitch_config.txt > /dev/null
     echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_wpa_supplicant_logs()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> "${TMPDIR}/ExtendedSystemInfo.log"
    echo "WPA SUPPLICANT CONFIGURATION FILE" >> "${TMPDIR}/ExtendedSystemInfo.log"

    if [ -f "/etc/wpa_supplicant/wpa_supplicant-wired-br0.conf" ] ; then
        cat /etc/wpa_supplicant/wpa_supplicant-wired-br0.conf >> "${TMPDIR}/ExtendedSystemInfo.log"
    fi

    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> "${TMPDIR}/ExtendedSystemInfo.log"
}

#Generate objcli r4 counter values, debug info and move it to snapshot file
collect_r4gtp_counters()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate gtp counter values
    ${LLPD} /opt/trs/bin/objcli tls_show_r4gtp_counters > /tmp/r4_IpcsDebugInfo.txt

    # Move file to TMPDIR for collection
    if [ -f /tmp/r4_IpcsDebugInfo.txt ]; then
       cp /tmp/r4_IpcsDebugInfo.txt ${TMPDIR}/ > /dev/null
    fi

     # Delete generated file after copying
     rm -f /tmp/r4_IpcsDebugInfo.txt > /dev/null
     echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

#Generate objcli ipcs debug counter values and move it to snapshot file
collect_ipcs_debug_counters()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate ipcs debug counter values
    ${LLPD} /opt/trs/bin/objcli tls_show_ipcs_debug_counters > /tmp/ipcs_debug_counters.txt

    # Move file to TMPDIR for collection
    if [ -f /tmp/ipcs_debug_counters.txt ]; then
       cp /tmp/ipcs_debug_counters.txt ${TMPDIR}/ > /dev/null
    fi

     # Delete generated file after copying
     rm -f /tmp/ipcs_debug_counters.txt > /dev/null
     echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_firewall_logs()
{
    FIREWALL_LOG_PATH="/tmp/firewall_logs.tgz"
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    #compress file using tar
    tar -cvzf $FIREWALL_LOG_PATH /tmp/firewall/* /tmp/_firewall/* /tmp/iptables* > /dev/null

    # Move file to TMPDIR for collection
    if [ -f $FIREWALL_LOG_PATH ]; then
        cp $FIREWALL_LOG_PATH ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f $FIREWALL_LOG_PATH ]; then
       rm -f $FIREWALL_LOG_PATH > /dev/null
    fi
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_xfrm_stat()
{
    XFRM_STAT_LOG_PATH="/tmp/xfrm_stat.tgz"
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    #compress file using tar
    cp /proc/net/xfrm_stat /tmp/xfrm_stat.txt
    tar -cvzf $XFRM_STAT_LOG_PATH /tmp/xfrm_stat.txt > /dev/null

    # Move file to TMPDIR for collection
    if [ -f $XFRM_STAT_LOG_PATH ]; then
        cp $XFRM_STAT_LOG_PATH ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f $XFRM_STAT_LOG_PATH ]; then
        rm -f $XFRM_STAT_LOG_PATH > /dev/null
    fi
    if [ -f /tmp/xfrm_stat.txt ]; then
        rm -f /tmp/xfrm_stat.txt > /dev/null
    fi
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_x2mesh_tcpdump()
{
    X2MESH_TCPDUMP_PATH="/ffs/run/trs_data/x2mesh_lte1048.pcap0"
    # Move file to TMPDIR for collection
    if [ -f $X2MESH_TCPDUMP_PATH ]; then
        cp $X2MESH_TCPDUMP_PATH ${TMPDIR}/ > /dev/null
    fi
}

collect_journal_logs()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate Journal logs
    ${LLPD} journalctl -b > /tmp/journal_logs.txt
    cat /ffs/run/trs_data/active/.keystorage/.encfs6.xml > /tmp/encfsxml_log.txt
    cat /tmp/passive_contents.txt >> /tmp/encfsxml_log.txt

    #compress file using tar
    if [ -f /tmp/journal_logs.txt ]; then
       tar -cvzf /tmp/journal_logs.tgz /tmp/journal_logs.txt /tmp/encfsxml_log.txt > /dev/null
    fi

    # Move file to TMPDIR for collection
    if [ -f /tmp/journal_logs.tgz ]; then
       cp /tmp/journal_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f /tmp/journal_logs.tgz ]; then
       rm -f /tmp/journal_logs.tgz > /dev/null
    fi

    if [ -f /tmp/journal_logs.txt ]; then
       rm -f /tmp/journal_logs.txt > /dev/null
    fi
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_fpAppsDebug_logs()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate Fastpath counter logs
    /opt/trs/bin/FpAppDebugCountersDump show > /tmp/fpAppsDebugCounters_logs.txt

    #compress file using tar
    if [ -f /tmp/fpAppsDebugCounters_logs.txt ]; then
       tar -cvzf /tmp/fpAppsDebugCounters_logs.tgz /tmp/fpAppsDebugCounters_logs.txt > /dev/null
    fi

    # Move file to TMPDIR for collection
    if [ -f /tmp/fpAppsDebugCounters_logs.tgz ]; then
       cp /tmp/fpAppsDebugCounters_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    if [ -f /tmp/fpAppsDebugCounters_logs.tgz ]; then
       rm -f /tmp/fpAppsDebugCounters_logs.tgz > /dev/null
    fi

    if [ -f /tmp/fpAppsDebugCounters_logs.txt ]; then
       rm -f /tmp/fpAppsDebugCounters_logs.txt > /dev/null
    fi
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collect_fpAppsCfgDump_logs()
{

    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    # Generate Fastpath config dump logs. Logs are generated in /tmp/lte_syscom_application_ip_table.txt
    /opt/trs/bin/FpAppCfgDump
    UNIT_TYPE=$(/opt/trs/bin//test_envInfo envInfoFzmUnitType | grep "unit type" | awk '{print $5}')
    FILE_LIST="/tmp/fpAppsCfgDump_logs.tgz /tmp/lte_syscom_iwf_ul_connection_dump_table.txt /tmp/lte_syscom_iwf_dl_connection_dump_table.txt /tmp/lte_syscom_iwf_config_table.txt /tmp/lte_syscom_application_ip_table.txt /tmp/gtpu_mgmt_err_ind_table.txt /tmp/fp_ipsec_cfgfile.txt /tmp/trsxfrmbridge.txt"

   tar -cvzf $FILE_LIST > /dev/null

    # Move file to TMPDIR for collection
    if [ -f /tmp/fpAppsCfgDump_logs.tgz ]; then
       cp /tmp/fpAppsCfgDump_logs.tgz ${TMPDIR}/ > /dev/null
    fi

    # Delete generated file after copying
    rm -f $FILE_LIST > /dev/null
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Exiting ${FUNCNAME[ 0 ]}" >> ${FILENAME}
}

collectAndSendExtendedLogfiles()
{
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Entering ${FUNCNAME[ 0 ]}" >> ${FILENAME}
    local TMPDIR
    local LOGDOWNLDSTATUS="/tmp/debugLogDownloadStatus"
    touch $LOGDOWNLDSTATUS
    chmod 0644 $LOGDOWNLDSTATUS
    MT_RUN_DIR="${ROOT_DIR}/ffs/run/trs_data/db/mt"
    #Before Creating a Temp Directory, Clear if old temporary Directory exists.
    rm -rf ${TMPPATH}/${TMPPREFIX}*

    # create a tmp dir
    TMPDIR=$(mktemp -d ${TMPPATH}/${TMPPREFIX}.XXXXXX)
    GLOBALTMP=${TMPDIR}

    # Set signal handler to delete temporary dir in case of premature end of
    # the script
    trap 'onDie' TERM
    trap 'onDie' STOP
    trap 'onDie' INT

    # add core dumps
    for core_file in $COREFILE_ACTIVE; do
        tmpCore=`${LLPD} /opt/trs/www/html/protected/copyCores.sh "$core_file"`
        cp -R "$tmpCore"  ${TMPDIR}
        rm -rf "$tmpCore"
        if [ $simulation -ne 0 ]; then
            rm -f "$core_file"
        else
            case "${BTSOM_SIMULATED}" in
                yes|y|YES|Y)
                    rm -f "$core_file"
                    ;;
                *)
                    ;;
            esac
        fi
    done
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Core Dumps collected to TMPDIR" >> ${FILENAME}

    # and the passive partition core files
    for core_file in $COREFILE_PASSIVE; do
        cp -f "$core_file" "${TMPDIR}/passivePartition.$(basename "$core_file")"
        if [ $simulation -ne 0 ]; then
            rm -f "$core_file"
        else
            #FSMR3
            case "${BTSOM_SIMULATED}" in
                yes|y|YES|Y)
                    rm -f "$core_file"
                    ;;
                *)
                    ;;
            esac
        fi
    done
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Passive partition core files collected to TMPDIR" >> ${FILENAME}

    # start SCF snapshot, copy at the end of this function
    # we send this into background because we do not want this script to block
    echo "$TIMESTAMP_LOG:Line:${LINENO}:SCF Snapshot started" >> ${FILENAME}
    mkdir -p "${ROOT_DIR}${FTP_DIR}" -m 0775 >/dev/null
    objcli generate_scf >/dev/null &

    if [ "armv5teb" = "${MACHINE}" ]; then
        # Dump Counters once
        rm -f ${FTP_DIR}/getCountersReady1
        GetCounters.cgi np_tables np_debug_info > ${FTP_DIR}/Counters1.log &

        if [ -s $/tmp/HIB_reg_dump.txt ]; then
            tar -czf "${TMPDIR}/LLP_reg_dumps_1.tar.gz" /tmp/*_reg_dump.txt
            rm /tmp/*_reg_dump.txt
        fi
    fi

    if [ `isFzm` -eq 0 ]; then
        if [ "x${VIA_SEM}" == "x" ]; then
            # Sending all var logs collectively by a tar file
            trsMsg=`${LLPD} ${OPT_PROTECTED}/copyCores.sh "${VARLOGDIR}"`
            tar -cf ${TMPDIR}/linux_trs.tar $trsMsg
            rm -rf $trsMsg
            tar -cf ${TMPDIR}/linux_logs.tar $VARLOGDIR/*
        fi
    fi
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Var logs sent collectively as a tar file" >> ${FILENAME}

    # Sending procCapture logs, log files are already compressed just create the tarball
    if [ -d /var/log/procCapture ]; then
      tar -cf ${TMPDIR}/procCapture_logs.tar /var/log/procCapture/*
    fi

    echo "$TIMESTAMP_LOG:Line:${LINENO}:procCapture logs collected and compressed using tar" >> ${FILENAME}

    # Get counter & log files
    if [ "mips64" = "${MACHINE}" ]; then
        echo "############################################" > "${TMPDIR}/FPCounter.log"
        echo "### 1. $PROG_FPDEBUGACESS show " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        ${LLPD} $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        PRODUCT_TYPE=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
        ${PROGRAM_ENVINFO} envInfoProductType > /dev/null
        PROD_TYPNUM=$?
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "###### PRODUCT TYPE: " $PRODUCT_TYPE >>     "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"

        case "${TEST_ADAPTER}" in
                    yes|y|YES|Y)
            ;;
        *)
            echo "############################################" >> "${TMPDIR}/FPCounter.log"
            echo "### $PROG_FASTPATHCONFIG iptest_ip_se_log_file_support" >> "${TMPDIR}/FPCounter.log"
            echo "############################################" >> "${TMPDIR}/FPCounter.log"
            ${LLPD} $PROG_FASTPATHCONFIG iptest_ip_se_log_file_support $PROD_TYPNUM >> "${TMPDIR}/FPCounter.log" 2>&1
            ;;
        esac

        echo "$TIMESTAMP_LOG:Line:${LINENO}:FPCounter and log files collected" >> ${FILENAME}

        #Collect QoS debug info
        collect_fp_qos_logs_to_a_file > /dev/null

        if [ "LTE_WMP" == "$PRODUCT_TYPE" ]; then
            collect_r3gtp_counters > /dev/null
            #collect xfrm statistics
            collect_xfrm_stat > /dev/null
            collect_x2mesh_tcpdump > /dev/null
        fi

        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### $PROG_FASTPATHCONFIG ipsec_dump_all_test " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        ${LLPD} $PROG_FASTPATHCONFIG ipsec_dump_all_test >> "${TMPDIR}/FPCounter.log" 2>&1

        HOST_COUNTER="
        /sys/kernel/heartbeat/hbt_cntr
        /sys/kernel/fpapool/fpa_pool
        /sys/kernel/fpcidisp/cnt_fpcidp
        /sys/kernel/mcheck/reserve32
        /sys/kernel/mcheck/reserve32_freelist
        /sys/kernel/heartbeat/hbt_cntr
        /sys/kernel/fpapool/fpa_pool
      "
        for counter in $HOST_COUNTER; do
            if [ -e $counter ]; then
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                echo "### cat $counter " >> "${TMPDIR}/HostCounter.log"
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                cat $counter >> "${TMPDIR}/HostCounter.log" 2>&1
            else
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
                echo "### $counter not existing" >> "${TMPDIR}/HostCounter.log"
                echo "############################################" >> "${TMPDIR}/HostCounter.log"
            fi
        done

        echo "### MLPPP driver counter ###################" >> "${TMPDIR}/HostCounter.log"
        ${LLPD} /opt/trs/bin/fpdebugAccess mlppp >> "${TMPDIR}/HostCounter.log"
        echo "############################################" >> "${TMPDIR}/HostCounter.log"
        cp -f /tmp/transport/pppd*.log* $TMPDIR >/dev/null 2>&1

        VARTMPDIR=/var/tmp

        INIT_NAME="start_script.conf"
        TRS_CFG_DEST="${RUN_DIR}/trs_data/sim"

        if [ -s "/var/log/bist_log.txt" ]; then
            rm -f "/var/log/bist_log.txt"
        fi
        if [ -s "/var/log/FxIFSelfTest.log" ]; then
            rm -f "/var/log/FxIFSelfTest.log"
        fi
        if [ -s "/var/log/config_upgrade.xml" ]; then
            rm -f "/var/log/config_upgrade.xml"
        fi

        cp -f /rom/swconfig.txt $TMPDIR

        if [ "x${VIA_SEM}" == "x" ]; then
            cp -f /opt/trs/etc/ccs_log.txt $TMPDIR
            cp -f /ffs/run/apps/fct/AppDef*.txt $TMPDIR
            cp -f $LOGDIR/*.logs $TMPDIR
            cp -f /var/tmp/ukptTmrMon $TMPDIR

            # Copy the Last activated SCF
            if [ -f ${LAST_ACTIVATED_USER_SCF} ]; then
            cp ${LAST_ACTIVATED_USER_SCF} ${TMPDIR}
            rm ${LAST_ACTIVATED_USER_SCF}
            fi

        fi

        POSTMORTEMFILE=postmortem.bin
        for POSTMORTEM in {"${VARTMPDIR}","${VARLOGDIR}"}/"${POSTMORTEMFILE}"; do
            if [ -e $POSTMORTEM ]; then
                xz --lzma2=dict=512KiB -c $POSTMORTEM > "${TMPDIR}/${POSTMORTEMFILE}.xz"
            fi
        done

        cp -f /tmp/*table*.txt $TMPDIR
        cp -f /tmp/fp_crash_hang_log.txt $TMPDIR >/dev/null 2>&1

        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### 2. $PROG_FPDEBUGACESS show " >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        ${LLPD} $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        echo "############################################" > "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### 1. Marvel switch counters " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        # new FSIH Indoor version has port 5 and port 6.  FCTF is slot 11, but slot 0 also
        # works as it is for FCTX
        # Doc : https://sharenet-ims.int.net.nokia.com/livelink/livelink/overview/D489826968
        for interface in 0 1 2 3 4 5 6; do
            ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 1 -o 18 -n $interface >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        done
    fi

    if [ $simulation -ne 0 ]; then
        # Simulation
        cp -f $ROOT_DIR/usr/local/etc/*.ip $TMPDIR
        cp -f /tmp/tmgr.log $TMPDIR
    fi

    OURDIR=$(dirname $0)

    if [ `isFzm` -eq 1 ]; then
        if [ "armv7l" = "${MACHINE}" ]; then #FZM
           echo "############################################" >> "${TMPDIR}/IWFCounter.log"
            echo "### IWF Counter Logs                        " >> "${TMPDIR}/IWFCounter.log"
            echo "############################################" >> "${TMPDIR}/IWFCounter.log"
            cat /proc/fzm_iwf/iwf_ko >> "${TMPDIR}/IWFCounter.log" 2>&1
            echo "############################################" >> "${TMPDIR}/IWFTableDump.log"
            echo "### IWF Table Dump                          " >> "${TMPDIR}/IWFTableDump.log"
            echo "############################################" >> "${TMPDIR}/IWFTableDump.log"
            cat /proc/fzm_iwf/iwf_ko_tbl_dump >> "${TMPDIR}/IWFTableDump.log" 2>&1

            #QMSS QoS traces
            ${OURDIR}/../protected/qos_trace.sh > "${TMPDIR}/qmss_qos_dump.txt"

            #collect fpapp logs
            collect_fpapp_logs_to_a_file > /dev/null

            # collect fpctrl package
            collect_fpctrl_package_logs > /dev/null

            #collect ipcs debug counters
	    collect_ipcs_debug_counters > /dev/null

            #collect gtp counters
            collect_r3gtp_counters > /dev/null

            # collect jounral logs
            collect_journal_logs > /dev/null

            # collect firewall logs
            collect_firewall_logs > /dev/null

            # collect Fastpath Counter logs
            collect_fpAppsDebug_logs > /dev/null

            # collect Fastpath Config dump logs
            collect_fpAppsCfgDump_logs > /dev/null

            #collect xfrm statistics
            collect_xfrm_stat > /dev/null

            # collect broadcom statitistics in case of 4 port hardware.
            UNIT_TYPE=$(/opt/trs/bin//test_envInfo envInfoFzmUnitType | grep "unit type" | awk '{print $5}')
            if [ $UNIT_TYPE == "FW2EHWB" ] || [ $UNIT_TYPE == "FW2EHB" ] || [ $UNIT_TYPE == "FW2QQF" ] || [ $UNIT_TYPE == "FW2QQWF" ]; then
            collect_bcmswitch_stats_logs > /dev/null
            else
            #L2 QoS counter traces
            ${OURDIR}/../protected/l2qos_trace.sh > "${TMPDIR}/l2qos_counters_dump.txt"
            fi

            if [ -f "/var/log/config_reset.log" ] ; then
                cp -rf /var/log/config_reset.log ${TMPDIR}/config_reset.log
	    fi

	    if [ -f "/ffs/run/trs_data/db/port_swap.db" ]; then
		cp -rf /ffs/run/trs_data/db/port_swap.db ${TMPDIR}/port_swap.txt
	    fi
        fi
    fi

    # Collect Traces
    ${OURDIR}/../protected/ukptTraces.sh > "${TMPDIR}/Traces.log"
    echo "$TIMESTAMP_LOG:Line:${LINENO}:Traces collected using /protected/ukptTraces.sh" >> ${FILENAME}

    # Add extended information
    ${OURDIR}/../protected/ShowLocalSettings.cgi > "${TMPDIR}/ExtendedSystemInfo.log"
    echo "$TIMESTAMP_LOG:Line:${LINENO}:ExtendedSystemInfo.log collected using /protected/ShowLocalSettings.cgi" >> ${FILENAME}

    if [ `isFzm` -eq 1 ]; then
        #Collect Wpa Supplicant Logs
        collect_wpa_supplicant_logs > /dev/null
    fi

    #FSMR4
    if [ `isFsmr4` -eq 1 ]; then

        echo " " >> "${TMPDIR}/ExtendedSystemInfo.log"
        echo "*********************************" >> "${TMPDIR}/ExtendedSystemInfo.log"
        echo "        ifconfig rio0m3          " >> "${TMPDIR}/ExtendedSystemInfo.log"
        echo "*********************************" >> "${TMPDIR}/ExtendedSystemInfo.log"
        ifconfig rio0m3 >> "${TMPDIR}/ExtendedSystemInfo.log"
        echo "*********************************" >> "${TMPDIR}/ExtendedSystemInfo.log"
        echo " " >> "${TMPDIR}/ExtendedSystemInfo.log"

        mkdir /tmp/fsmr4
        if [[ "$filename" = /ffs/run/logs/EmTRSCrashLogs.tgz ]]; then
            ${OURDIR}/../protected/Fsmr4_vtclogs.sh skip_iwf_logs
        else
            ${OURDIR}/../protected/Fsmr4_vtclogs.sh
        fi
        cp -rf /tmp/fsmr4/* ${TMPDIR}
        if [ -f /ffs/run/logs/synce_log.txt ]; then
            cp -rf /ffs/run/logs/synce_log.* ${TMPDIR}
        fi
        cp -rf /ffs/run/swconfig.txt ${TMPDIR}
        rm -rf /tmp/fsmr4/
        collect_r4gtp_counters > /dev/null
        if [ -f /shareTmp/eth_intf_stats.txt ]; then
            cp -rf /shareTmp/eth_intf_stats.txt ${TMPDIR}
        fi
        if [ -f /shareTmp/runtime_intf_stats.txt ]; then
            cp -rf /shareTmp/runtime_intf_stats.txt ${TMPDIR}
        fi
        PRODUCT_TYPE=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
        if [ "LTE_WMP" == "$PRODUCT_TYPE" ]; then
            collect_xfrm_stat > /dev/null
            collect_x2mesh_tcpdump > /dev/null
        fi
    fi


    # Add FTIF information

    if [ "mips64" = "${MACHINE}" ]; then
        rm -f /tmp/trs/tftpboot/ftif_tmp
        /opt/trs/bin/ftifPresent > /dev/null 2>&1
        if [ -e /tmp/trs/tftpboot/ftif_tmp ]; then
            /opt/trs/bin/elogClient > /dev/null 2>&1 &
            sleep 30
            if [ -s /tmp/trs/tftpboot/ftif_tmp ]; then
                mv -f /tmp/trs/tftpboot/ftif_tmp /tmp/trs/tftpboot/ftif_logs.tgz
                mv -f /tmp/trs/tftpboot/ftif_logs.tgz $TMPDIR

                if [ -s /tmp/trs/tftpboot/ftif_core ]; then
                    mv -f /tmp/trs/tftpboot/ftif_core $TMPDIR
                    touch /tmp/trs/tftpboot/ftif_core
                fi
            fi
        fi
    fi

    # Add post-mortem informations
    if [ -e $LOGDIR/shmem_Trace ]
    then
        rm $LOGDIR/shmem_Trace
    fi
    if [ -e $LOGDIR/SwmTrace.xml ]
    then
        rm $LOGDIR/SwmTrace.xml
    fi

    if [ `isFzm` -eq 1 ]; then
        find $LOGDIR -name 'TraceLog*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    else
        find $LOGDIR -name '*Trace*' | grep -v $TMPPREFIX | grep -v "HWRBbTraceSExe" | while read file; do cp -f "$file" $TMPDIR; done
    fi

    if [ -e $STBLOGDIR/shmem_Trace ]
    then
        rm $STBLOGDIR/shmem_Trace
    fi
    if [ -e $STBLOGDIR/SwmTrace.xml ]
    then
        rm $STBLOGDIR/SwmTrace.xml
    fi

    if [ `isFzm` -eq 1 ]; then
        find $STBLOGDIR -name 'TraceLog*' | grep -v $TMPPREFIX | while read file; do cp -f "$file" $TMPDIR; done
    else
        find $STBLOGDIR -name '*Trace*' | grep -v $TMPPREFIX | grep -v "HWRBbTraceSExe" | while read file; do cp -f "$file" $TMPDIR; done
    fi

    # TAUF extension
    if [ -x /usr/local/bin/tauf/run_tauf ]; then
        /usr/local/bin/tauf/run_tauf >/dev/null
        mv -f /tmp/tauf_logs ${TMPDIR}
    fi

    # adding active backtrace files
    for file in $BACKTRACE_ACTIVE_FILES; do
        cp -f $file ${TMPDIR}
        case "${BTSOM_SIMULATED}" in
            yes|y|YES|Y)
                rm -f "$file"
                ;;
            *)
                ;;
        esac
    done

    # adding passive backtrace files
    for file in $BACKTRACE_PASSIVE_FILES; do
        cp -f $file ${TMPDIR}/passive_$(basename $file)
        case "${BTSOM_SIMULATED}" in
            yes|y|YES|Y)
                rm -f "$file"
                ;;
            *)
                ;;
        esac
    done

    if [ "armv5teb" = "${MACHINE}" ]; then
        # Dump Counters once for the second time, but including the np_tables
        rm -f ${FTP_DIR}/getCountersReady2
        ${OURDIR}/GetCounters.cgi > ${FTP_DIR}/Counters2.log &

        if [ -s /tmp/HIB_reg_dump.txt ]; then
            tar -czf ${TMPDIR}/LLP_reg_dumps_2.tar.gz /tmp/*_reg_dump.txt
            rm /tmp/*_reg_dump.txt
        fi
        # On Octeon: retrieve remote static log and add to logfile
        test_envInfo envInfoOcteonAvailable >/dev/null
        if [ 0 -eq $? ]; then
            mkdir -p /tmp/remoteLogDir -m 0775 >/dev/null
            mkdir -p ${TMPDIR}/octeonLogs -m 0775 >/dev/null
            ukpt remoteLog extendedLog >/dev/null
            cp -r /tmp/remoteLogDir/* ${TMPDIR}/octeonLogs >/dev/null
            rm -rf /tmp/remoteLogDir >/dev/null
        fi
    fi

    if [ -s "${ROOT_DIR}${FTP_DIR}/SelfTest.txt" ]; then
        cp -f "${ROOT_DIR}${FTP_DIR}/SelfTest.txt" ${TMPDIR}
    fi

    #trsOverloadProtection logs
    trsOverloadlogDir="/ffs/run/logs/mon/*"
    for trsoverloadlogfile in $trsOverloadlogDir
    do
        if [ -f $trsoverloadlogfile ]; then
            cp -f "$trsoverloadlogfile" ${TMPDIR} >/dev/null
        fi
    done

    #FpCounter logs files for 24hrs
    fpCounterLogDir="/ffs/run/logs/TrsFPStats/*"
    for fpCounterLogfile in $fpCounterLogDir
    do
        if [ -f $fpCounterLogfile ]; then
            cp -f "$fpCounterLogfile" ${TMPDIR} >/dev/null
        fi
    done
	cp -f /tmp/transport/TrsFPStats/* ${TMPDIR} >/dev/null


    if [ $simulation -ne 0 ]; then
        if [ -s "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ]; then
            cp -f "${ROOT_DIR}/usr/local/etc/config/ConfigurationMigration.log" ${TMPDIR}
        fi
    else
        if [ -s "${STB_DIR}/trs_data/active/ConfigurationMigration.log" ]; then
            cp "${STB_DIR}/trs_data/active/ConfigurationMigration.log" ${TMPDIR}
        fi
        if [ -s "${STB_DIR}/trs_data/passive/ConfigurationMigration.log" ]; then
            cp "${STB_DIR}/trs_data/passive/ConfigurationMigration.log" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/TmlParsing.txt" ]; then
            cp "${RUN_DIR}/trs_data/active/TmlParsing.txt" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/config_upgrade.xml" ]; then
            cp "${RUN_DIR}/trs_data/active/config_upgrade.xml" ${TMPDIR}
        fi
        if [ -s "${RUN_DIR}/trs_data/active/FxIFSelfTest.log" ]; then
            cp "${RUN_DIR}/trs_data/active/FxIFSelfTest.log" $TMPDIR
        fi
        if [ -s "${RUN_DIR}/trs_data/active/bist_log.txt" ]; then
            cp "${RUN_DIR}/trs_data/active/bist_log.txt" $TMPDIR
        fi
    fi

    # now copy data of background collections, timeout applies
    if [ "armv5teb" = "${MACHINE}" ]; then
        for index in {1..10}; do
            if [ -e "${FTP_DIR}/getCountersReady1" ]; then
                gzip -c -q -1 ${FTP_DIR}/Counters1.log > "${TMPDIR}/Counters.log.gz"
                break
            fi
            sleep 1
        done
        for index in {1..10}; do
            if [ -e "${FTP_DIR}/getCountersReady2" ]; then
                gzip -c -q -1 ${FTP_DIR}/Counters2.log >> "${TMPDIR}/Counters.log.gz"
                break
            fi
            sleep 1
        done
    fi
    for index in {1..15}; do
        if [ -e "${ROOT_DIR}${FTP_DIR}/configDumpReady" ]; then
            cp -f "${ROOT_DIR}${FTP_DIR}/config.xml" ${TMPDIR} >/dev/null
            break
        fi
        sleep 2
    done

    # RLe: leave this as last one. Otherwise the current traces might miss informations
    # Create Dump file for current settings
    ${LLPD} /opt/trs/bin/ukpt dump "${TMPDIR}/FtmDump.bin" >/dev/null

    #MbTac Dump rnd-settings and fp-dscp values into files for extended log library
    PRODUCT_TYPE=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
    if [ "WCDMA" != "$PRODUCT_TYPE" ]; then
        objcli show_rnd_mbtac_settings > "${TMPDIR}/MbTacRnDSettings.txt" 2>&1
        cp /tmp/MbTacMeasTracing* ${TMPDIR}
        cp /tmp/MbTacErgTracing* ${TMPDIR}
    fi

    # Copy TRS Crash Log to TMPDIR
    if [ -f ${TRSCRASHLOG} ]; then
        echo "TRS Crash Logs Found in the ${RUN_DIR}/logs directory" >> "${TMPDIR}/ExtendedSystemInfo.log"
        cp ${TRSCRASHLOG} ${TMPDIR}/
        rm -f ${TRSCRASHLOG}
    fi
    if [ -f ${EMTRSCRASHLOG} ]; then
        echo "TRS Crash Logs Found in the ${RUN_DIR}/logs directory" >> "${TMPDIR}/ExtendedSystemInfo.log"
        cp ${EMTRSCRASHLOG} ${TMPDIR}/
        rm -f ${EMTRSCRASHLOG}
    fi

    if [ "mips64" = "${MACHINE}" ]; then
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        echo "### 3. $PROG_FPDEBUGACESS show" >> "${TMPDIR}/FPCounter.log"
        echo "############################################" >> "${TMPDIR}/FPCounter.log"
        ${LLPD} $PROG_FPDEBUGACESS show >> "${TMPDIR}/FPCounter.log" 2>&1

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### The state of Murrku MUX " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 3 -n 0 -o 0 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### State of EIF2/5/SFP interface " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "/sys/class/misc/mdioctl/eif2aneg  : " `cat /sys/class/misc/mdioctl/eif2aneg` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        for i in 5 9 10; do

           echo "/sys/class/sfp/sfp_0_$i/mod_abs : " `cat /sys/class/sfp/sfp_0_$i/mod_abs` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "/sys/class/sfp/sfp_0_$i/rx_los : " `cat /sys/class/sfp/sfp_0_$i/rx_los`  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "/sys/class/sfp/sfp_0_$i/tx_fault : " `cat /sys/class/sfp/sfp_0_$i/tx_fault`  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "/sys/class/sfp/sfp_0_$i/tx_disable : " `cat /sys/class/sfp/sfp_0_$i/tx_disable`  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "/sys/class/sfp/sfp_0_$i/base_id/Transceiver1 : " `cat /sys/class/sfp/sfp_0_$i/base_id/Transceiver1` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "/sys/class/sfp/sfp_0_$i/vendor_specific_id/Vendor_Specific_EEPROM : " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           cat /sys/class/sfp/sfp_0_$i/vendor_specific_id/Vendor_Specific_EEPROM >> "${TMPDIR}/ExtendedInterfaceCounter.log"

        done

        if [ $UNIT == "UNIT_FCTF" ]; then
           echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "### All interface states :FCTF" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 0 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 1 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 2 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 3 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 4 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n 5 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

           #DDAL test tool results
           for i in 0 3 4 ; do
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*** DDAL test tool results ***" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "### /opt/trs/bin/ddal_test_tool -s 11 -d 0 -n $i -o 11  ### " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             ${LLPD}  $PROG_DDAL_TEST_TOOL -s 11 -d 0 -n $i -o 11  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             cat /tmp/ddal_reg_value_dump.txt >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo " " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           done

        else
           echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "### All interface states :FCTB" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 0 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 1 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n 2 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

           ${LLPD} $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 0 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 1 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 2 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           ${LLPD} $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n 3 -o 4 >> "${TMPDIR}/ExtendedInterfaceCounter.log"

           #DDAL test tool results
           for i in 0 1; do
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*** DDAL test tool results ***" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "### /opt/trs/bin/ddal_test_tool -s 0 -d 0 -n $i -o 11  ### " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 0 -n $i -o 11  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             cat /tmp/ddal_reg_value_dump.txt >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo " " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           done
           #FTIF DDAL test tool results
           for i in 2 3 ; do
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*** FTIF DDAL test tool results ***" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "### /opt/trs/bin/ddal_test_tool -s 2 -d 0 -n $i -o 11  ### " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo "*******************************************" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             ${LLPD}  $PROG_DDAL_TEST_TOOL -s 2 -d 0 -n $i -o 11  >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             cat /tmp/ddal_reg_value_dump.txt >> "${TMPDIR}/ExtendedInterfaceCounter.log"
             echo " " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
           done


        fi

        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "### 2. Marvel switch counters " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        for interface in 0 1 2 3 4 5 6; do
            ${LLPD} $PROG_DDAL_TEST_TOOL -s 0 -d 1 -o 18 -n $interface >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        done

        ${LLPD} $PROG_DDAL_TEST_TOOL -s 2 -d 6 -n 0 -o 1 -v data=5 | grep -q 'Status= PRESENT'
        if [ $? -eq 0 ]; then
            echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "### Synce MUX Configurations: " >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "############################################" >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${FPGA_FILEPATH}/sync_pll_ref1 : " `cat ${FPGA_FILEPATH}/sync_pll_ref1` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${FPGA_FILEPATH}/ctrl_nclki    : " `cat ${FPGA_FILEPATH}/ctrl_nclki` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${FPGA_FILEPATH}/ctrl_rclk1_en : " `cat ${FPGA_FILEPATH}/ctrl_rclk1_en` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_sel_ref : " `cat ${SYNCETH_FILEPATH}/synceth_sel_ref` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_state : " `cat ${SYNCETH_FILEPATH}/synceth_state` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_is_active : " `cat ${SYNCETH_FILEPATH}/synceth_is_active` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_id : " `cat ${SYNCETH_FILEPATH}/synceth_id` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_ref0_status : " `cat ${SYNCETH_FILEPATH}/synceth_ref0_status` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_enable_25m_output : " `cat ${SYNCETH_FILEPATH}/synceth_enable_25m_output` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
            echo "${SYNCETH_FILEPATH}/synceth_enable_2m048_output : " `cat ${SYNCETH_FILEPATH}/synceth_enable_2m048_output` >> "${TMPDIR}/ExtendedInterfaceCounter.log"
        fi
    fi

    if [ "WCDMA" == "$PRODUCT_TYPE" ]; then
        cp ${ROOT_DIR}/tmp/ppp_channelid_to_mplslabel_mapping_table.txt ${TMPDIR} >/dev/null 2>&1
        cp ${ROOT_DIR}/tmp/srio_reass_ctx_print_table.txt ${TMPDIR} >/dev/null 2>&1
        cp ${ROOT_DIR}/tmp/wcdma_syscom_iwf*.txt ${TMPDIR} >/dev/null 2>&1
    fi

    # Copy TRS Static SysCom Routes XML file
    cp ${ROOT_DIR}/tmp/SysComRoute-*.xml ${TMPDIR} >/dev/null 2>&1

    # Copy Bootup Wireshark log
    cp ${TRSBOOTUPTCPDUMP} ${TMPDIR} >/dev/null 2>&1

    cp -f /tmp/*Failure.txt ${TMPDIR} >/dev/null 2>&1

    # Copy Traffic Mirroring Memory Allocation Status File
    cp ${TRS_TRAFCMIRR_MEMALLOC_STATUS} ${TMPDIR} >/dev/null 2>&1

    chmod ug+rw -R ${TMPDIR} >/dev/null
    # bundle the thing
    if [ $# -eq 1 ]; then
      # to file $filename
        if [ `isFzm` -eq 1 ] && [ -d "${MT_RUN_DIR}" ]; then
           tar -czvf $filename ${TMPDIR}
        else
           tar -c -C ${TMPDIR} . | gzip -c -q > $filename
        fi
    else
      # dump to standard out
        tar -c -C ${TMPDIR} . | gzip -c -q
    fi

    rm -rf ${TMPDIR}
    rm -f $LOGDOWNLDSTATUS
    rm -rf /tmp/*Failure.txt
    rm -rf $DIR_PATH/*Failure.txt
}

#114005ESPE04 - Lock added so that only one log collection
#will be triggered at a time
LOCKFILEDIR=${ROOT_DIR}/tmp/.`basename "$0"`.lock
mkdir -p $(dirname $LOCKFILEDIR)

if mkdir $LOCKFILEDIR > /dev/null 2>&1; then

ETAG="`date -u +%s 2>/dev/null`"

cat <<EOF
Content-Disposition: attachment; filename="$filename"
X-content-type-options: nosniff
Etag: $ETAG
Expires: -1
EOF

cache_control

cat <<EOF
Connection: Keep-Alive 800
Content-type: application/x-tar-gz

EOF

    collectAndSendExtendedLogfiles ${1+"$@"} </dev/null 2>/dev/null
    rmdir $LOCKFILEDIR 2>/dev/null
else
  echo "Another log file generation is in progress. Please try after some time."
fi

if [ -f "$FILENAME" ]; then
   rm -rf $FILENAME
fi
